/*
 * Decompiled with CFR 0.152.
 */
package org.clang.basic.target;

import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.Unsigned;
import org.llvm.support.llvm_unreachable;

public class TargetCXXABI {
    private Kind TheKind;

    public TargetCXXABI() {
        this.TheKind = Kind.GenericItanium;
    }

    public TargetCXXABI(Kind kind) {
        this.TheKind = kind;
    }

    public void set(Kind kind) {
        this.TheKind = kind;
    }

    public Kind getKind() {
        return this.TheKind;
    }

    public boolean isItaniumFamily() {
        switch (this.getKind()) {
            case GenericAArch64: 
            case GenericItanium: 
            case GenericARM: 
            case iOS: 
            case iOS64: 
            case WatchOS: 
            case GenericMIPS: 
            case WebAssembly: {
                return true;
            }
            case Microsoft: {
                return false;
            }
        }
        throw new llvm_unreachable("bad ABI kind");
    }

    public boolean isMicrosoft() {
        switch (this.getKind()) {
            case GenericAArch64: 
            case GenericItanium: 
            case GenericARM: 
            case iOS: 
            case iOS64: 
            case WatchOS: 
            case GenericMIPS: 
            case WebAssembly: {
                return false;
            }
            case Microsoft: {
                return true;
            }
        }
        throw new llvm_unreachable("bad ABI kind");
    }

    public boolean areMemberFunctionsAligned() {
        switch (this.getKind()) {
            case WebAssembly: {
                return false;
            }
            case GenericAArch64: 
            case GenericItanium: 
            case GenericARM: 
            case iOS: 
            case iOS64: 
            case WatchOS: 
            case GenericMIPS: 
            case Microsoft: {
                return true;
            }
        }
        throw new llvm_unreachable("bad ABI kind");
    }

    public boolean isMemberFunctionCCDefault() {
        return !this.isMicrosoft();
    }

    public boolean areArgsDestroyedLeftToRightInCallee() {
        return this.isMicrosoft();
    }

    public boolean hasConstructorVariants() {
        return this.isItaniumFamily();
    }

    public boolean hasPrimaryVBases() {
        return this.isItaniumFamily();
    }

    public boolean hasKeyFunctions() {
        return this.isItaniumFamily();
    }

    public boolean canKeyFunctionBeInline() {
        switch (this.getKind()) {
            case GenericARM: 
            case iOS64: 
            case WatchOS: 
            case WebAssembly: {
                return false;
            }
            case GenericAArch64: 
            case GenericItanium: 
            case iOS: 
            case GenericMIPS: 
            case Microsoft: {
                return true;
            }
        }
        throw new llvm_unreachable("bad ABI kind");
    }

    public TailPaddingUseRules getTailPaddingUseRules() {
        switch (this.getKind()) {
            case GenericAArch64: 
            case GenericItanium: 
            case GenericARM: 
            case iOS: 
            case GenericMIPS: {
                return TailPaddingUseRules.UseTailPaddingUnlessPOD03;
            }
            case iOS64: 
            case WatchOS: 
            case WebAssembly: {
                return TailPaddingUseRules.UseTailPaddingUnlessPOD11;
            }
            case Microsoft: {
                return TailPaddingUseRules.AlwaysUseTailPadding;
            }
        }
        throw new llvm_unreachable("bad ABI kind");
    }

    public static boolean $eq_TargetCXXABI(TargetCXXABI left, TargetCXXABI right) {
        return left.getKind() == right.getKind();
    }

    public static boolean $noteq_TargetCXXABI(TargetCXXABI left, TargetCXXABI right) {
        return !TargetCXXABI.$eq_TargetCXXABI(left, right);
    }

    public TargetCXXABI(TargetCXXABI $Prm0) {
        this.TheKind = $Prm0.TheKind;
    }

    public TargetCXXABI(JavaDifferentiators.JD.Move _dparam, TargetCXXABI $Prm0) {
        this.TheKind = $Prm0.TheKind;
    }

    public String toString() {
        return "TheKind=" + (Object)((Object)this.TheKind);
    }

    public static final class TailPaddingUseRules
    extends Enum<TailPaddingUseRules>
    implements Native.ComparableLower {
        public static final /* enum */ TailPaddingUseRules AlwaysUseTailPadding = new TailPaddingUseRules(0);
        public static final /* enum */ TailPaddingUseRules UseTailPaddingUnlessPOD03 = new TailPaddingUseRules(AlwaysUseTailPadding.getValue() + 1);
        public static final /* enum */ TailPaddingUseRules UseTailPaddingUnlessPOD11 = new TailPaddingUseRules(UseTailPaddingUnlessPOD03.getValue() + 1);
        private final int value;
        private static final /* synthetic */ TailPaddingUseRules[] $VALUES;

        public static TailPaddingUseRules[] values() {
            return (TailPaddingUseRules[])$VALUES.clone();
        }

        public static TailPaddingUseRules valueOf(String name) {
            return Enum.valueOf(TailPaddingUseRules.class, name);
        }

        public static TailPaddingUseRules valueOf(int val) {
            TailPaddingUseRules out;
            TailPaddingUseRules tailPaddingUseRules = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            assert (out.value == val) : "asked [" + val + "] got " + (Object)((Object)out) + ":" + out.value + "]";
            return out;
        }

        private TailPaddingUseRules(int val) {
            this.value = val;
        }

        public int getValue() {
            return this.value;
        }

        public boolean $less(Object obj) {
            return Unsigned.$less_uint((int)this.value, (int)((TailPaddingUseRules)((Object)obj)).value);
        }

        public boolean $lesseq(Object obj) {
            return Unsigned.$lesseq_uint((int)this.value, (int)((TailPaddingUseRules)((Object)obj)).value);
        }

        static {
            $VALUES = new TailPaddingUseRules[]{AlwaysUseTailPadding, UseTailPaddingUnlessPOD03, UseTailPaddingUnlessPOD11};
        }

        private static final class Values {
            private static final TailPaddingUseRules[] VALUES;
            private static final TailPaddingUseRules[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (TailPaddingUseRules kind : TailPaddingUseRules.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new TailPaddingUseRules[min < 0 ? 1 - min : 0];
                VALUES = new TailPaddingUseRules[max >= 0 ? 1 + max : 0];
                for (TailPaddingUseRules kind : TailPaddingUseRules.values()) {
                    if (kind.value < 0) {
                        Values._VALUES[-((TailPaddingUseRules)kind).value] = kind;
                        continue;
                    }
                    Values.VALUES[((TailPaddingUseRules)kind).value] = kind;
                }
            }
        }
    }

    public static final class Kind
    extends Enum<Kind>
    implements Native.ComparableLower {
        public static final /* enum */ Kind GenericItanium = new Kind(0);
        public static final /* enum */ Kind GenericARM = new Kind(GenericItanium.getValue() + 1);
        public static final /* enum */ Kind iOS = new Kind(GenericARM.getValue() + 1);
        public static final /* enum */ Kind iOS64 = new Kind(iOS.getValue() + 1);
        public static final /* enum */ Kind WatchOS = new Kind(iOS64.getValue() + 1);
        public static final /* enum */ Kind GenericAArch64 = new Kind(WatchOS.getValue() + 1);
        public static final /* enum */ Kind GenericMIPS = new Kind(GenericAArch64.getValue() + 1);
        public static final /* enum */ Kind WebAssembly = new Kind(GenericMIPS.getValue() + 1);
        public static final /* enum */ Kind Microsoft = new Kind(WebAssembly.getValue() + 1);
        private final int value;
        private static final /* synthetic */ Kind[] $VALUES;

        public static Kind[] values() {
            return (Kind[])$VALUES.clone();
        }

        public static Kind valueOf(String name) {
            return Enum.valueOf(Kind.class, name);
        }

        public static Kind valueOf(int val) {
            Kind out;
            Kind kind = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            assert (out.value == val) : "asked [" + val + "] got " + (Object)((Object)out) + ":" + out.value + "]";
            return out;
        }

        private Kind(int val) {
            this.value = val;
        }

        public int getValue() {
            return this.value;
        }

        public boolean $less(Object obj) {
            return Unsigned.$less_uint((int)this.value, (int)((Kind)((Object)obj)).value);
        }

        public boolean $lesseq(Object obj) {
            return Unsigned.$lesseq_uint((int)this.value, (int)((Kind)((Object)obj)).value);
        }

        static {
            $VALUES = new Kind[]{GenericItanium, GenericARM, iOS, iOS64, WatchOS, GenericAArch64, GenericMIPS, WebAssembly, Microsoft};
        }

        private static final class Values {
            private static final Kind[] VALUES;
            private static final Kind[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (Kind kind : Kind.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new Kind[min < 0 ? 1 - min : 0];
                VALUES = new Kind[max >= 0 ? 1 + max : 0];
                for (Kind kind : Kind.values()) {
                    if (kind.value < 0) {
                        Values._VALUES[-((Kind)kind).value] = kind;
                        continue;
                    }
                    Values.VALUES[((Kind)kind).value] = kind;
                }
            }
        }
    }
}

