/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.httpserver;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.netbeans.modules.httpserver.HttpServerSettings;
import org.netbeans.modules.httpserver.HttpServerURLMapper;
import org.netbeans.modules.httpserver.NbBaseServlet;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.NbBundle;

public class WrapperServlet
extends NbBaseServlet {
    private static final long serialVersionUID = 8009602136746998361L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!this.checkAccess(request)) {
            response.sendError(403, NbBundle.getMessage(WrapperServlet.class, (String)"MSG_HTTP_FORBIDDEN"));
            return;
        }
        ServletOutputStream out = response.getOutputStream();
        try {
            int len;
            String requestURL = this.getRequestURL(request);
            HttpServerURLMapper serverMapper = new HttpServerURLMapper();
            FileObject[] files = serverMapper.getFileObjects(new URL(requestURL));
            if (files == null || files.length != 1) {
                throw new IOException();
            }
            URL internal = URLMapper.findURL((FileObject)files[0], (int)0);
            URLConnection conn = internal.openConnection();
            String type = conn.getContentType();
            if (type == null || "content/unknown".equals(type)) {
                type = files[0].getMIMEType();
            }
            if ((type == null || "content/unknown".equals(type)) && files[0].getExt().equals("css")) {
                type = "text/css";
            }
            response.setContentType(type);
            InputStream in = conn.getInputStream();
            byte[] buff = new byte[256];
            while ((len = in.read(buff)) != -1) {
                out.write(buff, 0, len);
                out.flush();
            }
            in.close();
        }
        catch (MalformedURLException ex) {
            try {
                response.sendError(404, NbBundle.getMessage(WrapperServlet.class, (String)"MSG_HTTP_NOT_FOUND"));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        catch (IOException ex) {
            try {
                response.sendError(500);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        finally {
            try {
                out.close();
            }
            catch (Exception ex) {}
        }
    }

    private String getRequestURL(HttpServletRequest request) throws UnknownHostException, MalformedURLException {
        HttpServerSettings settings = HttpServerSettings.getDefault();
        String pi = request.getPathInfo();
        if (pi.startsWith("/")) {
            pi = pi.substring(1);
        }
        URL reconstructedURL = new URL("http", InetAddress.getLocalHost().getHostName(), settings.getPort(), settings.getWrapperBaseURL() + pi.toString());
        return reconstructedURL.toExternalForm();
    }

    @Override
    public String getServletInfo() {
        return NbBundle.getMessage(WrapperServlet.class, (String)"MSG_WrapperServletDescr");
    }
}

