/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.analysis.ui.options;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.php.analysis.commands.CodingStandardsFixer;
import org.netbeans.modules.php.analysis.options.AnalysisOptions;
import org.netbeans.modules.php.analysis.options.AnalysisOptionsValidator;
import org.netbeans.modules.php.analysis.ui.options.AnalysisCategoryPanel;
import org.netbeans.modules.php.analysis.ui.options.Bundle;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.api.util.UiUtils;
import org.netbeans.modules.php.api.validation.ValidationResult;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class CodingStandardsFixerOptionsPanel
extends AnalysisCategoryPanel {
    private static final long serialVersionUID = 4988988248465791859L;
    private static final String CODING_STANDARDS_FIXER_LAST_FOLDER_SUFFIX = ".codingStandarsFixer";
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private JButton codingStandardsFixerBrowseButton;
    private JComboBox codingStandardsFixerConfigComboBox;
    private JLabel codingStandardsFixerConfigLabel;
    private JLabel codingStandardsFixerHintLabel;
    private JLabel codingStandardsFixerLabel;
    private JLabel codingStandardsFixerLearnMoreLabel;
    private JComboBox codingStandardsFixerLevelComboBox;
    private JLabel codingStandardsFixerLevelLabel;
    private JLabel codingStandardsFixerOptionsLabel;
    private JTextField codingStandardsFixerOptionsTextField;
    private JButton codingStandardsFixerSearchButton;
    private JTextField codingStandardsFixerTextField;
    private JLabel noteLabel;

    public CodingStandardsFixerOptionsPanel() {
        this.initComponents();
        this.init();
    }

    private void init() {
        DefaultDocumentListener defaultDocumentListener = new DefaultDocumentListener();
        this.initCodingStandardsFixer(defaultDocumentListener);
        this.codingStandardsFixerLevelComboBox.setModel(new DefaultComboBoxModel<Object>(CodingStandardsFixer.ALL_LEVEL.toArray()));
        this.codingStandardsFixerConfigComboBox.setModel(new DefaultComboBoxModel<Object>(CodingStandardsFixer.ALL_CONFIG.toArray()));
    }

    private void initCodingStandardsFixer(DocumentListener defaultDocumentListener) {
        this.codingStandardsFixerHintLabel.setText(Bundle.CodingStandardsFixerOptionsPanel_hint("php-cs-fixer", "php-cs-fixer.phar"));
        this.codingStandardsFixerLevelComboBox.setModel(new DefaultComboBoxModel());
        this.codingStandardsFixerTextField.getDocument().addDocumentListener(defaultDocumentListener);
        this.codingStandardsFixerOptionsTextField.getDocument().addDocumentListener(defaultDocumentListener);
        ActionListener defaultAL = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CodingStandardsFixerOptionsPanel.this.fireChange();
            }
        };
        this.codingStandardsFixerLevelComboBox.addActionListener(defaultAL);
        this.codingStandardsFixerConfigComboBox.addActionListener(defaultAL);
    }

    public String getCodingStandardsFixerPath() {
        return this.codingStandardsFixerTextField.getText();
    }

    public void setCodingStandardsFixerPath(String path) {
        this.codingStandardsFixerTextField.setText(path);
    }

    @CheckForNull
    public String getCodingStandardsFixerLevel() {
        return (String)this.codingStandardsFixerLevelComboBox.getSelectedItem();
    }

    public void setCodingStandardsFixerLevel(String level) {
        this.codingStandardsFixerLevelComboBox.setSelectedItem(level);
    }

    @CheckForNull
    public String getCodingStandardsFixerConfig() {
        return (String)this.codingStandardsFixerConfigComboBox.getSelectedItem();
    }

    public void setCodingStandardsFixerConfig(String config) {
        this.codingStandardsFixerConfigComboBox.setSelectedItem(config);
    }

    public String getCodingStandardsFixerOptions() {
        return this.codingStandardsFixerOptionsTextField.getText();
    }

    public void setCodingStandardsFixerOptoins(String options) {
        this.codingStandardsFixerOptionsTextField.setText(options);
    }

    @Override
    public String getCategoryName() {
        return Bundle.CodingStandardsFixerOptionsPanel_category_name();
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    @Override
    public void update() {
        AnalysisOptions analysisOptions = AnalysisOptions.getInstance();
        this.setCodingStandardsFixerPath(analysisOptions.getCodingStandardsFixerPath());
        this.setCodingStandardsFixerLevel(analysisOptions.getCodingStandardsFixerLevel());
        this.setCodingStandardsFixerConfig(analysisOptions.getCodingStandardsFixerConfig());
        this.setCodingStandardsFixerOptoins(analysisOptions.getCodingStandardsFixerOptions());
    }

    @Override
    public void applyChanges() {
        AnalysisOptions analysisOptions = AnalysisOptions.getInstance();
        analysisOptions.setCodingStandardsFixerPath(this.getCodingStandardsFixerPath());
        analysisOptions.setCodingStandardsFixerLevel(this.getCodingStandardsFixerLevel());
        analysisOptions.setCodingStandardsFixerConfig(this.getCodingStandardsFixerConfig());
        analysisOptions.setCodingStandardsFixerOptions(this.getCodingStandardsFixerOptions());
    }

    @Override
    public boolean isChanged() {
        String saved = AnalysisOptions.getInstance().getCodingStandardsFixerPath();
        String current = this.getCodingStandardsFixerPath().trim();
        if (saved == null ? !current.isEmpty() : !saved.equals(current)) {
            return true;
        }
        saved = AnalysisOptions.getInstance().getCodingStandardsFixerLevel();
        current = this.getCodingStandardsFixerLevel();
        if (saved == null ? StringUtils.hasText((String)current) : !saved.equals(current)) {
            return true;
        }
        saved = AnalysisOptions.getInstance().getCodingStandardsFixerConfig();
        current = this.getCodingStandardsFixerConfig();
        if (saved == null ? StringUtils.hasText((String)current) : !saved.equals(current)) {
            return true;
        }
        saved = AnalysisOptions.getInstance().getCodingStandardsFixerOptions();
        return !saved.equals(current = this.getCodingStandardsFixerOptions());
    }

    @Override
    public ValidationResult getValidationResult() {
        return new AnalysisOptionsValidator().validateCodingStandardsFixer(this.getCodingStandardsFixerPath()).getResult();
    }

    void fireChange() {
        this.changeSupport.fireChange();
    }

    private void initComponents() {
        this.codingStandardsFixerLabel = new JLabel();
        this.codingStandardsFixerTextField = new JTextField();
        this.codingStandardsFixerBrowseButton = new JButton();
        this.codingStandardsFixerSearchButton = new JButton();
        this.codingStandardsFixerHintLabel = new JLabel();
        this.codingStandardsFixerLevelLabel = new JLabel();
        this.codingStandardsFixerLevelComboBox = new JComboBox();
        this.codingStandardsFixerConfigLabel = new JLabel();
        this.codingStandardsFixerConfigComboBox = new JComboBox();
        this.codingStandardsFixerOptionsLabel = new JLabel();
        this.codingStandardsFixerOptionsTextField = new JTextField();
        this.noteLabel = new JLabel();
        this.codingStandardsFixerLearnMoreLabel = new JLabel();
        this.codingStandardsFixerLabel.setLabelFor(this.codingStandardsFixerTextField);
        Mnemonics.setLocalizedText((JLabel)this.codingStandardsFixerLabel, (String)NbBundle.getMessage(CodingStandardsFixerOptionsPanel.class, (String)"CodingStandardsFixerOptionsPanel.codingStandardsFixerLabel.text"));
        this.codingStandardsFixerTextField.setText(NbBundle.getMessage(CodingStandardsFixerOptionsPanel.class, (String)"CodingStandardsFixerOptionsPanel.codingStandardsFixerTextField.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.codingStandardsFixerBrowseButton, (String)NbBundle.getMessage(CodingStandardsFixerOptionsPanel.class, (String)"CodingStandardsFixerOptionsPanel.codingStandardsFixerBrowseButton.text"));
        this.codingStandardsFixerBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CodingStandardsFixerOptionsPanel.this.codingStandardsFixerBrowseButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.codingStandardsFixerSearchButton, (String)NbBundle.getMessage(CodingStandardsFixerOptionsPanel.class, (String)"CodingStandardsFixerOptionsPanel.codingStandardsFixerSearchButton.text"));
        this.codingStandardsFixerSearchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CodingStandardsFixerOptionsPanel.this.codingStandardsFixerSearchButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.codingStandardsFixerHintLabel, (String)"HINT");
        this.codingStandardsFixerLevelLabel.setLabelFor(this.codingStandardsFixerLevelComboBox);
        Mnemonics.setLocalizedText((JLabel)this.codingStandardsFixerLevelLabel, (String)NbBundle.getMessage(CodingStandardsFixerOptionsPanel.class, (String)"CodingStandardsFixerOptionsPanel.codingStandardsFixerLevelLabel.text"));
        this.codingStandardsFixerConfigLabel.setLabelFor(this.codingStandardsFixerConfigComboBox);
        Mnemonics.setLocalizedText((JLabel)this.codingStandardsFixerConfigLabel, (String)NbBundle.getMessage(CodingStandardsFixerOptionsPanel.class, (String)"CodingStandardsFixerOptionsPanel.codingStandardsFixerConfigLabel.text"));
        this.codingStandardsFixerOptionsLabel.setLabelFor(this.codingStandardsFixerOptionsTextField);
        Mnemonics.setLocalizedText((JLabel)this.codingStandardsFixerOptionsLabel, (String)NbBundle.getMessage(CodingStandardsFixerOptionsPanel.class, (String)"CodingStandardsFixerOptionsPanel.codingStandardsFixerOptionsLabel.text"));
        this.codingStandardsFixerOptionsTextField.setText(NbBundle.getMessage(CodingStandardsFixerOptionsPanel.class, (String)"CodingStandardsFixerOptionsPanel.codingStandardsFixerOptionsTextField.text"));
        Mnemonics.setLocalizedText((JLabel)this.noteLabel, (String)NbBundle.getMessage(CodingStandardsFixerOptionsPanel.class, (String)"CodingStandardsFixerOptionsPanel.noteLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.codingStandardsFixerLearnMoreLabel, (String)NbBundle.getMessage(CodingStandardsFixerOptionsPanel.class, (String)"CodingStandardsFixerOptionsPanel.codingStandardsFixerLearnMoreLabel.text"));
        this.codingStandardsFixerLearnMoreLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                CodingStandardsFixerOptionsPanel.this.codingStandardsFixerLearnMoreLabelMouseEntered(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                CodingStandardsFixerOptionsPanel.this.codingStandardsFixerLearnMoreLabelMousePressed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.codingStandardsFixerLabel).addComponent(this.codingStandardsFixerLevelLabel).addComponent(this.codingStandardsFixerConfigLabel).addComponent(this.codingStandardsFixerOptionsLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.codingStandardsFixerConfigComboBox, -2, -1, -2).addComponent(this.codingStandardsFixerLevelComboBox, -2, -1, -2).addComponent(this.codingStandardsFixerHintLabel).addComponent(this.codingStandardsFixerOptionsTextField).addGroup(layout.createSequentialGroup().addComponent(this.codingStandardsFixerTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.codingStandardsFixerBrowseButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.codingStandardsFixerSearchButton)))).addGroup(layout.createSequentialGroup().addComponent(this.noteLabel, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.codingStandardsFixerLearnMoreLabel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        layout.linkSize(0, this.codingStandardsFixerBrowseButton, this.codingStandardsFixerSearchButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.codingStandardsFixerLabel).addComponent(this.codingStandardsFixerTextField, -2, -1, -2).addComponent(this.codingStandardsFixerSearchButton).addComponent(this.codingStandardsFixerBrowseButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.codingStandardsFixerHintLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.codingStandardsFixerLevelLabel).addComponent(this.codingStandardsFixerLevelComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.codingStandardsFixerConfigComboBox, -2, -1, -2).addComponent(this.codingStandardsFixerConfigLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.codingStandardsFixerOptionsLabel).addComponent(this.codingStandardsFixerOptionsTextField, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.noteLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.codingStandardsFixerLearnMoreLabel, -2, -1, -2)));
    }

    private void codingStandardsFixerBrowseButtonActionPerformed(ActionEvent evt) {
        File file = new FileChooserBuilder(CodingStandardsFixerOptionsPanel.class.getName() + CODING_STANDARDS_FIXER_LAST_FOLDER_SUFFIX).setFilesOnly(true).setTitle(Bundle.CodingStandardsFixerOptionsPanel_browse_title()).showOpenDialog();
        if (file != null) {
            this.codingStandardsFixerTextField.setText(file.getAbsolutePath());
        }
    }

    private void codingStandardsFixerSearchButtonActionPerformed(ActionEvent evt) {
        String codingStandardsFixer = UiUtils.SearchWindow.search((UiUtils.SearchWindow.SearchWindowSupport)new UiUtils.SearchWindow.SearchWindowSupport(){

            public List<String> detect() {
                return FileUtils.findFileOnUsersPath((String[])new String[]{"php-cs-fixer", "php-cs-fixer.phar"});
            }

            public String getWindowTitle() {
                return Bundle.CodingStandardsFixerOptionsPanel_search_title();
            }

            public String getListTitle() {
                return Bundle.CodingStandardsFixerOptionsPanel_search_scripts();
            }

            public String getPleaseWaitPart() {
                return Bundle.CodingStandardsFixerOptionsPanel_search_pleaseWaitPart();
            }

            public String getNoItemsFound() {
                return Bundle.CodingStandardsFixerOptionsPanel_search_notFound();
            }
        });
        if (codingStandardsFixer != null) {
            this.codingStandardsFixerTextField.setText(codingStandardsFixer);
        }
    }

    private void codingStandardsFixerLearnMoreLabelMouseEntered(MouseEvent evt) {
        evt.getComponent().setCursor(Cursor.getPredefinedCursor(12));
    }

    private void codingStandardsFixerLearnMoreLabelMousePressed(MouseEvent evt) {
        try {
            URL url = new URL("https://github.com/fabpot/PHP-CS-Fixer");
            HtmlBrowser.URLDisplayer.getDefault().showURL(url);
        }
        catch (MalformedURLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private final class DefaultDocumentListener
    implements DocumentListener {
        private DefaultDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        private void processUpdate() {
            CodingStandardsFixerOptionsPanel.this.fireChange();
        }
    }
}

