/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.wizards;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.cnd.api.toolchain.CompilerFlavor;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.PredefinedToolKind;
import org.netbeans.modules.cnd.api.toolchain.Tool;
import org.netbeans.modules.cnd.api.toolchain.ToolKind;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.WindowsSupport;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public final class PreBuildSupport {
    public static final String CMAKE_MACRO = "${CMAKE}";
    public static final String C_COMPILER_MACRO = "${IDE_CC}";
    public static final String CPP_COMPILER_MACRO = "${IDE_CXX}";

    private PreBuildSupport() {
    }

    public static PreBuildArtifact findArtifactInFolder(FileObject folder, ExecutionEnvironment ee, CompilerSet compilerSet) {
        PreBuildArtifactProvider provider;
        PreBuildArtifact findConfigureScript = null;
        Iterator<? extends PreBuildArtifactProvider> iterator = PreBuildSupport.getPreBuildProviders().iterator();
        while (iterator.hasNext() && (findConfigureScript = (provider = iterator.next()).findScriptInFolder(folder, ee, compilerSet)) == null) {
        }
        return findConfigureScript;
    }

    public static PreBuildArtifact scriptToArtifact(FileObject script) {
        PreBuildArtifactProvider provider;
        PreBuildArtifact findConfigureScript = null;
        Iterator<? extends PreBuildArtifactProvider> iterator = PreBuildSupport.getPreBuildProviders().iterator();
        while (iterator.hasNext() && (findConfigureScript = (provider = iterator.next()).scriptToArtifact(script)) == null) {
        }
        return findConfigureScript;
    }

    public static PreBuildArtifactProvider getPreBuildProvider(PreBuildArtifact script) {
        for (PreBuildArtifactProvider preBuildArtifactProvider : PreBuildSupport.getPreBuildProviders()) {
            if (!preBuildArtifactProvider.isSupported(script)) continue;
            return preBuildArtifactProvider;
        }
        return null;
    }

    public static Collection<? extends PreBuildArtifactProvider> getPreBuildProviders() {
        Lookup.Result res = Lookup.getDefault().lookupResult(PreBuildArtifactProvider.class);
        return res.allInstances();
    }

    public static String expandMacros(String command, CompilerSet cs, Map<String, String> env) {
        String path;
        if (command.contains(CMAKE_MACRO)) {
            path = PreBuildSupport.getCmakePath(cs);
            command = command.replace(CMAKE_MACRO, path);
        }
        if (command.contains(C_COMPILER_MACRO)) {
            path = PreBuildSupport.getDefaultC(cs);
            if (env != null && env.containsKey("__CND_C_WRAPPER__")) {
                path = env.get("__CND_C_WRAPPER__");
            }
            if (cs.getCompilerFlavor().isCygwinCompiler()) {
                path = WindowsSupport.getInstance().convertToCygwinPath(path);
            }
            command = command.replace(C_COMPILER_MACRO, path);
        }
        if (command.contains(CPP_COMPILER_MACRO)) {
            path = PreBuildSupport.getDefaultCpp(cs);
            if (env != null && env.containsKey("__CND_CPP_WRAPPER__")) {
                path = env.get("__CND_CPP_WRAPPER__");
            }
            if (cs.getCompilerFlavor().isCygwinCompiler()) {
                path = WindowsSupport.getInstance().convertToCygwinPath(path);
            }
            command = command.replace(CPP_COMPILER_MACRO, path);
        }
        return command;
    }

    public static String getCmakePath(CompilerSet cs) {
        String toolPath = PreBuildSupport.getToolPath(cs, PredefinedToolKind.CMakeTool);
        if (toolPath == null || toolPath.isEmpty()) {
            toolPath = "cmake";
        }
        return toolPath;
    }

    private static String getDefaultC(CompilerSet compilerSet) {
        CompilerFlavor flavor;
        String cCompiler = PreBuildSupport.getToolPath(compilerSet, PredefinedToolKind.CCompiler);
        if (cCompiler != null) {
            return cCompiler;
        }
        cCompiler = "gcc";
        if (compilerSet != null && (flavor = compilerSet.getCompilerFlavor()).isSunStudioCompiler()) {
            cCompiler = "cc";
        }
        return cCompiler;
    }

    private static String getDefaultCpp(CompilerSet compilerSet) {
        CompilerFlavor flavor;
        String cppCompiler = PreBuildSupport.getToolPath(compilerSet, PredefinedToolKind.CCCompiler);
        if (cppCompiler != null) {
            return cppCompiler;
        }
        cppCompiler = "g++";
        if (compilerSet != null && (flavor = compilerSet.getCompilerFlavor()).isSunStudioCompiler()) {
            cppCompiler = "CC";
        }
        return cppCompiler;
    }

    private static String getToolPath(CompilerSet compilerSet, PredefinedToolKind tool) {
        if (compilerSet == null) {
            return null;
        }
        Tool compiler = compilerSet.findTool((ToolKind)tool);
        if (compiler == null) {
            return null;
        }
        return PreBuildSupport.escapePath(compiler.getPath());
    }

    private static String escapePath(String path) {
        if (!((path = path.replace("\\", "/")).indexOf(32) <= 0 && path.indexOf(61) <= 0 || path.startsWith("\""))) {
            path = "\"" + path + "\"";
        }
        return path;
    }

    public static interface PreBuildArtifactProvider {
        public PreBuildArtifact findScriptInFolder(FileObject var1, ExecutionEnvironment var2, CompilerSet var3);

        public PreBuildArtifact scriptToArtifact(FileObject var1);

        public boolean isSupported(PreBuildArtifact var1);

        public String getToolName();

        public String getDisplayName();

        public String getHint();

        public String getFileChooserTitle();

        public FileFilter[] getFileFilter();
    }

    public static interface PreBuildArtifact {
        public FileObject getScript();

        public String getArguments(ExecutionEnvironment var1, CompilerSet var2, String var3);

        public String getCommandLine(String var1, String var2);

        public String validate(ExecutionEnvironment var1, CompilerSet var2);
    }
}

