/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.twig.editor.parsing;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.swing.event.ChangeListener;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.api.Task;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.SourceModificationEvent;
import org.netbeans.modules.php.twig.editor.lexer.TwigBlockTokenId;
import org.netbeans.modules.php.twig.editor.parsing.TwigParserResult;

public class TwigParser
extends Parser {
    private TwigParserResult result;
    private static final List<String> PARSE_ELEMENTS = new ArrayList<String>();

    public void parse(Snapshot snapshot, Task task, SourceModificationEvent sme) throws ParseException {
        this.result = new TwigParserResult(snapshot);
        TokenHierarchy tokenHierarchy = snapshot.getTokenHierarchy();
        LanguagePath twigPath = null;
        for (LanguagePath path : tokenHierarchy.languagePaths()) {
            if (!path.mimePath().endsWith(TwigBlockTokenId.language().mimeType())) continue;
            twigPath = path;
            break;
        }
        if (twigPath != null) {
            List tokenSequenceList = tokenHierarchy.tokenSequenceList(twigPath, 0, Integer.MAX_VALUE);
            ArrayList<Block> blockList = new ArrayList<Block>();
            for (Object sequence : tokenSequenceList) {
                while (sequence.moveNext()) {
                    Token token = sequence.token();
                    Block block = new Block();
                    block.function = "";
                    block.startTokenOffset = sequence.offset();
                    block.endTokenOffset = sequence.offset();
                    block.from = token.offset(tokenHierarchy);
                    while (sequence.moveNext()) {
                        token = sequence.token();
                        if (token.id() != TwigBlockTokenId.T_TWIG_NAME) continue;
                        block.extra = token.text();
                    }
                    block.endTokenOffset = sequence.offset() + sequence.token().length();
                    block.length = token.offset(tokenHierarchy) - block.from + token.length();
                    if (block.startTokenOffset == block.endTokenOffset) continue;
                    sequence.move(block.startTokenOffset);
                    while (sequence.moveNext()) {
                        token = sequence.token();
                        if (token.id() != TwigBlockTokenId.T_TWIG_TAG) continue;
                        block.function = token.text();
                        block.functionFrom = token.offset(tokenHierarchy);
                        block.functionLength = token.length();
                        break;
                    }
                    if (PARSE_ELEMENTS.contains(block.function.toString())) {
                        boolean standalone;
                        if (CharSequenceUtilities.equals((CharSequence)block.function, (Object)"block")) {
                            boolean moved;
                            standalone = false;
                            int names = 0;
                            do {
                                moved = sequence.moveNext();
                                token = sequence.token();
                                if (token.id() == TwigBlockTokenId.T_TWIG_NAME || token.id() == TwigBlockTokenId.T_TWIG_STRING) {
                                    ++names;
                                }
                                if (names <= 1) continue;
                                standalone = true;
                                break;
                            } while (moved && sequence.offset() < block.endTokenOffset);
                            if (!standalone) {
                                blockList.add(block);
                            } else {
                                this.result.addBlock("*inline-block", block.from, block.length, block.extra);
                            }
                        } else if (CharSequenceUtilities.equals((CharSequence)block.function, (Object)"set")) {
                            boolean moved;
                            standalone = false;
                            do {
                                moved = sequence.moveNext();
                                token = sequence.token();
                                if (token.id() != TwigBlockTokenId.T_TWIG_OPERATOR) continue;
                                standalone = true;
                                break;
                            } while (moved && sequence.offset() < block.endTokenOffset);
                            if (!standalone) {
                                blockList.add(block);
                            }
                        } else {
                            blockList.add(block);
                        }
                    }
                    sequence.move(block.endTokenOffset);
                }
            }
            Stack<Block> blockStack = new Stack<Block>();
            for (Block block : blockList) {
                if (CharSequenceUtilities.startsWith((CharSequence)block.function, (CharSequence)"end")) {
                    if (blockStack.empty()) {
                        this.result.addError("Unopened '" + block.function + "' block", block.functionFrom, block.functionLength);
                        continue;
                    }
                    if (CharSequenceUtilities.endsWith((CharSequence)block.function, (CharSequence)((Block)blockStack.peek()).function)) {
                        Block start = (Block)blockStack.pop();
                        this.result.addBlock(start.function, start.from, block.from - start.from + block.length, start.extra);
                        continue;
                    }
                    this.result.addError("Unexpected '" + block.function + "', expected 'end" + ((Block)blockStack.peek()).function + "'", block.functionFrom, block.functionLength);
                    continue;
                }
                blockStack.push(block);
            }
            if (!blockStack.empty()) {
                while (!blockStack.empty()) {
                    Block block = (Block)blockStack.pop();
                    this.result.addError("Unclosed '" + block.function + "'", block.functionFrom, block.functionLength);
                }
            }
        }
    }

    public Parser.Result getResult(Task task) throws ParseException {
        return this.result;
    }

    public void addChangeListener(ChangeListener cl) {
    }

    public void removeChangeListener(ChangeListener cl) {
    }

    static {
        PARSE_ELEMENTS.add("for");
        PARSE_ELEMENTS.add("endfor");
        PARSE_ELEMENTS.add("if");
        PARSE_ELEMENTS.add("endif");
        PARSE_ELEMENTS.add("block");
        PARSE_ELEMENTS.add("endblock");
        PARSE_ELEMENTS.add("set");
        PARSE_ELEMENTS.add("endset");
        PARSE_ELEMENTS.add("macro");
        PARSE_ELEMENTS.add("endmacro");
        PARSE_ELEMENTS.add("filter");
        PARSE_ELEMENTS.add("endfilter");
        PARSE_ELEMENTS.add("autoescape");
        PARSE_ELEMENTS.add("endautoescape");
        PARSE_ELEMENTS.add("spaceless");
        PARSE_ELEMENTS.add("endspaceless");
        PARSE_ELEMENTS.add("embed");
        PARSE_ELEMENTS.add("endembed");
        PARSE_ELEMENTS.add("raw");
        PARSE_ELEMENTS.add("endraw");
        PARSE_ELEMENTS.add("verbatim");
        PARSE_ELEMENTS.add("endverbatim");
        PARSE_ELEMENTS.add("sandbox");
        PARSE_ELEMENTS.add("endsandbox");
        PARSE_ELEMENTS.add("trans");
        PARSE_ELEMENTS.add("endtrans");
    }

    private static class Block {
        CharSequence function = null;
        CharSequence extra = null;
        int startTokenOffset = 0;
        int endTokenOffset = 0;
        int from = 0;
        int length = 0;
        int functionFrom = 0;
        int functionLength = 0;

        private Block() {
        }
    }
}

