/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.utils.cache;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.netbeans.modules.cnd.utils.cache.TinyMaps;
import org.openide.util.CharSequences;

public abstract class MapSnapshot<V>
implements Iterable<Map.Entry<CharSequence, V>> {
    protected static final Map<CharSequence, Object> EMPTY = Collections.emptyMap();
    protected Object storage = EMPTY;
    private final MapSnapshot<V> parent;
    public static final Comparator<Map.Entry<CharSequence, Object>> ENTRY_COMPARATOR = new EntryComparatorImpl();

    protected MapSnapshot(MapSnapshot<V> parent) {
        assert (parent == null || parent.parent == null || !parent.parent.isEmpty()) : "how grand father could be empty " + parent;
        while (parent != null && parent.isEmpty()) {
            parent = parent.parent;
        }
        this.parent = parent;
        if (this.parent != null) {
        }
    }

    protected MapSnapshot<V> getParent() {
        return this.parent;
    }

    public void put(CharSequence key, V value) {
        Map map;
        assert (!(this.storage instanceof Holder)) : "frozen snap can not be modified";
        if (this.storage == EMPTY) {
            this.storage = TinyMaps.createMap(1);
        } else if (this.storage instanceof Map) {
            map = (Map)this.storage;
            this.storage = TinyMaps.expandForNextKey(map, key);
        }
        assert (this.storage instanceof Map) : "unexpected class " + this.storage.getClass();
        map = (Map)this.storage;
        map.put(key, value);
    }

    public final V get(CharSequence key) {
        assert (CharSequences.isCompact((CharSequence)key)) : "string can't be here " + key;
        MapSnapshot<V> currentSnap = this;
        while (currentSnap != null) {
            V value = currentSnap.getImpl(key);
            if (value != null) {
                return value;
            }
            currentSnap = currentSnap.parent;
        }
        return null;
    }

    protected V getImpl(CharSequence key) {
        assert (this.storage instanceof Map) : "unexpected to have get from frozen" + this.storage.getClass();
        Object map = ((Map)this.storage).get(key);
        return map;
    }

    public String toString() {
        Map<CharSequence, V> tmpMap = this.getAll();
        StringBuilder retValue = new StringBuilder();
        retValue.append("VALUES (sorted ").append(tmpMap.size()).append("):\n");
        ArrayList<CharSequence> macrosSorted = new ArrayList<CharSequence>(tmpMap.keySet());
        Collections.sort(macrosSorted, CharSequences.comparator());
        for (CharSequence key : macrosSorted) {
            V macro = tmpMap.get(key);
            assert (macro != null);
            retValue.append(macro);
            retValue.append("'\n");
        }
        return retValue.toString();
    }

    public Map<CharSequence, V> getAll() {
        LinkedList<MapSnapshot> stack = new LinkedList<MapSnapshot>();
        MapSnapshot snap = this;
        int i = 0;
        while (snap != null) {
            i += snap.size();
            stack.add(snap);
            snap = snap.parent;
        }
        HashMap<CharSequence, V> out = new HashMap<CharSequence, V>(i);
        while (!stack.isEmpty()) {
            snap = (MapSnapshot)stack.removeLast();
            for (Map.Entry<CharSequence, V> object : snap) {
                Map.Entry<CharSequence, V> entry = object;
                if (this.isRemoved(entry.getValue())) {
                    out.remove(entry.getKey());
                    continue;
                }
                out.put(entry.getKey(), entry.getValue());
            }
        }
        return out;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    protected int size() {
        if (this.storage == EMPTY) {
            return 0;
        }
        if (this.storage instanceof Map) {
            return ((Map)this.storage).size();
        }
        if (this.storage instanceof Holder) {
            return ((Holder)this.storage).arr.length / 2;
        }
        return 1;
    }

    private void freeze() {
        if (this.storage instanceof Map && this.storage != EMPTY) {
            Object[] arr = MapSnapshot.compact((Map)this.storage);
            this.storage = this.cacheHolder(new Holder(arr));
        }
    }

    protected Holder cacheHolder(Holder holder) {
        return holder;
    }

    private static Object[] compact(Map<CharSequence, Object> map) {
        assert (map != EMPTY);
        int size = map.size();
        assert (size > 0);
        Object[] out = new Object[size * 2];
        int index = 0;
        Map.Entry[] entries = new Map.Entry[size];
        for (Map.Entry<CharSequence, Object> entry : map.entrySet()) {
            entries[index++] = entry;
        }
        index = 0;
        Arrays.sort(entries, ENTRY_COMPARATOR);
        for (Map.Entry entry : entries) {
            out[index] = entry.getKey();
            out[index + size] = entry.getValue();
            ++index;
        }
        return out;
    }

    protected boolean isRemoved(V value) {
        return false;
    }

    @Override
    public Iterator<Map.Entry<CharSequence, V>> iterator() {
        if (this.storage == EMPTY) {
            return Collections.emptyIterator();
        }
        if (this.storage instanceof Map) {
            return ((Map)this.storage).entrySet().iterator();
        }
        if (this.storage instanceof Holder) {
            return ((Holder)this.storage).iterator();
        }
        return Collections.emptyIterator();
    }

    protected static class SingleItemIterator<V>
    implements Iterator<Map.Entry<CharSequence, V>> {
        private Map.Entry entry;

        public SingleItemIterator(final CharSequence key, final V value) {
            this.entry = new Map.Entry(){

                public Object getKey() {
                    return key;
                }

                public Object getValue() {
                    return value;
                }

                public Object setValue(Object value2) {
                    throw new UnsupportedOperationException("Not supported.");
                }
            };
        }

        @Override
        public boolean hasNext() {
            return this.entry != null;
        }

        @Override
        public Map.Entry next() {
            Map.Entry res = this.entry;
            this.entry = null;
            return res;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported.");
        }
    }

    private static class EntryComparatorImpl
    implements Comparator<Map.Entry<CharSequence, Object>> {
        private final Comparator<CharSequence> charSeqComparator = CharSequences.comparator();

        @Override
        public int compare(Map.Entry<CharSequence, Object> o1, Map.Entry<CharSequence, Object> o2) {
            return this.charSeqComparator.compare(o1.getKey(), o2.getKey());
        }
    }

    public static final class Holder
    implements Iterable {
        public final Object[] arr;
        private final int hashCode;

        public Holder(Object[] arr) {
            this.arr = arr;
            this.hashCode = Arrays.hashCode(this.arr);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Holder other = (Holder)obj;
            if (this.hashCode != other.hashCode) {
                return false;
            }
            return Arrays.equals(this.arr, other.arr);
        }

        public int size() {
            return this.arr.length / 2;
        }

        public Iterator iterator() {
            return new Iterator(){
                private int pos = 0;
                private final int offset;
                {
                    this.offset = Holder.this.arr.length / 2;
                }

                @Override
                public boolean hasNext() {
                    return this.pos < this.offset;
                }

                public Object next() {
                    Map.Entry<CharSequence, Object> res = new Map.Entry<CharSequence, Object>(){
                        int ePos;
                        {
                            this.ePos = pos;
                        }

                        @Override
                        public CharSequence getKey() {
                            return (CharSequence)Holder.this.arr[this.ePos];
                        }

                        @Override
                        public Object getValue() {
                            return Holder.this.arr[this.ePos + offset];
                        }

                        @Override
                        public Object setValue(Object value) {
                            throw new UnsupportedOperationException("Not supported.");
                        }
                    };
                    ++this.pos;
                    return res;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("Not supported.");
                }
            };
        }
    }
}

