/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.storage;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.openide.filesystems.FileSystem;

final class FileSystemsDictionary {
    private final Map<FileSystem, Integer> map = new HashMap<FileSystem, Integer>();
    private final AtomicInteger counter = new AtomicInteger(12);

    FileSystemsDictionary() {
    }

    FileSystem getFileSystem(int fileSystemIdx) {
        for (Map.Entry<FileSystem, Integer> entry : this.map.entrySet()) {
            if (!entry.getValue().equals(fileSystemIdx)) continue;
            return entry.getKey();
        }
        return null;
    }

    int getFileSystemID(FileSystem clientFileSystem) {
        Integer result = this.map.get(clientFileSystem);
        if (result == null) {
            result = this.counter.getAndIncrement();
            this.map.put(clientFileSystem, result);
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("\n[clientFileSystem <-> clientFileSystemID]\n");
        for (Map.Entry<FileSystem, Integer> entry : this.map.entrySet()) {
            sb.append(entry.getKey()).append(" => ").append(entry.getValue()).append("\n");
        }
        return sb.toString();
    }
}

