/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.content.project;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.util.UIDs;
import org.netbeans.modules.cnd.modelimpl.content.project.FileContainer;
import org.netbeans.modules.cnd.modelimpl.content.project.ProjectComponent;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.PreprocessorStatePair;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.repository.IncludedFileStorageKey;
import org.netbeans.modules.cnd.modelimpl.repository.KeyUtilities;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.uid.KeyBasedUID;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;
import org.openide.filesystems.FileSystem;
import org.openide.util.CharSequences;

public final class IncludedFileContainer
extends ProjectComponent {
    private final List<Entry> list;

    public IncludedFileContainer(ProjectBase startProject) {
        super(new IncludedFileStorageKey(startProject));
        this.list = new CopyOnWriteArrayList<Entry>();
        this.put();
    }

    public IncludedFileContainer(RepositoryDataInput aStream) throws IOException {
        super(aStream);
        int count = aStream.readInt();
        ArrayList<Entry> aList = new ArrayList<Entry>(count);
        UIDObjectFactory factory = UIDObjectFactory.getDefaultFactory();
        for (int i = 0; i < count; ++i) {
            CsmUID includedProjectUID = factory.readUID(aStream);
            Storage storage = new Storage(aStream);
            aList.add(new Entry(includedProjectUID, storage));
        }
        this.list = new CopyOnWriteArrayList<Entry>(aList);
    }

    @Override
    public void write(RepositoryDataOutput aStream) throws IOException {
        super.write(aStream);
        ArrayList<Entry> aList = new ArrayList<Entry>(this.list);
        aStream.writeInt(aList.size());
        UIDObjectFactory factory = UIDObjectFactory.getDefaultFactory();
        for (Entry entry : aList) {
            factory.writeUID(entry.prjUID, aStream);
            entry.getStorage().write(aStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        List<Entry> list = this.list;
        synchronized (list) {
            this.list.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateIncludeStorage(CsmUID<CsmProject> libraryUID) {
        List<Entry> list = this.list;
        synchronized (list) {
            for (int i = 0; i < this.list.size(); ++i) {
                Entry entry = this.list.get(i);
                if (!entry.prjUID.equals(libraryUID)) continue;
                this.list.remove(i);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareIncludeStorage(ProjectBase includedProject) {
        CsmUID<CsmProject> uid = includedProject.getUID();
        for (Entry entry : this.list) {
            if (!entry.prjUID.equals(uid)) continue;
            return;
        }
        List<Entry> list = this.list;
        synchronized (list) {
            for (Entry entry : this.list) {
                if (!entry.prjUID.equals(uid)) continue;
                return;
            }
            Storage storage = new Storage(includedProject);
            Entry includedProjectEntry = new Entry(includedProject.getUID(), storage);
            this.list.add(includedProjectEntry);
            this.put();
        }
    }

    public Storage getStorageForProject(ProjectBase includedFileOwner) {
        CsmUID<CsmProject> uid = includedFileOwner.getUID();
        for (Entry entry : this.list) {
            if (!entry.prjUID.equals(uid)) continue;
            return entry.getStorage();
        }
        return null;
    }

    public boolean putStorage(ProjectBase includedProject) {
        Storage storage = this.getStorageForProject(includedProject);
        if (storage != null) {
            this.put();
            return true;
        }
        return false;
    }

    public FileContainer.FileEntry getOrCreateEntryForIncludedFile(FileContainer.FileEntry entryToLockOn, ProjectBase includedProject, FileImpl includedFile) {
        assert (Thread.holdsLock(entryToLockOn.getLock())) : "does not hold lock for " + includedFile;
        Storage storage = this.getStorageForProject(includedProject);
        if (storage != null) {
            return storage.getOrCreateFileEntry(includedFile);
        }
        return null;
    }

    public Map<CsmUID<CsmProject>, Collection<PreprocessorStatePair>> getPairsToDump(FileImpl fileToSearch) {
        HashMap<CsmUID<CsmProject>, Collection<PreprocessorStatePair>> out = new HashMap<CsmUID<CsmProject>, Collection<PreprocessorStatePair>>();
        CharSequence fileKey = FileContainer.getFileKey(fileToSearch.getAbsolutePath(), false);
        for (Entry entry : this.list) {
            Collection<PreprocessorStatePair> pairs;
            FileContainer.FileEntry fileEntry = entry.getStorage().getFileEntry(fileKey);
            if (fileEntry == null || (pairs = fileEntry.getStatePairs()).isEmpty()) continue;
            out.put((CsmUID<CsmProject>)entry.prjUID, pairs);
        }
        return out;
    }

    public void invalidate(Object lock, ProjectBase includedFileOwner, CharSequence fileKey) {
        assert (Thread.holdsLock(lock)) : "does not hold lock for " + fileKey;
        fileKey = FileContainer.getFileKey(fileKey, false);
        Storage storage = this.getStorageForProject(includedFileOwner);
        if (storage != null) {
            storage.invalidate(fileKey);
            this.put();
        }
    }

    public boolean remove(Object lock, ProjectBase includedFileOwner, CharSequence fileKey) {
        assert (Thread.holdsLock(lock)) : "does not hold lock for " + fileKey;
        fileKey = FileContainer.getFileKey(fileKey, false);
        boolean out = false;
        Storage storage = this.getStorageForProject(includedFileOwner);
        if (storage != null) {
            out = storage.remove(fileKey) != null;
            this.put();
        }
        return out;
    }

    public FileContainer.FileEntry getIncludedFileEntry(Object lock, ProjectBase includedFileOwner, CharSequence fileKey) {
        assert (Thread.holdsLock(lock)) : "does not hold lock for " + fileKey;
        fileKey = FileContainer.getFileKey(fileKey, false);
        Storage storage = this.getStorageForProject(includedFileOwner);
        FileContainer.FileEntry fileEntry = null;
        if (storage != null) {
            fileEntry = storage.getFileEntry(fileKey);
        }
        return fileEntry;
    }

    public void debugClearState() {
        for (Entry entry : this.list) {
            entry.storage.debugClearState();
        }
        this.put();
    }

    private static final class Entry {
        private final CsmUID<CsmProject> prjUID;
        private final Storage storage;

        private Entry(CsmUID<CsmProject> prj, Storage storage) {
            this.prjUID = prj;
            this.storage = storage;
        }

        private Storage getStorage() {
            assert (this.storage != null);
            return this.storage;
        }

        public String toString() {
            return "Entry{prjUID=" + this.prjUID + ", storage=" + this.storage + '}';
        }
    }

    public static final class Storage {
        private final ConcurrentMap<CharSequence, FileContainer.FileEntry> myFiles = new ConcurrentHashMap<CharSequence, FileContainer.FileEntry>();
        private final FileSystem fileSystem;
        private final CsmUID<CsmProject> includedProjectUID;

        private FileContainer.FileEntry getFileEntry(CharSequence fileKey) {
            assert (CharSequences.isCompact((CharSequence)fileKey));
            return (FileContainer.FileEntry)this.myFiles.get(fileKey);
        }

        private Storage(ProjectBase includedProject) {
            this.fileSystem = includedProject.getFileSystem();
            this.includedProjectUID = UIDs.get((Object)includedProject);
        }

        public Map<CharSequence, FileContainer.FileEntry> getInternalMap() {
            return Collections.unmodifiableMap(this.myFiles);
        }

        private void invalidate(CharSequence fileKey) {
            assert (CharSequences.isCompact((CharSequence)fileKey));
            FileContainer.FileEntry entry = (FileContainer.FileEntry)this.myFiles.get(fileKey);
            if (entry != null) {
                entry.invalidateStates();
            }
        }

        private FileContainer.FileEntry remove(CharSequence fileKey) {
            assert (CharSequences.isCompact((CharSequence)fileKey));
            return (FileContainer.FileEntry)this.myFiles.remove(fileKey);
        }

        private FileContainer.FileEntry getOrCreateFileEntry(FileImpl includedFile) {
            FileContainer.FileEntry prev;
            CharSequence fileKey = FileContainer.getFileKey(includedFile.getAbsolutePath(), false);
            FileContainer.FileEntry entry = (FileContainer.FileEntry)this.myFiles.get(fileKey);
            if (entry == null && (prev = this.myFiles.putIfAbsent(fileKey, entry = FileContainer.createFileEntry(includedFile))) != null) {
                throw new ConcurrentModificationException("someone put the same file entry for " + includedFile);
            }
            return entry;
        }

        private Storage(RepositoryDataInput aStream) throws IOException {
            this.fileSystem = PersistentUtils.readFileSystem(aStream);
            this.includedProjectUID = UIDObjectFactory.getDefaultFactory().readUID(aStream);
            FileContainer.readFilePathsForFileSystemToFileEntryMap(this.fileSystem, aStream, this.myFiles);
        }

        private void write(RepositoryDataOutput aStream) throws IOException {
            PersistentUtils.writeFileSystem(this.fileSystem, aStream);
            UIDObjectFactory.getDefaultFactory().writeUID(this.includedProjectUID, aStream);
            FileContainer.writeFilePathsForFileSystemToFileEntryMap(this.fileSystem, aStream, this.myFiles);
        }

        public String toString() {
            return "Storage:" + this.includedProjectUID;
        }

        private void debugClearState() {
            ArrayList files = new ArrayList(this.myFiles.values());
            for (FileContainer.FileEntry file : files) {
                file.debugClearState();
            }
        }

        private int getIncludedUnitId(CsmUID<CsmProject> uid) {
            if (uid instanceof KeyBasedUID) {
                Key k = ((KeyBasedUID)uid).getKey();
                return KeyUtilities.getProjectIndex(k);
            }
            throw new IllegalArgumentException();
        }
    }
}

