/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.modelimpl.csm.core.ModelImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.NativeFileContainer;
import org.netbeans.modules.cnd.modelimpl.csm.core.ParserQueue;
import org.netbeans.modules.cnd.modelimpl.csm.core.ParserThreadManager;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBaseWithEditing;
import org.netbeans.modules.cnd.modelimpl.csm.core.SourceRootContainer;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.repository.KeyUtilities;
import org.netbeans.modules.cnd.modelimpl.repository.RepositoryUtils;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;

public final class ProjectImpl
extends ProjectBaseWithEditing {
    private final NativeFileContainer nativeFiles = new NativeFileContainer();
    private final SourceRootContainer projectRoots = new SourceRootContainer(false);

    private static void cleanProjectRepository(NativeProject platformProject) {
        Key key = ProjectImpl.createProjectKey(platformProject);
        RepositoryUtils.closeUnit(key, null, true);
    }

    private static Key createProjectKey(NativeProject platfProj) {
        return KeyUtilities.createProjectKey(platfProj);
    }

    private static ProjectBase readProjectInstance(ModelImpl model, NativeProject platformProject, String name) {
        return ProjectImpl.readInstance(model, ProjectImpl.createProjectKey(platformProject), platformProject, name);
    }

    private ProjectImpl(ModelImpl model, NativeProject platformProject, CharSequence name) {
        super(model, platformProject.getFileSystem(), platformProject, name, ProjectImpl.createProjectKey(platformProject));
    }

    public static ProjectImpl createInstance(ModelImpl model, NativeProject platformProject, String name) {
        ProjectBase instance = null;
        if (TraceFlags.PERSISTENT_REPOSITORY) {
            try {
                instance = ProjectImpl.readProjectInstance(model, platformProject, name);
            }
            catch (Exception e) {
                DiagnosticExceptoins.register(e);
                ProjectImpl.cleanProjectRepository(platformProject);
            }
        }
        if (instance != null && !(instance instanceof ProjectImpl)) {
            DiagnosticExceptoins.register(new IllegalStateException("Expected " + ProjectImpl.class.getName() + " but restored from repository " + instance.getClass().getName()));
            ProjectImpl.cleanProjectRepository(platformProject);
            instance = null;
        }
        if (instance == null && CsmModelAccessor.isModelAlive()) {
            instance = new ProjectImpl(model, platformProject, name);
        }
        return (ProjectImpl)instance;
    }

    @Override
    protected Collection<Key> getLibrariesKeys() {
        ArrayList<Key> res = new ArrayList<Key>();
        assert (this.getPlatformProject() instanceof NativeProject) : "Expected NativeProject, got " + this.getPlatformProject();
        for (NativeProject nativeProject : ((NativeProject)this.getPlatformProject()).getDependences()) {
            Key key = ProjectImpl.createProjectKey(nativeProject);
            res.add(key);
        }
        for (CsmUID csmUID : this.getLibraryManager().getLirariesKeys(this.getUID())) {
            res.add(RepositoryUtils.UIDtoKey(csmUID));
        }
        return res;
    }

    @Override
    protected final ParserQueue.Position getIncludedFileParserQueuePosition() {
        return ParserQueue.Position.HEAD;
    }

    @Override
    public ProjectBase findFileProject(CharSequence absPath, boolean waitFilesCreated) {
        ProjectBase retValue = super.findFileProject(absPath, waitFilesCreated);
        if (retValue == null && ParserThreadManager.instance().isStandalone()) {
            retValue = absPath.toString().startsWith("/usr") ? retValue : this;
        }
        return retValue;
    }

    public boolean isArtificial() {
        return false;
    }

    @Override
    public NativeFileItem getNativeFileItem(CsmUID<CsmFile> file) {
        return this.nativeFiles.getNativeFileItem(file);
    }

    @Override
    protected void putNativeFileItem(CsmUID<CsmFile> file, NativeFileItem nativeFileItem) {
        this.nativeFiles.putNativeFileItem(file, nativeFileItem);
    }

    @Override
    protected NativeFileItem removeNativeFileItem(CsmUID<CsmFile> file) {
        return this.nativeFiles.removeNativeFileItem(file);
    }

    @Override
    protected void clearNativeFileContainer() {
        this.nativeFiles.clear();
    }

    @Override
    protected void onDispose() {
        super.onDispose();
        this.nativeFiles.clear();
        this.projectRoots.clear();
    }

    @Override
    protected SourceRootContainer getProjectRoots() {
        return this.projectRoots;
    }

    @Override
    public void write(RepositoryDataOutput aStream) throws IOException {
        super.write(aStream);
        this.getLibraryManager().writeProjectLibraries(this.getUID(), aStream);
    }

    public ProjectImpl(RepositoryDataInput input) throws IOException {
        super(input);
        this.getLibraryManager().readProjectLibraries(this.getUID(), input);
    }
}

