/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.testing;

import com.sun.source.util.TreePath;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.hints.ArithmeticUtilities;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.testing.Bundle;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFixUtilities;
import org.netbeans.spi.java.hints.MatcherUtilities;

public class Tiny {
    public static ErrorDescription assertEqualsForArrays(HintContext ctx) {
        TypeKind kind;
        TypeMirror type;
        TypeElement ojAssert = ctx.getInfo().getElements().getTypeElement("org.junit.Assert");
        String targetPattern = null;
        if (ojAssert != null) {
            for (ExecutableElement ee : ElementFilter.methodsIn(ojAssert.getEnclosedElements())) {
                if (!ee.getSimpleName().contentEquals("assertArrayEquals")) continue;
                if (ctx.getVariables().containsKey("$message")) {
                    targetPattern = "org.junit.Assert.assertArrayEquals($message, $expected, $actual)";
                    continue;
                }
                targetPattern = "org.junit.Assert.assertArrayEquals($expected, $actual)";
            }
        }
        if ((type = ctx.getInfo().getTrees().getTypeMirror((TreePath)ctx.getVariables().get("$expected"))) != null && type.getKind() == TypeKind.ARRAY && ((kind = ((ArrayType)type).getComponentType().getKind()) == TypeKind.DOUBLE || kind == TypeKind.FLOAT)) {
            targetPattern = null;
        }
        if (targetPattern != null) {
            Fix fix = JavaFixUtilities.rewriteFix((HintContext)ctx, (String)Bundle.FIX_assertEqualsForArrays(), (TreePath)ctx.getPath(), targetPattern);
            return ErrorDescriptionFactory.forName((HintContext)ctx, (TreePath)ctx.getPath(), (String)Bundle.ERR_assertEqualsForArrays(), (Fix[])new Fix[]{fix});
        }
        return ErrorDescriptionFactory.forName((HintContext)ctx, (TreePath)ctx.getPath(), (String)Bundle.ERR_assertEqualsForArrays(), (Fix[])new Fix[0]);
    }

    public static ErrorDescription mismatchedConstantVSReal(HintContext ctx) {
        if (Tiny.isConstant(ctx, "$expected") || !Tiny.isConstant(ctx, "$actual")) {
            return null;
        }
        if (!MatcherUtilities.matches((HintContext)ctx, (TreePath)ctx.getPath(), (String)"$method($arguments$)", (boolean)true)) {
            return null;
        }
        String targetPattern = null;
        targetPattern = ctx.getVariables().containsKey("$message") ? "$method($message, $actual, $expected)" : "$method($actual, $expected)";
        Fix fix = JavaFixUtilities.rewriteFix((HintContext)ctx, (String)Bundle.FIX_assertEqualsMismatchedConstantVSReal(), (TreePath)ctx.getPath(), (String)targetPattern);
        return ErrorDescriptionFactory.forName((HintContext)ctx, (TreePath)ctx.getPath(), (String)Bundle.ERR_assertEqualsMismatchedConstantVSReal(), (Fix[])new Fix[]{fix});
    }

    private static boolean isConstant(HintContext ctx, String variable) {
        TreePath variablePath = (TreePath)ctx.getVariables().get(variable);
        return Utilities.isConstantString(ctx.getInfo(), variablePath, true) || ArithmeticUtilities.compute(ctx.getInfo(), variablePath, true) != null;
    }

    public static ErrorDescription incovertibleTypes(HintContext ctx) {
        TypeMirror expected = ctx.getInfo().getTrees().getTypeMirror((TreePath)ctx.getVariables().get("$expected"));
        TypeMirror actual = ctx.getInfo().getTrees().getTypeMirror((TreePath)ctx.getVariables().get("$actual"));
        if (!Tiny.isAcceptable(ctx.getInfo(), expected) || !Tiny.isAcceptable(ctx.getInfo(), actual)) {
            return null;
        }
        if (ctx.getInfo().getTypes().isSubtype(expected, actual)) {
            return null;
        }
        if (ctx.getInfo().getTypes().isSubtype(actual, expected)) {
            return null;
        }
        return ErrorDescriptionFactory.forName((HintContext)ctx, (TreePath)ctx.getPath(), (String)Bundle.ERR_assertEqualsIncovertibleTypes(), (Fix[])new Fix[0]);
    }

    private static boolean isAcceptable(CompilationInfo info, TypeMirror type) {
        if (!Utilities.isValidType(type)) {
            return false;
        }
        TypeKind typeKind = type.getKind();
        return typeKind != TypeKind.EXECUTABLE && typeKind != TypeKind.PACKAGE;
    }
}

