/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.converter.converters;

import com.sun.javacard.classfile.JMethod;
import com.sun.javacard.classfile.attributes.JCodeAttr;
import com.sun.javacard.classfile.attributes.JExceptionRecord;
import com.sun.javacard.converter.ConverterInternalError;
import com.sun.javacard.converter.converters.InstrContainer;
import com.sun.javacard.converter.converters.MethodConverter;
import com.sun.javacard.jcfile.JcException;
import com.sun.javacard.jcfile.constants.JcConstantClassRef;
import com.sun.javacard.jcfile.constants.JcConstantPool;

public class ExceptionTableConverter {
    private MethodConverter method_converter;

    public ExceptionTableConverter(MethodConverter methodConverter) {
        this.method_converter = methodConverter;
    }

    public JcException[] convert() {
        JMethod jMethod = this.method_converter.getJavaMethod();
        JCodeAttr jCodeAttr = jMethod.getCodeAttr();
        if (jCodeAttr == null) {
            return new JcException[0];
        }
        if (jMethod.getCode() == null) {
            return new JcException[0];
        }
        JExceptionRecord[] jExceptionRecordArray = jCodeAttr.getExceptions();
        JcConstantPool jcConstantPool = this.method_converter.getJcConstantPool();
        JcException[] jcExceptionArray = new JcException[jExceptionRecordArray.length];
        for (int i = 0; i < jcExceptionArray.length; ++i) {
            int n = jExceptionRecordArray[i].getStartPc();
            int n2 = this.getLabel(n);
            int n3 = jExceptionRecordArray[i].getEndPc();
            int n4 = this.getLabel(n3);
            int n5 = jExceptionRecordArray[i].getHandlerPc();
            int n6 = this.getLabel(n5);
            String string = jExceptionRecordArray[i].getCatchTypeClass();
            JcConstantClassRef jcConstantClassRef = jcConstantPool.addConstantClassRef(string);
            jcExceptionArray[i] = new JcException(n2, n4, n6, jcConstantClassRef);
        }
        return jcExceptionArray;
    }

    private int getLabel(int n) {
        for (InstrContainer instrContainer = this.method_converter.getInstrContainers(); instrContainer != null; instrContainer = instrContainer.getNextInstrContainer()) {
            if (instrContainer.getJInstr().getPC() != n) continue;
            int n2 = instrContainer.getLabel();
            if (n2 == -1) {
                throw new ConverterInternalError();
            }
            return n2;
        }
        throw new ConverterInternalError();
    }
}

