/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.util;

import com.sun.javacard.util.FolderCrawler;
import com.sun.javacard.util.FolderCrawlerListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Vector;

public class FileUtils {
    public static Vector<File> listAllFilesInFolder(File file, final String string) {
        final Vector<File> vector = new Vector<File>();
        FolderCrawler folderCrawler = new FolderCrawler(file, new FolderCrawlerListener(){

            @Override
            public void fileFound(File file) {
                if (file.isFile() && (string == null || file.getName().endsWith(string))) {
                    vector.addElement(file);
                }
            }
        });
        folderCrawler.crawl();
        return vector;
    }

    public static Vector<File> listAllFoldersInFolder(File file) {
        final Vector<File> vector = new Vector<File>();
        FolderCrawler folderCrawler = new FolderCrawler(file, new FolderCrawlerListener(){

            @Override
            public void fileFound(File file) {
                if (file.isDirectory()) {
                    vector.addElement(file);
                }
            }
        });
        folderCrawler.crawl();
        return vector;
    }

    public static boolean deleteDir(File file) {
        File[] fileArray;
        if (!file.exists()) {
            return false;
        }
        boolean bl = true;
        for (File file2 : fileArray = file.listFiles()) {
            bl = file2.isDirectory() ? bl && FileUtils.deleteDir(file2) : bl && file2.delete();
        }
        bl = bl && file.delete();
        return bl;
    }

    public static void copyDir(File file, File file2) throws Exception {
        File[] fileArray;
        if (!file.exists()) {
            throw new Exception("Source dir " + file + " does not exists.");
        }
        if (file.isFile()) {
            throw new Exception("Source " + file + " is not a drectory.");
        }
        if (file2.exists() && !file2.isDirectory()) {
            throw new Exception("Destination " + file2 + " exists. And, it is a file.");
        }
        file2.mkdirs();
        for (File file3 : fileArray = file.listFiles()) {
            if (file3.isFile()) {
                FileUtils.copyFile(file3, new File(file2, file3.getName()));
                continue;
            }
            FileUtils.copyDir(file3, new File(file2, file3.getName()));
        }
    }

    public static void copyFile(File file, File file2) throws Exception {
        if (file.isDirectory()) {
            throw new Exception("Source is not a file");
        }
        if (file2.exists() && file2.isDirectory()) {
            file2 = new File(file2, file.getName());
        }
        file2.getParentFile().mkdirs();
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            fileOutputStream = new FileOutputStream(file2);
            byte[] byArray = new byte[1024];
            int n = 0;
            while ((n = fileInputStream.read(byArray)) > 0) {
                fileOutputStream.write(byArray, 0, n);
            }
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (Exception exception) {}
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

