/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.codegen.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.modelutil.ui.ElementNode;

public class SuperConstructorSelectorPanel
extends JPanel {
    private final Map<JRadioButton, ElementNode.Description> buttons = new LinkedHashMap<JRadioButton, ElementNode.Description>();
    private JRadioButton firstButton;

    public SuperConstructorSelectorPanel(ElementNode.Description elementDescription) {
        GridBagConstraints gridBagConstraints;
        this.setLayout(new GridBagLayout());
        int y = 0;
        for (ElementNode.Description cls : elementDescription.getSubs()) {
            JLabel label = new JLabel(cls.getName() + ":");
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = y++;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(6, 6, 6, 6);
            this.add((Component)label, gridBagConstraints);
            ButtonGroup group = new ButtonGroup();
            boolean first = true;
            for (ElementNode.Description cons : cls.getSubs()) {
                String displayName = cons.getDisplayName();
                if (displayName.length() > 50) {
                    displayName = displayName.substring(0, 50) + "...)";
                }
                JRadioButton button = new JRadioButton(displayName, first);
                if (this.firstButton == null) {
                    this.firstButton = button;
                }
                group.add(button);
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = y++;
                gridBagConstraints.fill = 2;
                gridBagConstraints.anchor = 17;
                gridBagConstraints.insets = new Insets(0, 18, 6, 6);
                this.add((Component)button, gridBagConstraints);
                this.buttons.put(button, cons);
                first = false;
            }
        }
        JPanel panel = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = y++;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 6, 12);
        this.add((Component)panel, gridBagConstraints);
    }

    public List<CsmDeclaration> getSelectedElements() {
        ArrayList<CsmDeclaration> handles = new ArrayList<CsmDeclaration>();
        for (Map.Entry<JRadioButton, ElementNode.Description> entry : this.buttons.entrySet()) {
            if (!entry.getKey().isSelected()) continue;
            handles.add(entry.getValue().getElementHandle());
        }
        return handles;
    }
}

