/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.ui.stash;

import java.awt.Dialog;
import java.awt.EventQueue;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.git.remote.cli.GitBranch;
import org.netbeans.modules.git.remote.ui.shelve.ShelveChangesAction;
import org.netbeans.modules.git.remote.ui.stash.Bundle;
import org.netbeans.modules.git.remote.ui.stash.SaveStashPanel;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.actions.SystemAction;

class SaveStash
implements DocumentListener {
    private final SaveStashPanel panel;
    private JButton okButton;
    private DialogDescriptor dd;
    private final VCSFileProxy repository;
    private final Icon ICON_INFO = new ImageIcon(this.getClass().getResource("/org/netbeans/modules/git/remote/resources/icons/info.png"));
    private final VCSFileProxy[] roots;

    SaveStash(VCSFileProxy repository, VCSFileProxy[] roots, GitBranch activeBranch) {
        this.repository = repository;
        this.roots = roots;
        this.panel = new SaveStashPanel();
        this.panel.txtMessage.setText(Bundle.MSG_SaveStash_defaultMessage(activeBranch.getName(), activeBranch.getId().substring(0, 7)));
    }

    String getMessage() {
        return this.panel.txtMessage.getText().trim();
    }

    boolean isIncludeUncommitted() {
        return this.panel.cbIncludeUncommitted.isSelected();
    }

    boolean show() {
        this.okButton = new JButton(Bundle.CTL_SaveStash_okButton_text());
        Mnemonics.setLocalizedText((AbstractButton)this.okButton, (String)this.okButton.getText());
        JButton shelveButton = new JButton(Bundle.CTL_SaveStash_shelveButton_text());
        Mnemonics.setLocalizedText((AbstractButton)shelveButton, (String)shelveButton.getText());
        Object[] buttons = this.roots.length == 0 ? new Object[]{this.okButton, DialogDescriptor.CANCEL_OPTION} : new Object[]{this.okButton, shelveButton, DialogDescriptor.CANCEL_OPTION};
        this.dd = new DialogDescriptor((Object)this.panel, Bundle.LBL_SaveStash_title(this.repository.getName()), true, buttons, (Object)this.okButton, 0, new HelpCtx("org.netbeans.modules.git.remote.ui.stash.SaveStash"), null);
        this.validate();
        this.panel.txtMessage.getDocument().addDocumentListener(this);
        Dialog d = DialogDisplayer.getDefault().createDialog(this.dd);
        d.setVisible(true);
        if (shelveButton == this.dd.getValue()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ((ShelveChangesAction)SystemAction.get(ShelveChangesAction.class)).shelve(SaveStash.this.repository, SaveStash.this.roots);
                }
            });
        }
        return this.okButton == this.dd.getValue();
    }

    private void validate() {
        boolean flag = true;
        if (this.panel.txtMessage.getText().trim().isEmpty()) {
            this.setInfoMessage(Bundle.MSG_SaveStash_emptyMessage());
            flag = false;
        } else if (this.roots.length > 0) {
            this.setInfoMessage(Bundle.MSG_SaveStash_shelveMessage());
        } else {
            this.setInfoMessage(null);
        }
        this.okButton.setEnabled(flag);
        this.dd.setValid(flag);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.validate();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.validate();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    private void setInfoMessage(String message) {
        this.panel.lblInfo.setText(message);
        if (message == null || message.isEmpty()) {
            this.panel.lblInfo.setIcon(null);
        } else {
            this.panel.lblInfo.setIcon(this.ICON_INFO);
        }
    }
}

