/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.toolchain.ui;

import java.io.IOException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.cnd.api.remote.HostInfoProvider;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.MacroExpanderFactory;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class PathEnvVariables
extends JPanel {
    private final String toolPath;
    private final String utilitiesPath;
    private final ExecutionEnvironment env;
    private final MacroConverter converter;
    public static final String PATH = "PATH";
    private JLabel addLabel;
    private JTextField buildTextField;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JLabel modifyBuildLabel;
    private JLabel modifyRunLabel;
    private JLabel pathBuildVariableLabel;
    private JTextField pathBuildVariableTextField;
    private JLabel pathRunVariableLabel;
    private JTextField pathRunVariableTextField;
    private JTextArea previewBuildTextArea;
    private JTextArea previewRunTextArea;
    private JTextField runTextField;
    private JLabel toolsLabel;
    private JTextField toolsValueTextField;
    private JTextField toolsVariableTextField;
    private JLabel utilitiesLabel;
    private JTextField utilitiesValueTextField;
    private JTextField utilitiesVariableTextField;

    public PathEnvVariables(CompilerSet cs, ExecutionEnvironment env) {
        boolean isWindows;
        this.toolPath = cs.getDirectory();
        this.utilitiesPath = cs.getCommandFolder();
        this.env = env;
        this.converter = new MacroConverter(env);
        this.initComponents();
        this.toolsValueTextField.setText("TOOLS_PATH");
        this.utilitiesVariableTextField.setText("UTILITIES_PATH");
        this.pathBuildVariableTextField.setText(PATH);
        this.pathRunVariableTextField.setText(PATH);
        this.buildTextField.setText(cs.getModifyBuildPath());
        this.runTextField.setText(cs.getModifyRunPath());
        this.toolsValueTextField.setText(this.toolPath);
        this.utilitiesValueTextField.setText(this.utilitiesPath);
        this.converter.updateVariables(this.toolPath, this.utilitiesPath);
        boolean bl = isWindows = env.isLocal() && Utilities.isWindows();
        if (!isWindows) {
            this.utilitiesVariableTextField.setVisible(false);
            this.utilitiesLabel.setVisible(false);
            this.utilitiesValueTextField.setVisible(false);
        }
        this.buildTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                PathEnvVariables.this.updatePreview(PathEnvVariables.this.buildTextField, PathEnvVariables.this.previewBuildTextArea);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                PathEnvVariables.this.updatePreview(PathEnvVariables.this.buildTextField, PathEnvVariables.this.previewBuildTextArea);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                PathEnvVariables.this.updatePreview(PathEnvVariables.this.buildTextField, PathEnvVariables.this.previewBuildTextArea);
            }
        });
        this.runTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                PathEnvVariables.this.updatePreview(PathEnvVariables.this.runTextField, PathEnvVariables.this.previewRunTextArea);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                PathEnvVariables.this.updatePreview(PathEnvVariables.this.runTextField, PathEnvVariables.this.previewRunTextArea);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                PathEnvVariables.this.updatePreview(PathEnvVariables.this.runTextField, PathEnvVariables.this.previewRunTextArea);
            }
        });
        DocumentListener documentListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                PathEnvVariables.this.updatePreview(null, null);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                PathEnvVariables.this.updatePreview(null, null);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                PathEnvVariables.this.updatePreview(null, null);
            }
        };
        this.toolsValueTextField.getDocument().addDocumentListener(documentListener);
        this.utilitiesValueTextField.getDocument().addDocumentListener(documentListener);
        this.updatePreview(null, null);
    }

    private void updatePreview(JTextField field, JTextArea preview) {
        this.converter.updateVariables(this.toolsValueTextField.getText(), this.utilitiesValueTextField.getText());
        if (field != null && preview != null) {
            String text = field.getText();
            String expanded = this.converter.expand(text);
            preview.setText(expanded);
        } else {
            String text = this.buildTextField.getText();
            String expanded = this.converter.expand(text);
            this.previewBuildTextArea.setText(expanded);
            text = this.runTextField.getText();
            expanded = this.converter.expand(text);
            this.previewRunTextArea.setText(expanded);
        }
    }

    public String getModifyBuildPath() {
        return this.buildTextField.getText().trim();
    }

    public String getModifyRunPath() {
        return this.runTextField.getText().trim();
    }

    private void initComponents() {
        this.addLabel = new JLabel();
        this.toolsVariableTextField = new JTextField();
        this.toolsLabel = new JLabel();
        this.toolsValueTextField = new JTextField();
        this.utilitiesVariableTextField = new JTextField();
        this.utilitiesLabel = new JLabel();
        this.utilitiesValueTextField = new JTextField();
        this.modifyBuildLabel = new JLabel();
        this.pathBuildVariableTextField = new JTextField();
        this.pathBuildVariableLabel = new JLabel();
        this.buildTextField = new JTextField();
        this.jScrollPane2 = new JScrollPane();
        this.previewBuildTextArea = new JTextArea();
        this.modifyRunLabel = new JLabel();
        this.pathRunVariableTextField = new JTextField();
        this.pathRunVariableLabel = new JLabel();
        this.runTextField = new JTextField();
        this.jScrollPane1 = new JScrollPane();
        this.previewRunTextArea = new JTextArea();
        Mnemonics.setLocalizedText((JLabel)this.addLabel, (String)NbBundle.getMessage(PathEnvVariables.class, (String)"PathEnvVariables.addLabel.text"));
        this.toolsVariableTextField.setEditable(false);
        this.toolsVariableTextField.setText(NbBundle.getMessage(PathEnvVariables.class, (String)"PathEnvVariables.toolsVariableTextField.text"));
        this.toolsVariableTextField.setFocusable(false);
        Mnemonics.setLocalizedText((JLabel)this.toolsLabel, (String)NbBundle.getMessage(PathEnvVariables.class, (String)"PathEnvVariables.toolsLabel.text"));
        this.toolsValueTextField.setEditable(false);
        this.toolsValueTextField.setFocusable(false);
        this.utilitiesVariableTextField.setEditable(false);
        this.utilitiesVariableTextField.setText(NbBundle.getMessage(PathEnvVariables.class, (String)"PathEnvVariables.utilitiesVariableTextField.text"));
        this.utilitiesVariableTextField.setFocusable(false);
        Mnemonics.setLocalizedText((JLabel)this.utilitiesLabel, (String)NbBundle.getMessage(PathEnvVariables.class, (String)"PathEnvVariables.utilitiesLabel.text"));
        this.utilitiesValueTextField.setEditable(false);
        this.utilitiesValueTextField.setFocusable(false);
        Mnemonics.setLocalizedText((JLabel)this.modifyBuildLabel, (String)NbBundle.getMessage(PathEnvVariables.class, (String)"PathEnvVariables.modifyBuildLabel.text"));
        this.pathBuildVariableTextField.setEditable(false);
        this.pathBuildVariableTextField.setText(NbBundle.getMessage(PathEnvVariables.class, (String)"PathEnvVariables.pathBuildVariableTextField.text"));
        this.pathBuildVariableTextField.setFocusable(false);
        Mnemonics.setLocalizedText((JLabel)this.pathBuildVariableLabel, (String)NbBundle.getMessage(PathEnvVariables.class, (String)"PathEnvVariables.pathBuildVariableLabel.text"));
        this.buildTextField.setText(NbBundle.getMessage(PathEnvVariables.class, (String)"ModifyBuildPath"));
        this.previewBuildTextArea.setEditable(false);
        this.previewBuildTextArea.setColumns(20);
        this.previewBuildTextArea.setLineWrap(true);
        this.previewBuildTextArea.setRows(5);
        this.previewBuildTextArea.setFocusable(false);
        this.jScrollPane2.setViewportView(this.previewBuildTextArea);
        Mnemonics.setLocalizedText((JLabel)this.modifyRunLabel, (String)NbBundle.getMessage(PathEnvVariables.class, (String)"PathEnvVariables.modifyRunLabel.text"));
        this.pathRunVariableTextField.setEditable(false);
        this.pathRunVariableTextField.setText(NbBundle.getMessage(PathEnvVariables.class, (String)"PathEnvVariables.pathRunVariableTextField.text"));
        this.pathRunVariableTextField.setFocusable(false);
        Mnemonics.setLocalizedText((JLabel)this.pathRunVariableLabel, (String)NbBundle.getMessage(PathEnvVariables.class, (String)"PathEnvVariables.pathRunVariableLabel.text"));
        this.runTextField.setText(NbBundle.getMessage(PathEnvVariables.class, (String)"ModifyRunPath"));
        this.previewRunTextArea.setEditable(false);
        this.previewRunTextArea.setColumns(20);
        this.previewRunTextArea.setLineWrap(true);
        this.previewRunTextArea.setRows(5);
        this.previewRunTextArea.setFocusable(false);
        this.jScrollPane1.setViewportView(this.previewRunTextArea);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.utilitiesVariableTextField, -1, 106, Short.MAX_VALUE).addComponent(this.toolsVariableTextField)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.utilitiesLabel).addComponent(this.toolsLabel, GroupLayout.Alignment.TRAILING)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.toolsValueTextField).addComponent(this.utilitiesValueTextField))).addGroup(layout.createSequentialGroup().addComponent(this.pathBuildVariableTextField, -2, 61, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pathBuildVariableLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buildTextField)).addComponent(this.addLabel).addComponent(this.modifyBuildLabel).addComponent(this.modifyRunLabel).addGroup(layout.createSequentialGroup().addComponent(this.pathRunVariableTextField, -2, 59, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pathRunVariableLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.runTextField, -2, 519, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.addLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.toolsVariableTextField, -2, -1, -2).addComponent(this.toolsLabel).addComponent(this.toolsValueTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.utilitiesVariableTextField, -2, -1, -2).addComponent(this.utilitiesLabel).addComponent(this.utilitiesValueTextField, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.modifyBuildLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buildTextField, -2, -1, -2).addComponent(this.pathBuildVariableTextField, -2, -1, -2).addComponent(this.pathBuildVariableLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -1, 76, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.modifyRunLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pathRunVariableTextField, -2, -1, -2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.runTextField, -2, -1, -2).addComponent(this.pathRunVariableLabel))).addGap(10, 10, 10).addComponent(this.jScrollPane1, -1, 80, Short.MAX_VALUE).addContainerGap()));
    }

    private static final class MacroConverter {
        private final MacroExpanderFactory.MacroExpander expander;
        private final Map<String, String> envVariables = new HashMap<String, String>();
        private String homeDir;
        private String pathName;
        private String pathSeparator;

        public MacroConverter(ExecutionEnvironment env) {
            if (HostInfoUtils.isHostInfoAvailable((ExecutionEnvironment)env)) {
                try {
                    HostInfo hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)env);
                    this.envVariables.putAll(hostInfo.getEnvironment());
                    this.homeDir = hostInfo.getUserDir();
                    this.pathName = this.getPathName(env, hostInfo);
                    this.pathSeparator = this.getPathSeparator(hostInfo);
                }
                catch (IOException | ConnectionManager.CancellationException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            this.expander = MacroExpanderFactory.getExpander((ExecutionEnvironment)env, (boolean)false);
        }

        private final String getPathName(ExecutionEnvironment env, HostInfo hostInfo) {
            if (hostInfo.getOSFamily() == HostInfo.OSFamily.WINDOWS) {
                for (String key : HostInfoProvider.getEnv((ExecutionEnvironment)env).keySet()) {
                    if (!key.toLowerCase(Locale.getDefault()).equals("path")) continue;
                    return key.substring(0, 4);
                }
            }
            return PathEnvVariables.PATH;
        }

        private final String getPathSeparator(HostInfo hostInfo) {
            if (hostInfo.getOSFamily() == HostInfo.OSFamily.WINDOWS) {
                return ";";
            }
            return ":";
        }

        private void updateVariables(String toolPath, String utilitiesPath) {
            this.envVariables.put("TOOLS_PATH", toolPath);
            this.envVariables.put("UTILITIES_PATH", utilitiesPath);
        }

        public String expand(String in) {
            try {
                if (this.homeDir != null) {
                    if (in.startsWith("~")) {
                        in = this.homeDir + in.substring(1);
                    }
                    in = in.replace(":~", ":" + this.homeDir);
                    in = in.replace(";~", ";" + this.homeDir);
                }
                if (this.pathName != null && !PathEnvVariables.PATH.equals(this.pathName)) {
                    in = in.replace("${PATH}", "${" + this.pathName + "}");
                }
                if (this.pathSeparator != null && !";".equals(this.pathSeparator)) {
                    in = in.replace(";", this.pathSeparator);
                }
                return this.expander != null ? this.expander.expandMacros(in, this.envVariables) : in;
            }
            catch (ParseException parseException) {
                return in;
            }
        }
    }
}

