/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.end2end.profiles.alljava;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.modules.mobility.e2e.classdata.ClassData;
import org.netbeans.modules.mobility.e2e.classdata.FieldData;
import org.netbeans.modules.mobility.e2e.classdata.MethodData;
import org.netbeans.modules.mobility.e2e.classdata.MethodParameter;
import org.netbeans.modules.mobility.javon.JavonMapping;
import org.netbeans.modules.mobility.javon.JavonSerializer;
import org.netbeans.modules.mobility.javon.Traversable;

public class AllJavaSerializer
implements JavonSerializer {
    @Override
    public String getName() {
        return "All Java Serializer";
    }

    @Override
    public boolean isTypeSupported(Traversable traversable, TypeMirror type, Map<String, ClassData> typeCache) {
        return true;
    }

    @Override
    public ClassData getType(Traversable traversable, TypeMirror type, Map<String, ClassData> typeCache) {
        if (TypeKind.DECLARED == type.getKind()) {
            return this.getDeclaredType(traversable, type, typeCache);
        }
        return null;
    }

    private ClassData getDeclaredType(Traversable traversable, TypeMirror type, Map<String, ClassData> typeCache) {
        assert (type.getKind() == TypeKind.DECLARED);
        TypeElement clazz = (TypeElement)((DeclaredType)type).asElement();
        String clsName = clazz.getSimpleName().toString();
        String fqName = clazz.getQualifiedName().toString();
        String pkgName = "";
        if (clsName.length() != fqName.length()) {
            pkgName = fqName.substring(0, fqName.lastIndexOf(46));
        }
        if (typeCache.containsKey(fqName)) {
            return typeCache.get(fqName);
        }
        ClassData clsData = new ClassData(pkgName, clsName, false, false, (JavonSerializer)this);
        typeCache.put(fqName, clsData);
        ArrayList<ClassData> typeParameters = new ArrayList<ClassData>();
        List<? extends TypeMirror> typeParams = ((DeclaredType)type).getTypeArguments();
        for (TypeMirror typeMirror : typeParams) {
            ClassData cdp = traversable.traverseType(typeMirror, typeCache);
            if (cdp == null) continue;
            typeParameters.add(cdp);
        }
        clsData.setParameterTypes(typeParameters);
        return clsData;
    }

    private ClassData getArrayType(TypeMirror type, Map<String, ClassData> typeCache) {
        assert (type.getKind() == TypeKind.ARRAY);
        ArrayType array = (ArrayType)type;
        TypeMirror componentType = array.getComponentType();
        if (componentType.getKind() == TypeKind.ARRAY) {
            this.getArrayType(componentType, typeCache);
        } else {
            TypeElement componentClazz = (TypeElement)((DeclaredType)type).asElement();
            String componentClsName = componentClazz.getSimpleName().toString();
            String componentFqName = componentClazz.getQualifiedName().toString();
            String pkgName = "";
            if (componentClsName.length() != componentFqName.length()) {
                pkgName = componentFqName.substring(0, componentFqName.lastIndexOf(46));
            }
            if (typeCache.containsKey(componentFqName)) {
                ClassData component = typeCache.get(componentFqName);
                if (component.isArray()) {
                    return component;
                }
            } else {
                ClassData result = new ClassData(pkgName, componentClsName, false, false, (JavonSerializer)this);
                typeCache.put(componentFqName, result);
                return result;
            }
        }
        return null;
    }

    @Override
    public String instanceOf(JavonMapping mapping, ClassData type) {
        return type.getFullyQualifiedName();
    }

    @Override
    public String toObject(JavonMapping mapping, ClassData type, String variable) {
        return null;
    }

    @Override
    public String fromObject(JavonMapping mapping, ClassData type, String object) {
        return null;
    }

    @Override
    public String toStream(JavonMapping mapping, ClassData type, String stream, String object) {
        return null;
    }

    @Override
    public String fromStream(JavonMapping mapping, ClassData type, String stream, String object) {
        return null;
    }

    private String displayClassData(ClassData clsData) {
        StringBuffer result = new StringBuffer(clsData.getFullyQualifiedName() + "\n\n");
        for (FieldData fe : clsData.getFields()) {
            result.append((Object)((Object)fe.getModifier()) + " " + fe.getType() + " " + fe.getName() + "\n");
        }
        result.append("\n");
        for (MethodData me : clsData.getMethods()) {
            result.append(me.getReturnType() + " " + me.getName() + "(");
            int i = 0;
            for (MethodParameter mp : me.getParameters()) {
                result.append(mp.getType().getFullyQualifiedName() + " " + mp.getName());
                if (i == me.getParameters().size() - 1) {
                    result.append(",");
                    continue;
                }
                result.append(")\n");
            }
        }
        return result.toString();
    }

    @Override
    public Set<ClassData> getReferencedTypes(ClassData rootClassData, Set<ClassData> usedTypes) {
        return Collections.singleton(rootClassData);
    }
}

