/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Level;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.api.project.NativeFileItemSet;
import org.netbeans.modules.cnd.api.toolchain.PredefinedToolKind;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.MIMESupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;

public class ItemEx
extends Item {
    private DataObject lastDataObject = null;

    private ItemEx(FileObject baseDirFileObject, String path) {
        super(baseDirFileObject, path);
    }

    private ItemEx(FileSystem fileSystem, String path) {
        super(fileSystem, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFolder(Folder folder) {
        if (folder == null && this.file == null) {
            this.ensureFileNotNull();
        }
        if (folder == null) {
            ItemEx itemEx = this;
            synchronized (itemEx) {
                this.detachFrom(this.lastDataObject);
                this.lastDataObject = null;
            }
        } else {
            this.folder = folder;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("name")) {
            FileObject fo;
            String newName = (String)evt.getNewValue();
            boolean nameWithoutExtension = true;
            Object o = evt.getSource();
            if (o instanceof DataObject && (fo = ((DataObject)o).getPrimaryFile()) != null) {
                newName = fo.getNameExt();
                nameWithoutExtension = false;
            }
            this.rename(newName, nameWithoutExtension);
        } else if (evt.getPropertyName().equals("valid")) {
            if (!((Boolean)evt.getNewValue()).booleanValue()) {
                DataObject dao;
                FileObject fo;
                Object o = evt.getSource();
                if (o instanceof DataObject && (fo = (dao = (DataObject)o).getPrimaryFile()) != null && fo.isValid()) {
                    this.rename(fo.getNameExt(), false);
                    try {
                        DataObject dataObject = DataObject.find((FileObject)fo);
                        ItemEx itemEx = this;
                        synchronized (itemEx) {
                            if (dataObject != this.lastDataObject) {
                                this.detachFrom(this.lastDataObject);
                                this.attachTo(dataObject);
                            }
                        }
                    }
                    catch (DataObjectNotFoundException ex) {
                        LOG.log(Level.FINE, "Can not find data object", ex);
                    }
                    return;
                }
                Folder containingFolder = this.getFolder();
                if (containingFolder != null) {
                    containingFolder.refresh((Object)this);
                }
            } else {
                Object o = evt.getSource();
                if (o instanceof DataObject) {
                    DataObject dao = (DataObject)o;
                    ItemEx itemEx = this;
                    synchronized (itemEx) {
                        if (this.lastDataObject != null) {
                            this.detachFrom(this.lastDataObject);
                        }
                        this.lastDataObject = dao;
                        this.attachTo(this.lastDataObject);
                    }
                }
            }
        } else if (evt.getPropertyName().equals("primaryFile") && this.getFolder() != null) {
            FileObject fo = (FileObject)evt.getNewValue();
            String newPath = fo.getPath();
            if (!CndPathUtilities.isPathAbsolute((FileSystem)this.fileSystem, (String)this.getPath())) {
                newPath = CndPathUtilities.toRelativePath((FileObject)this.getFolder().getConfigurationDescriptor().getBaseDirFileObject(), (String)newPath);
            }
            newPath = CndPathUtilities.normalizeSlashes((String)newPath);
            this.renameTo(newPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataObject getDataObject() {
        ItemEx itemEx = this;
        synchronized (itemEx) {
            if (this.lastDataObject != null && this.lastDataObject.isValid()) {
                return this.lastDataObject;
            }
        }
        DataObject dataObject = null;
        FileObject fo = this.getFileObjectImpl();
        if (fo != null && fo.isValid()) {
            try {
                dataObject = DataObject.find((FileObject)fo);
            }
            catch (DataObjectNotFoundException e) {
                LOG.log(Level.FINE, "Can not find data object", e);
            }
        }
        ItemEx itemEx2 = this;
        synchronized (itemEx2) {
            if (dataObject != this.lastDataObject) {
                this.detachFrom(this.lastDataObject);
                this.attachTo(dataObject);
            }
        }
        return dataObject;
    }

    private void attachTo(DataObject dataObject) {
        if (dataObject != null) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.log(Level.FINEST, "attaching {0} to {1}", new Object[]{System.identityHashCode((Object)this), dataObject});
            }
            dataObject.removePropertyChangeListener((PropertyChangeListener)((Object)this));
            dataObject.addPropertyChangeListener((PropertyChangeListener)((Object)this));
            NativeFileItemSet set = (NativeFileItemSet)dataObject.getLookup().lookup(NativeFileItemSet.class);
            if (set != null) {
                set.add((NativeFileItem)this);
            }
        }
        this.lastDataObject = dataObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onOpen() {
        ItemEx itemEx = this;
        synchronized (itemEx) {
            this.attachTo(this.lastDataObject);
        }
    }

    private void detachFrom(DataObject dao) {
        if (dao != null) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.log(Level.FINEST, "detaching {0} from {1}", new Object[]{System.identityHashCode((Object)this), dao});
            }
            dao.removePropertyChangeListener((PropertyChangeListener)((Object)this));
            NativeFileItemSet set = (NativeFileItemSet)dao.getLookup().lookup(NativeFileItemSet.class);
            if (set != null) {
                set.remove((NativeFileItem)this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onClose() {
        ItemEx itemEx = this;
        synchronized (itemEx) {
            this.detachFrom(this.lastDataObject);
        }
    }

    public String getMIMEType() {
        return ItemEx.getMIMETypeImpl(this.getDataObject(), this);
    }

    private static String getMIMETypeImpl(DataObject dataObject, ItemEx item) {
        FileObject fobj;
        FileObject fileObject = fobj = dataObject == null ? null : dataObject.getPrimaryFile();
        if (fobj == null) {
            fobj = item.getFileObjectImpl();
        }
        String mimeType = fobj == null || !fobj.isValid() ? MIMESupport.getKnownSourceFileMIMETypeByExtension((String)item.getName()) : MIMESupport.getSourceFileMIMEType((FileObject)fobj);
        return mimeType;
    }

    static PredefinedToolKind getDefaultToolForItem(DataObject dataObject, ItemEx item) {
        PredefinedToolKind tool;
        String mimeType = ItemEx.getMIMETypeImpl(dataObject, item);
        if ("text/x-c".equals(mimeType)) {
            tool = PredefinedToolKind.CCompiler;
        } else if ("text/x-h".equals(mimeType)) {
            tool = PredefinedToolKind.CustomTool;
        } else if ("text/x-c++".equals(mimeType)) {
            tool = PredefinedToolKind.CCCompiler;
        } else if ("text/x-fortran".equals(mimeType)) {
            tool = PredefinedToolKind.FortranCompiler;
        } else if ("text/x-asm".equals(mimeType)) {
            FileObject fobj;
            FileObject fileObject = fobj = dataObject == null ? null : dataObject.getPrimaryFile();
            if (fobj == null) {
                fobj = item.getFileObjectImpl();
            }
            tool = fobj != null && "il".equals(fobj.getExt()) ? PredefinedToolKind.CustomTool : PredefinedToolKind.Assembler;
        } else {
            tool = PredefinedToolKind.CustomTool;
        }
        return tool;
    }

    public PredefinedToolKind getDefaultTool() {
        return ItemEx.getDefaultToolForItem(this.getDataObject(), this);
    }

    protected void onAddedToFolder(Folder folder) {
        NativeFileItemSet myNativeFileItemSet;
        DataObject dao = this.getDataObject();
        NativeFileItemSet nativeFileItemSet = myNativeFileItemSet = dao == null ? null : (NativeFileItemSet)dao.getLookup().lookup(NativeFileItemSet.class);
        if (myNativeFileItemSet != null) {
            myNativeFileItemSet.add((NativeFileItem)this);
        } else if (LOG.isLoggable(Level.FINEST)) {
            LOG.log(Level.FINEST, "can not add NativeFileItem for folder''s {0} item {1} using {2}", new Object[]{folder, this, dao});
        }
    }

    public static final class ItemFactoryEx
    extends Item.ItemFactory {
        public Item createInBaseDir(FileObject baseDirFileObject, String path) {
            return new ItemEx(baseDirFileObject, path);
        }

        public Item createInFileSystem(FileSystem fileSystem, String path) {
            return new ItemEx(fileSystem, path);
        }

        public Item createDetachedViewItem(FileSystem fileSystem, String path) {
            CndUtils.assertNonUiThread();
            ItemEx out = new ItemEx(fileSystem, path);
            DataObject dobj = out.getDataObject();
            out.detachFrom(dobj);
            CndUtils.assertTrueInConsole((out.lastDataObject == dobj ? 1 : 0) != 0, (String)"data object should stay the same ", (Object)out.lastDataObject);
            return out;
        }
    }
}

