/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javap;

import com.sun.tools.classfile.ClassFile;
import com.sun.tools.classfile.ConstantPool;
import com.sun.tools.classfile.ConstantPoolException;
import com.sun.tools.javap.BasicWriter;
import com.sun.tools.javap.ClassWriter;
import com.sun.tools.javap.Context;
import com.sun.tools.javap.Options;

public class ConstantWriter
extends BasicWriter {
    StringValueVisitor stringValueVisitor = new StringValueVisitor();
    private ClassWriter classWriter;
    private Options options;

    public static ConstantWriter instance(Context context) {
        ConstantWriter instance = context.get(ConstantWriter.class);
        if (instance == null) {
            instance = new ConstantWriter(context);
        }
        return instance;
    }

    protected ConstantWriter(Context context) {
        super(context);
        context.put(ConstantWriter.class, this);
        this.classWriter = ClassWriter.instance(context);
        this.options = Options.instance(context);
    }

    protected void writeConstantPool() {
        ConstantPool constant_pool = this.classWriter.getClassFile().constant_pool;
        this.writeConstantPool(constant_pool);
    }

    protected void writeConstantPool(ConstantPool constant_pool) {
        ConstantPool.Visitor<Integer, Void> v = new ConstantPool.Visitor<Integer, Void>(){

            @Override
            public Integer visitClass(ConstantPool.CONSTANT_Class_info info, Void p) {
                ConstantWriter.this.print("#" + info.name_index);
                ConstantWriter.this.tab();
                ConstantWriter.this.println("// " + ConstantWriter.this.stringValue(info));
                return 1;
            }

            @Override
            public Integer visitDouble(ConstantPool.CONSTANT_Double_info info, Void p) {
                ConstantWriter.this.println(ConstantWriter.this.stringValue(info));
                return 2;
            }

            @Override
            public Integer visitFieldref(ConstantPool.CONSTANT_Fieldref_info info, Void p) {
                ConstantWriter.this.print("#" + info.class_index + ".#" + info.name_and_type_index);
                ConstantWriter.this.tab();
                ConstantWriter.this.println("// " + ConstantWriter.this.stringValue(info));
                return 1;
            }

            @Override
            public Integer visitFloat(ConstantPool.CONSTANT_Float_info info, Void p) {
                ConstantWriter.this.println(ConstantWriter.this.stringValue(info));
                return 1;
            }

            @Override
            public Integer visitInteger(ConstantPool.CONSTANT_Integer_info info, Void p) {
                ConstantWriter.this.println(ConstantWriter.this.stringValue(info));
                return 1;
            }

            @Override
            public Integer visitInterfaceMethodref(ConstantPool.CONSTANT_InterfaceMethodref_info info, Void p) {
                ConstantWriter.this.print("#" + info.class_index + ".#" + info.name_and_type_index);
                ConstantWriter.this.tab();
                ConstantWriter.this.println("// " + ConstantWriter.this.stringValue(info));
                return 1;
            }

            @Override
            public Integer visitInvokeDynamic(ConstantPool.CONSTANT_InvokeDynamic_info info, Void p) {
                ConstantWriter.this.print("#" + info.bootstrap_method_attr_index + ":#" + info.name_and_type_index);
                ConstantWriter.this.tab();
                ConstantWriter.this.println("// " + ConstantWriter.this.stringValue(info));
                return 1;
            }

            @Override
            public Integer visitLong(ConstantPool.CONSTANT_Long_info info, Void p) {
                ConstantWriter.this.println(ConstantWriter.this.stringValue(info));
                return 2;
            }

            @Override
            public Integer visitNameAndType(ConstantPool.CONSTANT_NameAndType_info info, Void p) {
                ConstantWriter.this.print("#" + info.name_index + ":#" + info.type_index);
                ConstantWriter.this.tab();
                ConstantWriter.this.println("// " + ConstantWriter.this.stringValue(info));
                return 1;
            }

            @Override
            public Integer visitMethodref(ConstantPool.CONSTANT_Methodref_info info, Void p) {
                ConstantWriter.this.print("#" + info.class_index + ".#" + info.name_and_type_index);
                ConstantWriter.this.tab();
                ConstantWriter.this.println("// " + ConstantWriter.this.stringValue(info));
                return 1;
            }

            @Override
            public Integer visitMethodHandle(ConstantPool.CONSTANT_MethodHandle_info info, Void p) {
                ConstantWriter.this.print("#" + info.reference_kind.tag + ":#" + info.reference_index);
                ConstantWriter.this.tab();
                ConstantWriter.this.println("// " + ConstantWriter.this.stringValue(info));
                return 1;
            }

            @Override
            public Integer visitMethodType(ConstantPool.CONSTANT_MethodType_info info, Void p) {
                ConstantWriter.this.print("#" + info.descriptor_index);
                ConstantWriter.this.tab();
                ConstantWriter.this.println("//  " + ConstantWriter.this.stringValue(info));
                return 1;
            }

            @Override
            public Integer visitString(ConstantPool.CONSTANT_String_info info, Void p) {
                ConstantWriter.this.print("#" + info.string_index);
                ConstantWriter.this.tab();
                ConstantWriter.this.println("// " + ConstantWriter.this.stringValue(info));
                return 1;
            }

            @Override
            public Integer visitUtf8(ConstantPool.CONSTANT_Utf8_info info, Void p) {
                ConstantWriter.this.println(ConstantWriter.this.stringValue(info));
                return 1;
            }
        };
        this.println("Constant pool:");
        this.indent(1);
        int width = String.valueOf(constant_pool.size()).length() + 1;
        int cpx = 1;
        while (cpx < constant_pool.size()) {
            this.print(String.format("%" + width + "s", "#" + cpx));
            try {
                ConstantPool.CPInfo cpInfo = constant_pool.get(cpx);
                this.print(String.format(" = %-18s ", this.cpTagName(cpInfo)));
                cpx += cpInfo.accept(v, null).intValue();
            }
            catch (ConstantPool.InvalidIndex invalidIndex) {}
        }
        this.indent(-1);
    }

    protected void write(int cpx) {
        ConstantPool.CPInfo cpInfo;
        ClassFile classFile = this.classWriter.getClassFile();
        if (cpx == 0) {
            this.print("#0");
            return;
        }
        try {
            cpInfo = classFile.constant_pool.get(cpx);
        }
        catch (ConstantPoolException e) {
            this.print("#" + cpx);
            return;
        }
        int tag = cpInfo.getTag();
        switch (tag) {
            case 9: 
            case 10: 
            case 11: {
                ConstantPool.CPRefInfo ref = (ConstantPool.CPRefInfo)cpInfo;
                try {
                    if (ref.class_index != classFile.this_class) break;
                    cpInfo = classFile.constant_pool.get(ref.name_and_type_index);
                    break;
                }
                catch (ConstantPool.InvalidIndex invalidIndex) {
                    // empty catch block
                }
            }
        }
        this.print(this.tagName(tag) + " " + this.stringValue(cpInfo));
    }

    String cpTagName(ConstantPool.CPInfo cpInfo) {
        String n = cpInfo.getClass().getSimpleName();
        return n.replace("CONSTANT_", "").replace("_info", "");
    }

    String tagName(int tag) {
        switch (tag) {
            case 1: {
                return "Utf8";
            }
            case 3: {
                return "int";
            }
            case 4: {
                return "float";
            }
            case 5: {
                return "long";
            }
            case 6: {
                return "double";
            }
            case 7: {
                return "class";
            }
            case 8: {
                return "String";
            }
            case 9: {
                return "Field";
            }
            case 15: {
                return "MethodHandle";
            }
            case 16: {
                return "MethodType";
            }
            case 10: {
                return "Method";
            }
            case 11: {
                return "InterfaceMethod";
            }
            case 18: {
                return "InvokeDynamic";
            }
            case 12: {
                return "NameAndType";
            }
        }
        return "(unknown tag " + tag + ")";
    }

    public String stringValue(int constant_pool_index) {
        ClassFile classFile = this.classWriter.getClassFile();
        try {
            return this.stringValue(classFile.constant_pool.get(constant_pool_index));
        }
        catch (ConstantPool.InvalidIndex e) {
            return this.report(e);
        }
    }

    String stringValue(ConstantPool.CPInfo cpInfo) {
        return this.stringValueVisitor.visit(cpInfo);
    }

    private static String checkName(String name) {
        int cp;
        if (name == null) {
            return "null";
        }
        int len = name.length();
        if (len == 0) {
            return "\"\"";
        }
        int cc = 47;
        for (int k = 0; k < len; k += Character.charCount(cp)) {
            cp = name.codePointAt(k);
            if (cc == 47 && !Character.isJavaIdentifierStart(cp) || cp != 47 && !Character.isJavaIdentifierPart(cp)) {
                return "\"" + ConstantWriter.addEscapes(name) + "\"";
            }
            cc = cp;
        }
        return name;
    }

    private static String addEscapes(String name) {
        String esc = "\\\"\n\t";
        String rep = "\\\"nt";
        StringBuilder buf = null;
        int nextk = 0;
        int len = name.length();
        for (int k = 0; k < len; ++k) {
            char cp = name.charAt(k);
            int n = esc.indexOf(cp);
            if (n < 0) continue;
            if (buf == null) {
                buf = new StringBuilder(len * 2);
            }
            if (nextk < k) {
                buf.append(name, nextk, k);
            }
            buf.append('\\');
            buf.append(rep.charAt(n));
            nextk = k + 1;
        }
        if (buf == null) {
            return name;
        }
        if (nextk < len) {
            buf.append(name, nextk, len);
        }
        return buf.toString();
    }

    private class StringValueVisitor
    implements ConstantPool.Visitor<String, Void> {
        private StringValueVisitor() {
        }

        public String visit(ConstantPool.CPInfo info) {
            return info.accept(this, null);
        }

        @Override
        public String visitClass(ConstantPool.CONSTANT_Class_info info, Void p) {
            return this.getCheckedName(info);
        }

        String getCheckedName(ConstantPool.CONSTANT_Class_info info) {
            try {
                return ConstantWriter.checkName(info.getName());
            }
            catch (ConstantPoolException e) {
                return ConstantWriter.this.report(e);
            }
        }

        @Override
        public String visitDouble(ConstantPool.CONSTANT_Double_info info, Void p) {
            return info.value + "d";
        }

        @Override
        public String visitFieldref(ConstantPool.CONSTANT_Fieldref_info info, Void p) {
            return this.visitRef(info, p);
        }

        @Override
        public String visitFloat(ConstantPool.CONSTANT_Float_info info, Void p) {
            return info.value + "f";
        }

        @Override
        public String visitInteger(ConstantPool.CONSTANT_Integer_info info, Void p) {
            return String.valueOf(info.value);
        }

        @Override
        public String visitInterfaceMethodref(ConstantPool.CONSTANT_InterfaceMethodref_info info, Void p) {
            return this.visitRef(info, p);
        }

        @Override
        public String visitInvokeDynamic(ConstantPool.CONSTANT_InvokeDynamic_info info, Void p) {
            try {
                String callee = ConstantWriter.this.stringValue(info.getNameAndTypeInfo());
                return "#" + info.bootstrap_method_attr_index + ":" + callee;
            }
            catch (ConstantPoolException e) {
                return ConstantWriter.this.report(e);
            }
        }

        @Override
        public String visitLong(ConstantPool.CONSTANT_Long_info info, Void p) {
            return info.value + "l";
        }

        @Override
        public String visitNameAndType(ConstantPool.CONSTANT_NameAndType_info info, Void p) {
            return this.getCheckedName(info) + ":" + this.getType(info);
        }

        String getCheckedName(ConstantPool.CONSTANT_NameAndType_info info) {
            try {
                return ConstantWriter.checkName(info.getName());
            }
            catch (ConstantPoolException e) {
                return ConstantWriter.this.report(e);
            }
        }

        String getType(ConstantPool.CONSTANT_NameAndType_info info) {
            try {
                return info.getType();
            }
            catch (ConstantPoolException e) {
                return ConstantWriter.this.report(e);
            }
        }

        @Override
        public String visitMethodHandle(ConstantPool.CONSTANT_MethodHandle_info info, Void p) {
            try {
                return info.reference_kind.name + " " + ConstantWriter.this.stringValue(info.getCPRefInfo());
            }
            catch (ConstantPoolException e) {
                return ConstantWriter.this.report(e);
            }
        }

        @Override
        public String visitMethodType(ConstantPool.CONSTANT_MethodType_info info, Void p) {
            try {
                return info.getType();
            }
            catch (ConstantPoolException e) {
                return ConstantWriter.this.report(e);
            }
        }

        @Override
        public String visitMethodref(ConstantPool.CONSTANT_Methodref_info info, Void p) {
            return this.visitRef(info, p);
        }

        @Override
        public String visitString(ConstantPool.CONSTANT_String_info info, Void p) {
            try {
                ClassFile classFile = ConstantWriter.this.classWriter.getClassFile();
                int string_index = info.string_index;
                return ConstantWriter.this.stringValue(classFile.constant_pool.getUTF8Info(string_index));
            }
            catch (ConstantPoolException e) {
                return ConstantWriter.this.report(e);
            }
        }

        @Override
        public String visitUtf8(ConstantPool.CONSTANT_Utf8_info info, Void p) {
            String s = info.value;
            StringBuilder sb = new StringBuilder();
            block10: for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                switch (c) {
                    case '\t': {
                        sb.append('\\').append('t');
                        continue block10;
                    }
                    case '\n': {
                        sb.append('\\').append('n');
                        continue block10;
                    }
                    case '\r': {
                        sb.append('\\').append('r');
                        continue block10;
                    }
                    case '\b': {
                        sb.append('\\').append('b');
                        continue block10;
                    }
                    case '\f': {
                        sb.append('\\').append('f');
                        continue block10;
                    }
                    case '\"': {
                        sb.append('\\').append('\"');
                        continue block10;
                    }
                    case '\'': {
                        sb.append('\\').append('\'');
                        continue block10;
                    }
                    case '\\': {
                        sb.append('\\').append('\\');
                        continue block10;
                    }
                    default: {
                        sb.append(c);
                    }
                }
            }
            return sb.toString();
        }

        String visitRef(ConstantPool.CPRefInfo info, Void p) {
            String nat;
            String cn = this.getCheckedClassName(info);
            try {
                nat = ConstantWriter.this.stringValue(info.getNameAndTypeInfo());
            }
            catch (ConstantPoolException e) {
                nat = ConstantWriter.this.report(e);
            }
            return cn + "." + nat;
        }

        String getCheckedClassName(ConstantPool.CPRefInfo info) {
            try {
                return ConstantWriter.checkName(info.getClassName());
            }
            catch (ConstantPoolException e) {
                return ConstantWriter.this.report(e);
            }
        }
    }
}

