/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.wizard.api.support;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.api.toolchain.AbstractCompiler;
import org.netbeans.modules.cnd.api.toolchain.CompilerFlavor;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.CompilerSetUtils;
import org.netbeans.modules.cnd.api.toolchain.PredefinedToolKind;
import org.netbeans.modules.cnd.api.toolchain.ToolKind;
import org.netbeans.modules.cnd.discovery.api.ItemProperties;
import org.netbeans.modules.cnd.discovery.projectimport.ImportProject;
import org.netbeans.modules.cnd.makeproject.api.configurations.BasicCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.BooleanConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.CCCCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationAuxObject;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.FolderConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.ItemConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.wizards.ProjectGenerator;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.netbeans.modules.cnd.utils.FSPath;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.util.Utilities;

public class ProjectBridge {
    private final String baseFolder;
    private final FileSystem baseFolderFileSystem;
    private final MakeConfigurationDescriptor makeConfigurationDescriptor;
    private boolean startedModification;
    private final Project project;
    private final Set<Project> resultSet = new HashSet<Project>();
    private Map<String, Item> canonicalItems;
    private ConfigurationDescriptorProvider.SnapShot delta;
    private static final String PATTERN_1 = "/./";
    private static final String PATTERN_2 = "/.";
    private static final String PATTERN_3 = "/../";
    private static final String PATTERN_4 = "/..";
    private final Map<String, String> cache = new HashMap<String, String>();
    private List<String> systemIncludePathsC;
    private List<String> systemIncludePathsCpp;
    private static final String CYG_DRIVE_UNIX = "/cygdrive/";
    private Map<String, String> systemMacroDefinitionsC;
    private Map<String, String> systemMacroDefinitionsCpp;

    public ProjectBridge(Project project) {
        this.project = project;
        this.resultSet.add(project);
        ConfigurationDescriptorProvider pdp = (ConfigurationDescriptorProvider)project.getLookup().lookup(ConfigurationDescriptorProvider.class);
        if (pdp != null) {
            this.makeConfigurationDescriptor = pdp.getConfigurationDescriptor();
            this.baseFolderFileSystem = this.makeConfigurationDescriptor != null ? this.makeConfigurationDescriptor.getBaseDirFileSystem() : CndFileUtils.getLocalFileSystem();
        } else {
            this.makeConfigurationDescriptor = null;
            this.baseFolderFileSystem = CndFileUtils.getLocalFileSystem();
        }
        this.baseFolder = CndFileUtils.normalizePath((FileObject)project.getProjectDirectory());
    }

    public boolean isValid() {
        return this.makeConfigurationDescriptor != null;
    }

    public void startModifications() {
        ConfigurationDescriptorProvider pdp = (ConfigurationDescriptorProvider)this.project.getLookup().lookup(ConfigurationDescriptorProvider.class);
        if (pdp != null) {
            this.delta = pdp.startModifications();
            this.startedModification = true;
        }
    }

    public ProjectBridge(String baseFolder) throws IOException {
        this.baseFolder = baseFolder;
        MakeConfiguration extConf = MakeConfiguration.createMakefileConfiguration((FSPath)new FSPath(CndFileUtils.getLocalFileSystem(), baseFolder), (String)"Default", (String)"localhost");
        String workingDir = baseFolder;
        String workingDirRel = CndPathUtilities.toRelativePath((String)baseFolder, (String)CndPathUtilities.naturalizeSlashes((String)workingDir));
        workingDirRel = CndPathUtilities.normalizeSlashes((String)workingDirRel);
        extConf.getMakefileConfiguration().getBuildCommandWorkingDir().setValue(workingDirRel);
        String prjName = "DiscoveryProject";
        ProjectGenerator.ProjectParameters prjParams = new ProjectGenerator.ProjectParameters(prjName, CndFileUtils.createLocalFile((String)baseFolder, (String)prjName));
        prjParams.setOpenFlag(true).setConfiguration(extConf);
        this.project = ProjectGenerator.getDefault().createBlankProject(prjParams);
        this.resultSet.add(this.project);
        ConfigurationDescriptorProvider pdp = (ConfigurationDescriptorProvider)this.project.getLookup().lookup(ConfigurationDescriptorProvider.class);
        this.makeConfigurationDescriptor = pdp.getConfigurationDescriptor();
        this.baseFolderFileSystem = this.makeConfigurationDescriptor.getBaseDirFileSystem();
    }

    public Folder createFolder(Folder parent, String name) {
        return new Folder(this.makeConfigurationDescriptor, parent, name, name, true, null);
    }

    public void addSourceRoot(String path) {
        this.makeConfigurationDescriptor.addSourceRootRaw(path);
    }

    public FileSystem getBaseFolderFileSystem() {
        return this.baseFolderFileSystem;
    }

    public Item createItem(String path) {
        return Item.ItemFactory.getDefault().createInFileSystem(this.baseFolderFileSystem, this.getRelativepath(path));
    }

    public static boolean excludeItemFromOtherConfigurations(Item item) {
        boolean changed = false;
        for (Configuration c : item.getFolder().getConfigurationDescriptor().getConfs().getConfigurations()) {
            BooleanConfiguration excl;
            MakeConfiguration makeConfiguration;
            ItemConfiguration itemConfiguration;
            if (c.isDefault() || (itemConfiguration = item.getItemConfiguration((Configuration)(makeConfiguration = (MakeConfiguration)c))) == null || (excl = itemConfiguration.getExcluded()).getValue()) continue;
            excl.setValue(true);
            changed = true;
        }
        return changed;
    }

    public Item getProjectItem(String path) {
        Item item = this.makeConfigurationDescriptor.findProjectItemByPath(path);
        if (item == null) {
            if (!CndPathUtilities.isPathAbsolute((CharSequence)path)) {
                path = CndPathUtilities.toAbsolutePath((FileSystem)this.baseFolderFileSystem, (String)this.baseFolder, (String)path);
            }
            item = this.findByCanonicalName(path);
        }
        return item;
    }

    public boolean checkForNewExtensions(Set<String> needAdd) {
        HashSet<String> extensions = new HashSet<String>();
        for (String name : needAdd) {
            String extension;
            int i = name.replace('\\', '/').lastIndexOf(47);
            if (i >= 0) {
                name = name.substring(i + 1);
            }
            if ((i = name.lastIndexOf(46)) <= 0 || (extension = name.substring(i + 1)).length() <= 0) continue;
            extensions.add(extension);
        }
        HashSet<Item> old = new HashSet<Item>(Arrays.asList(this.getAllSources()));
        if (extensions.contains("xml")) {
            assert (false) : "Extension '.xml' cannot be a header extension";
            extensions.remove("xml");
        }
        boolean isChanged = false;
        if (this.makeConfigurationDescriptor.addAdditionalHeaderExtensions(extensions)) {
            for (Item item : this.getAllSources()) {
                if (old.contains(item)) continue;
                ProjectBridge.setExclude(item, true);
                isChanged = true;
            }
        }
        return isChanged;
    }

    private Item findByCanonicalName(String path) {
        if (this.canonicalItems == null) {
            this.canonicalItems = new HashMap<String, Item>();
            for (Item item : this.makeConfigurationDescriptor.getProjectItems()) {
                this.canonicalItems.put(item.getCanonicalPath(), item);
            }
        }
        return this.canonicalItems.get(path);
    }

    public Object getAuxObject(Item item) {
        MakeConfiguration makeConfiguration = item.getFolder().getConfigurationDescriptor().getActiveConfiguration();
        ItemConfiguration itemConfiguration = item.getItemConfiguration((Configuration)makeConfiguration);
        return itemConfiguration;
    }

    public void setAuxObject(Item item, Object pao) {
        if (pao instanceof ItemConfiguration) {
            ItemConfiguration conf = (ItemConfiguration)pao;
            MakeConfiguration makeConfiguration = item.getFolder().getConfigurationDescriptor().getActiveConfiguration();
            ItemConfiguration itemConfiguration = item.getItemConfiguration((Configuration)makeConfiguration);
            switch (itemConfiguration.getTool()) {
                case CCCompiler: {
                    itemConfiguration.setCCCompilerConfiguration(conf.getCCCompilerConfiguration());
                    break;
                }
                case CCompiler: {
                    itemConfiguration.setCCompilerConfiguration(conf.getCCompilerConfiguration());
                    break;
                }
                case CustomTool: {
                    itemConfiguration.setCustomToolConfiguration(conf.getCustomToolConfiguration());
                }
            }
        }
    }

    public void convertIncludePaths(Set<String> set, List<String> paths, String compilePath, String filePath) {
        ArrayList<String> ordinary = new ArrayList<String>();
        for (String path : paths) {
            String aPath;
            if (path.startsWith("/") || path.length() > 1 && path.charAt(1) == ':') {
                aPath = CndFileUtils.normalizeAbsolutePath((FileSystem)this.baseFolderFileSystem, (String)path);
                ordinary.add(this.getRelativepath(aPath));
                continue;
            }
            if (path.equals(".")) {
                aPath = CndFileUtils.normalizeAbsolutePath((FileSystem)this.baseFolderFileSystem, (String)compilePath);
                ordinary.add(this.getRelativepath(aPath));
                continue;
            }
            aPath = compilePath + CndFileUtils.getFileSeparatorChar((FileSystem)this.baseFolderFileSystem) + path;
            aPath = CndFileUtils.normalizeAbsolutePath((FileSystem)this.baseFolderFileSystem, (String)aPath);
            ordinary.add(this.getRelativepath(aPath));
        }
        if (this.isDifferentCompilePath(filePath, compilePath = CndFileUtils.normalizeAbsolutePath((FileSystem)this.baseFolderFileSystem, (String)compilePath))) {
            ordinary.add(this.getRelativepath(compilePath));
        }
        set.addAll(ordinary);
    }

    public void convertIncludeFiles(Set<String> set, List<String> files, String compilePath, Collection<String> paths) {
        ArrayList<String> ordinary = new ArrayList<String>();
        for (String path : files) {
            String aPath;
            if (path.startsWith("/") || path.length() > 1 && path.charAt(1) == ':') {
                aPath = CndFileUtils.normalizeAbsolutePath((FileSystem)this.baseFolderFileSystem, (String)path);
                ordinary.add(this.getRelativepath(aPath));
                continue;
            }
            aPath = compilePath + CndFileUtils.getFileSeparatorChar((FileSystem)this.baseFolderFileSystem) + path;
            if (CndFileUtils.isExistingFile((FileSystem)this.baseFolderFileSystem, (String)(aPath = CndFileUtils.normalizeAbsolutePath((FileSystem)this.baseFolderFileSystem, (String)aPath)))) {
                ordinary.add(this.getRelativepath(aPath));
                continue;
            }
            boolean found = false;
            for (String p : paths) {
                if (!(p.startsWith("/") || p.length() > 1 && p.charAt(1) == ':')) {
                    p = CndPathUtilities.toAbsolutePath((FileObject)this.makeConfigurationDescriptor.getBaseDirFileObject(), (String)p);
                }
                aPath = p + CndFileUtils.getFileSeparatorChar((FileSystem)this.baseFolderFileSystem) + path;
                if (!CndFileUtils.isExistingFile((FileSystem)this.baseFolderFileSystem, (String)(aPath = CndFileUtils.normalizeAbsolutePath((FileSystem)this.baseFolderFileSystem, (String)aPath)))) continue;
                ordinary.add(this.getRelativepath(aPath));
                found = true;
                break;
            }
            if (!found) continue;
            ordinary.add(this.getRelativepath(aPath));
        }
        set.addAll(ordinary);
    }

    private boolean isDifferentCompilePath(String name, String path) {
        int i;
        if (Utilities.isWindows()) {
            name = name.replace('\\', '/');
        }
        return (i = name.lastIndexOf(47)) > 0 && !(name = name.substring(0, i)).equals(path);
    }

    public String getRelativepath(String path) {
        path = CndPathUtilities.toRelativePath((FileObject)this.makeConfigurationDescriptor.getBaseDirFileObject(), (String)path);
        if (Utilities.isWindows()) {
            path = path.replace('\\', '/');
        }
        path = this.cutLocalRelative(path);
        path = CndPathUtilities.normalizeSlashes((String)path);
        return path;
    }

    private String cutLocalRelative(String path) {
        int i;
        String pattern = PATTERN_1;
        while ((i = path.indexOf(pattern)) >= 0) {
            path = path.substring(0, i + 1) + path.substring(i + pattern.length());
        }
        pattern = PATTERN_2;
        if (path.endsWith(pattern)) {
            path = path.substring(0, path.length() - pattern.length());
        }
        pattern = PATTERN_3;
        while ((i = path.indexOf(pattern)) >= 0) {
            int k = -1;
            for (int j = i - 1; j >= 0; --j) {
                if (path.charAt(j) != '/') continue;
                k = j;
                break;
            }
            if (k < 0) break;
            path = path.substring(0, k + 1) + path.substring(i + pattern.length());
        }
        pattern = PATTERN_4;
        if (path.endsWith(pattern)) {
            int k = -1;
            for (int j = path.length() - pattern.length() - 1; j >= 0; --j) {
                if (path.charAt(j) != '/') continue;
                k = j;
                break;
            }
            if (k > 0) {
                path = path.substring(0, k);
            }
        }
        return path;
    }

    public Item[] getAllSources() {
        return this.makeConfigurationDescriptor.getProjectItems();
    }

    public Folder getRoot() {
        Folder folder = this.makeConfigurationDescriptor.getLogicalFolders();
        List sources = folder.getFolders();
        for (Folder sub : sources) {
            if (!sub.isProjectFiles() || !"SourceFiles".equals(sub.getName())) continue;
            return sub;
        }
        return folder;
    }

    public Map<String, Folder> prefferedFolders() {
        String folder;
        HashMap<String, Folder> folders = new HashMap<String, Folder>();
        for (Item item : this.getAllSources()) {
            int i;
            String path = item.getAbsPath();
            if (Utilities.isWindows()) {
                path = path.replace('\\', '/');
            }
            if (path.contains(PATTERN_3) || path.contains(PATTERN_1)) {
                path = CndFileUtils.normalizeAbsolutePath((FileSystem)this.baseFolderFileSystem, (String)path);
                if (Utilities.isWindows()) {
                    path = path.replace('\\', '/');
                }
            }
            if ((i = path.lastIndexOf(47)) < 0) continue;
            folder = path.substring(0, i);
            folders.put(folder, item.getFolder());
        }
        Folder root = this.makeConfigurationDescriptor.getLogicalFolders();
        HashSet<Folder> roots = new HashSet<Folder>(root.getFolders());
        roots.add(root);
        while (true) {
            HashMap<String, Folder> delta = new HashMap<String, Folder>();
            for (Map.Entry entry : folders.entrySet()) {
                String needCheck;
                String pathName;
                String path = (String)entry.getKey();
                folder = (Folder)entry.getValue();
                Folder parent = folder.getParent();
                if (parent == null || roots.contains(parent)) continue;
                String name = folder.getName();
                int i = path.lastIndexOf(47);
                if (i < 0 || !name.equals(pathName = path.substring(i + 1)) || folders.containsKey(needCheck = path.substring(0, i))) continue;
                delta.put(needCheck, parent);
            }
            if (delta.isEmpty()) break;
            folders.putAll(delta);
        }
        return folders;
    }

    public void save() {
        this.makeConfigurationDescriptor.save();
    }

    public Set<Project> getResult() {
        if (this.startedModification) {
            ConfigurationDescriptorProvider pdp = (ConfigurationDescriptorProvider)this.project.getLookup().lookup(ConfigurationDescriptorProvider.class);
            pdp.endModifications(this.delta, this.startedModification, ImportProject.logger);
        } else {
            this.makeConfigurationDescriptor.checkForChangedItems(this.project, null, null);
        }
        return this.resultSet;
    }

    public void printStaticstic(Folder sourceRoot, Logger logger) {
        if (logger.isLoggable(Level.INFO)) {
            int all = 0;
            int c = 0;
            int c_excluded = 0;
            int cpp = 0;
            int cpp_excluded = 0;
            int header = 0;
            int header_excluded = 0;
            block5: for (Item item : sourceRoot.getAllItemsAsArray()) {
                ++all;
                MakeConfiguration makeConfiguration = item.getFolder().getConfigurationDescriptor().getActiveConfiguration();
                ItemConfiguration itemConfiguration = item.getItemConfiguration((Configuration)makeConfiguration);
                if (itemConfiguration == null) continue;
                boolean excluded = itemConfiguration.getExcluded().getValue();
                switch (itemConfiguration.getTool()) {
                    case CCCompiler: {
                        if (excluded) {
                            ++cpp_excluded;
                            continue block5;
                        }
                        ++cpp;
                        continue block5;
                    }
                    case CCompiler: {
                        if (excluded) {
                            ++c_excluded;
                            continue block5;
                        }
                        ++c;
                        continue block5;
                    }
                    case CustomTool: {
                        if (excluded) {
                            ++header_excluded;
                            continue block5;
                        }
                        ++header;
                    }
                }
            }
            logger.log(Level.INFO, "Project {0} configuration has:\n\tC files {1} + excluded {2}\n\tC++ files {3} + excluded {4}\n\tHeader files {5} + excluded {6}\n\tAll items {7}", new Object[]{this.project, c, c_excluded, cpp, cpp_excluded, header, header_excluded, all});
        }
    }

    public void setupProject(List<String> includes, List<String> files, List<String> macros, List<String> undefs, ItemProperties.LanguageKind lang) {
        MakeConfiguration extConf = this.makeConfigurationDescriptor.getActiveConfiguration();
        if (extConf != null) {
            int i;
            for (i = 0; i < includes.size(); ++i) {
                includes.set(i, this.getString(includes.get(i)));
            }
            for (i = 0; i < macros.size(); ++i) {
                macros.set(i, this.getString(macros.get(i)));
            }
            if (lang == ItemProperties.LanguageKind.CPP) {
                extConf.getCCCompilerConfiguration().getIncludeDirectories().setValue(includes);
                extConf.getCCCompilerConfiguration().getIncludeFiles().setValue(files);
                extConf.getCCCompilerConfiguration().getPreprocessorConfiguration().setValue(macros);
                extConf.getCCCompilerConfiguration().getUndefinedPreprocessorConfiguration().setValue(undefs);
                extConf.getCCCompilerConfiguration().getIncludeDirectories().setDirty(true);
                extConf.getCCCompilerConfiguration().getIncludeFiles().setDirty(true);
                extConf.getCCCompilerConfiguration().getPreprocessorConfiguration().setDirty(true);
                extConf.getCCCompilerConfiguration().getUndefinedPreprocessorConfiguration().setDirty(true);
            } else if (lang == ItemProperties.LanguageKind.C) {
                extConf.getCCompilerConfiguration().getIncludeDirectories().setValue(includes);
                extConf.getCCompilerConfiguration().getIncludeFiles().setValue(files);
                extConf.getCCompilerConfiguration().getPreprocessorConfiguration().setValue(macros);
                extConf.getCCompilerConfiguration().getUndefinedPreprocessorConfiguration().setValue(undefs);
                extConf.getCCompilerConfiguration().getIncludeDirectories().setDirty(true);
                extConf.getCCompilerConfiguration().getIncludeFiles().setDirty(true);
                extConf.getCCompilerConfiguration().getPreprocessorConfiguration().setDirty(true);
                extConf.getCCompilerConfiguration().getUndefinedPreprocessorConfiguration().setDirty(true);
            } else if (lang == ItemProperties.LanguageKind.Fortran) {
                // empty if block
            }
        }
        this.makeConfigurationDescriptor.setModified();
    }

    public FolderConfiguration getFolderConfiguration(Folder folder) {
        MakeConfiguration makeConfiguration = folder.getConfigurationDescriptor().getActiveConfiguration();
        return folder.getFolderConfiguration((Configuration)makeConfiguration);
    }

    public CCCCompilerConfiguration getFolderConfiguration(ItemProperties.LanguageKind lang, Folder folder) {
        FolderConfiguration folderConfiguration = this.getFolderConfiguration(folder);
        if (folderConfiguration == null) {
            return null;
        }
        if (lang == ItemProperties.LanguageKind.CPP) {
            return folderConfiguration.getCCCompilerConfiguration();
        }
        if (lang == ItemProperties.LanguageKind.C) {
            return folderConfiguration.getCCompilerConfiguration();
        }
        return null;
    }

    public void setupFolder(List<String> includes, boolean inheriteIncludes, List<String> files, boolean inheriteFiles, List<String> macros, boolean inheriteMacros, List<String> undefs, boolean inheriteUndefs, ItemProperties.LanguageKind lang, Folder folder) {
        int i;
        CCCCompilerConfiguration cccc = this.getFolderConfiguration(lang, folder);
        if (cccc == null) {
            return;
        }
        for (i = 0; i < includes.size(); ++i) {
            includes.set(i, this.getString(includes.get(i)));
        }
        for (i = 0; i < macros.size(); ++i) {
            macros.set(i, this.getString(macros.get(i)));
        }
        cccc.getIncludeDirectories().setValue(includes);
        cccc.getInheritIncludes().setValue(inheriteIncludes);
        cccc.getIncludeFiles().setValue(files);
        cccc.getInheritFiles().setValue(inheriteFiles);
        cccc.getPreprocessorConfiguration().setValue(macros);
        cccc.getInheritPreprocessor().setValue(inheriteMacros);
        cccc.getUndefinedPreprocessorConfiguration().setValue(undefs);
        cccc.getInheritUndefinedPreprocessor().setValue(inheriteUndefs);
    }

    public static boolean setExclude(Item item, boolean exclude) {
        ItemConfiguration itemConfiguration = ProjectBridge.getOrCreateItemConfiguration(item);
        if (itemConfiguration == null) {
            return false;
        }
        BooleanConfiguration excl = itemConfiguration.getExcluded();
        if (excl.getValue() ^ exclude) {
            excl.setValue(exclude);
            return true;
        }
        return false;
    }

    public static boolean getExclude(Item item) {
        ItemConfiguration itemConfiguration = ProjectBridge.getOrCreateItemConfiguration(item);
        if (itemConfiguration == null) {
            return true;
        }
        return itemConfiguration.getExcluded().getValue();
    }

    public static boolean setHeaderTool(Item item) {
        ItemConfiguration itemConfiguration = ProjectBridge.getOrCreateItemConfiguration(item);
        if (itemConfiguration == null) {
            return false;
        }
        if (itemConfiguration.getTool() == PredefinedToolKind.CCCompiler || itemConfiguration.getTool() == PredefinedToolKind.CCompiler) {
            itemConfiguration.setTool(PredefinedToolKind.CustomTool);
            return true;
        }
        return false;
    }

    private static ItemConfiguration getOrCreateItemConfiguration(Item item) {
        MakeConfiguration makeConfiguration = item.getFolder().getConfigurationDescriptor().getActiveConfiguration();
        ItemConfiguration itemConfiguration = item.getItemConfiguration((Configuration)makeConfiguration);
        if (itemConfiguration == null) {
            String mimeType = item.getMIMEType();
            if ("text/x-c++".equals(mimeType)) {
                itemConfiguration = new ItemConfiguration((Configuration)makeConfiguration, item);
                itemConfiguration.setTool(PredefinedToolKind.CCCompiler);
                makeConfiguration.addAuxObject((ConfigurationAuxObject)itemConfiguration);
            } else if ("text/x-c".equals(mimeType)) {
                itemConfiguration = new ItemConfiguration((Configuration)makeConfiguration, item);
                itemConfiguration.setTool(PredefinedToolKind.CCompiler);
                makeConfiguration.addAuxObject((ConfigurationAuxObject)itemConfiguration);
            } else if ("text/x-fortran".equals(mimeType)) {
                itemConfiguration = new ItemConfiguration((Configuration)makeConfiguration, item);
                itemConfiguration.setTool(PredefinedToolKind.FortranCompiler);
                makeConfiguration.addAuxObject((ConfigurationAuxObject)itemConfiguration);
            } else if ("text/x-h".equals(mimeType)) {
                itemConfiguration = new ItemConfiguration((Configuration)makeConfiguration, item);
                itemConfiguration.setTool(PredefinedToolKind.CustomTool);
                makeConfiguration.addAuxObject((ConfigurationAuxObject)itemConfiguration);
            }
        }
        return itemConfiguration;
    }

    public static boolean setSourceTool(Item item, ItemProperties.LanguageKind lang, ItemProperties.LanguageStandard languageStandard, boolean isIncrementalMode) {
        ItemConfiguration itemConfiguration = ProjectBridge.getOrCreateItemConfiguration(item);
        if (itemConfiguration == null) {
            return false;
        }
        boolean isChanged = false;
        switch (lang) {
            case C: {
                if (itemConfiguration.getTool() == PredefinedToolKind.CCompiler) break;
                itemConfiguration.setTool(PredefinedToolKind.CCompiler);
                isChanged = true;
                break;
            }
            case CPP: {
                if (itemConfiguration.getTool() == PredefinedToolKind.CCCompiler) break;
                itemConfiguration.setTool(PredefinedToolKind.CCCompiler);
                isChanged = true;
                break;
            }
            case Fortran: {
                if (itemConfiguration.getTool() == PredefinedToolKind.FortranCompiler) break;
                itemConfiguration.setTool(PredefinedToolKind.FortranCompiler);
                isChanged = true;
            }
        }
        return isChanged |= ProjectBridge.setSourceStandard(item, languageStandard, isIncrementalMode);
    }

    public static boolean setSourceStandard(Item item, ItemProperties.LanguageStandard languageStandard, boolean isIncrementalMode) {
        if (languageStandard == null) {
            return false;
        }
        ItemConfiguration itemConfiguration = ProjectBridge.getOrCreateItemConfiguration(item);
        if (itemConfiguration == null) {
            return false;
        }
        boolean isChanged = false;
        if (itemConfiguration.getTool() == PredefinedToolKind.CCompiler) {
            switch (languageStandard) {
                case C: {
                    if (itemConfiguration.getLanguageFlavor() == NativeFileItem.LanguageFlavor.C) break;
                    itemConfiguration.setLanguageFlavor(NativeFileItem.LanguageFlavor.C);
                    isChanged = true;
                    break;
                }
                case C89: {
                    if (itemConfiguration.getLanguageFlavor() == NativeFileItem.LanguageFlavor.C89) break;
                    itemConfiguration.setLanguageFlavor(NativeFileItem.LanguageFlavor.C89);
                    isChanged = true;
                    break;
                }
                case C99: {
                    if (itemConfiguration.getLanguageFlavor() == NativeFileItem.LanguageFlavor.C99) break;
                    itemConfiguration.setLanguageFlavor(NativeFileItem.LanguageFlavor.C99);
                    isChanged = true;
                    break;
                }
                case C11: {
                    if (itemConfiguration.getLanguageFlavor() == NativeFileItem.LanguageFlavor.C11) break;
                    itemConfiguration.setLanguageFlavor(NativeFileItem.LanguageFlavor.C11);
                    isChanged = true;
                    break;
                }
                case Unknown: {
                    if (isIncrementalMode || itemConfiguration.getLanguageFlavor() == NativeFileItem.LanguageFlavor.UNKNOWN) break;
                    itemConfiguration.setLanguageFlavor(NativeFileItem.LanguageFlavor.UNKNOWN);
                    isChanged = true;
                    break;
                }
                case Default: {
                    if (itemConfiguration.getLanguageFlavor() == NativeFileItem.LanguageFlavor.DEFAULT) break;
                    itemConfiguration.setLanguageFlavor(NativeFileItem.LanguageFlavor.DEFAULT);
                    isChanged = true;
                }
            }
        } else if (itemConfiguration.getTool() == PredefinedToolKind.CCCompiler) {
            switch (languageStandard) {
                case CPP: {
                    if (itemConfiguration.getLanguageFlavor() == NativeFileItem.LanguageFlavor.CPP) break;
                    itemConfiguration.setLanguageFlavor(NativeFileItem.LanguageFlavor.CPP);
                    isChanged = true;
                    break;
                }
                case CPP11: {
                    if (itemConfiguration.getLanguageFlavor() == NativeFileItem.LanguageFlavor.CPP11) break;
                    itemConfiguration.setLanguageFlavor(NativeFileItem.LanguageFlavor.CPP11);
                    isChanged = true;
                    break;
                }
                case CPP14: {
                    if (itemConfiguration.getLanguageFlavor() == NativeFileItem.LanguageFlavor.CPP14) break;
                    itemConfiguration.setLanguageFlavor(NativeFileItem.LanguageFlavor.CPP14);
                    isChanged = true;
                    break;
                }
                case Unknown: {
                    if (isIncrementalMode || itemConfiguration.getLanguageFlavor() == NativeFileItem.LanguageFlavor.UNKNOWN) break;
                    itemConfiguration.setLanguageFlavor(NativeFileItem.LanguageFlavor.UNKNOWN);
                    isChanged = true;
                    break;
                }
                case Default: {
                    if (itemConfiguration.getLanguageFlavor() == NativeFileItem.LanguageFlavor.DEFAULT) break;
                    itemConfiguration.setLanguageFlavor(NativeFileItem.LanguageFlavor.DEFAULT);
                    isChanged = true;
                }
            }
        } else if (itemConfiguration.getTool() == PredefinedToolKind.FortranCompiler) {
            switch (languageStandard) {
                case F77: {
                    if (itemConfiguration.getLanguageFlavor() == NativeFileItem.LanguageFlavor.F77) break;
                    itemConfiguration.setLanguageFlavor(NativeFileItem.LanguageFlavor.F77);
                    isChanged = true;
                    break;
                }
                case F90: {
                    if (itemConfiguration.getLanguageFlavor() == NativeFileItem.LanguageFlavor.F90) break;
                    itemConfiguration.setLanguageFlavor(NativeFileItem.LanguageFlavor.F90);
                    isChanged = true;
                    break;
                }
                case F95: {
                    if (itemConfiguration.getLanguageFlavor() == NativeFileItem.LanguageFlavor.F95) break;
                    itemConfiguration.setLanguageFlavor(NativeFileItem.LanguageFlavor.F95);
                    isChanged = true;
                }
            }
        }
        return isChanged;
    }

    public CCCCompilerConfiguration getItemConfiguration(Item item) {
        ItemConfiguration itemConfiguration = ProjectBridge.getOrCreateItemConfiguration(item);
        if (itemConfiguration == null || !itemConfiguration.isCompilerToolConfiguration()) {
            return null;
        }
        BasicCompilerConfiguration compilerConfiguration = itemConfiguration.getCompilerConfiguration();
        if (compilerConfiguration instanceof CCCCompilerConfiguration) {
            return (CCCCompilerConfiguration)compilerConfiguration;
        }
        return null;
    }

    public void setupFile(String compilepath, List<String> includes, boolean inheriteIncludes, List<String> files, boolean inheriteFiles, List<String> macros, boolean inheriteMacros, List<String> undefs, boolean inheriteUndefs, Item item, String importantFlags) {
        int i;
        ItemConfiguration itemConfiguration = ProjectBridge.getOrCreateItemConfiguration(item);
        if (itemConfiguration == null || !itemConfiguration.isCompilerToolConfiguration()) {
            return;
        }
        BooleanConfiguration excl = itemConfiguration.getExcluded();
        if (excl.getValue()) {
            excl.setValue(false);
        }
        for (i = 0; i < includes.size(); ++i) {
            includes.set(i, this.getString(includes.get(i)));
        }
        for (i = 0; i < macros.size(); ++i) {
            macros.set(i, this.getString(macros.get(i)));
        }
        BasicCompilerConfiguration compilerConfiguration = itemConfiguration.getCompilerConfiguration();
        if (compilerConfiguration instanceof CCCCompilerConfiguration) {
            CCCCompilerConfiguration cccCompilerConfiguration = (CCCCompilerConfiguration)compilerConfiguration;
            cccCompilerConfiguration.getIncludeDirectories().setValue(includes);
            cccCompilerConfiguration.getInheritIncludes().setValue(inheriteIncludes);
            cccCompilerConfiguration.getIncludeFiles().setValue(files);
            cccCompilerConfiguration.getInheritFiles().setValue(inheriteFiles);
            cccCompilerConfiguration.getPreprocessorConfiguration().setValue(macros);
            cccCompilerConfiguration.getInheritPreprocessor().setValue(inheriteMacros);
            cccCompilerConfiguration.getUndefinedPreprocessorConfiguration().setValue(undefs);
            cccCompilerConfiguration.getInheritUndefinedPreprocessor().setValue(inheriteUndefs);
            cccCompilerConfiguration.getImportantFlags().setValue(this.getString(importantFlags));
        }
    }

    public static boolean fixFileMacros(Map<String, String> macros, Item item) {
        ItemConfiguration itemConfiguration = ProjectBridge.getOrCreateItemConfiguration(item);
        if (itemConfiguration == null || !itemConfiguration.isCompilerToolConfiguration()) {
            return false;
        }
        boolean isChanged = false;
        BasicCompilerConfiguration compilerConfiguration = itemConfiguration.getCompilerConfiguration();
        if (compilerConfiguration instanceof CCCCompilerConfiguration) {
            HashSet set = new HashSet(item.getUserMacroDefinitions());
            CCCCompilerConfiguration cccCompilerConfiguration = (CCCCompilerConfiguration)compilerConfiguration;
            ArrayList<String> list = new ArrayList<String>(cccCompilerConfiguration.getPreprocessorConfiguration().getValue());
            for (Map.Entry<String, String> entry : macros.entrySet()) {
                String s = entry.getValue() != null ? entry.getKey() + "=" + entry.getValue() : entry.getKey();
                boolean find = set.contains(s);
                if (!(find || entry.getValue() != null && !"".equals(entry.getValue()) || (find = set.contains(s + "=1")))) {
                    find = set.contains(s + "=");
                }
                if (!find && ("1".equals(entry.getValue()) || "".equals(entry.getValue()))) {
                    find = set.contains(entry.getKey());
                }
                if (find) continue;
                isChanged = true;
                list.add(s);
            }
            if (isChanged) {
                cccCompilerConfiguration.getPreprocessorConfiguration().setValue(list);
            }
        }
        return isChanged;
    }

    private String getString(String s) {
        String res = this.cache.get(s);
        if (res == null) {
            this.cache.put(s, s);
            return s;
        }
        return res;
    }

    public void dispose() {
        this.cache.clear();
    }

    public CompilerSet getCompilerSet() {
        MakeConfiguration makeConfiguration = this.makeConfigurationDescriptor.getActiveConfiguration();
        return makeConfiguration.getCompilerSet().getCompilerSet();
    }

    public ExecutionEnvironment getDevelopmentHostExecutionEnvironment() {
        MakeConfiguration makeConfiguration = this.makeConfigurationDescriptor.getActiveConfiguration();
        return makeConfiguration.getDevelopmentHost().getExecutionEnvironment();
    }

    public String getCygwinDrive() {
        String res = CompilerSetUtils.getCygwinBase();
        if (res != null && res.endsWith("/")) {
            res = res.substring(0, res.length() - 1);
        }
        return res;
    }

    public CompilerFlavor getCompilerFlavor() {
        CompilerSet compilerSet = this.getCompilerSet();
        if (compilerSet != null) {
            return compilerSet.getCompilerFlavor();
        }
        return null;
    }

    public String getCompilerDirectory() {
        CompilerSet compilerSet = this.getCompilerSet();
        if (compilerSet != null) {
            return this.getCompilerSet().getDirectory();
        }
        return null;
    }

    public List<String> getSystemIncludePaths(boolean isCPP) {
        List<String> systemIncludePaths = isCPP ? this.systemIncludePathsCpp : this.systemIncludePathsC;
        if (systemIncludePaths == null) {
            AbstractCompiler compiler;
            systemIncludePaths = new ArrayList<String>();
            CompilerSet compilerSet = this.getCompilerSet();
            if (compilerSet != null && (compiler = isCPP ? (AbstractCompiler)compilerSet.getTool((ToolKind)PredefinedToolKind.CCCompiler) : (AbstractCompiler)compilerSet.getTool((ToolKind)PredefinedToolKind.CCompiler)) != null) {
                for (String path : compiler.getSystemIncludeDirectories()) {
                    systemIncludePaths.add(this.fixWindowsPath(path));
                }
            }
            if (isCPP) {
                this.systemIncludePathsCpp = systemIncludePaths;
            } else {
                this.systemIncludePathsC = systemIncludePaths;
            }
        }
        return systemIncludePaths;
    }

    private String fixWindowsPath(String path) {
        int i;
        if (Utilities.isWindows() && (i = (path = path.replace('\\', '/')).indexOf(CYG_DRIVE_UNIX)) >= 0 && path.length() > i + CYG_DRIVE_UNIX.length() + 1) {
            path = Character.toUpperCase(path.charAt(i + CYG_DRIVE_UNIX.length())) + ":" + path.substring(i + CYG_DRIVE_UNIX.length() + 1);
        }
        return path;
    }

    public Map<String, String> getSystemMacroDefinitions(boolean isCPP) {
        Map<String, String> systemMacroDefinitions = isCPP ? this.systemMacroDefinitionsCpp : this.systemMacroDefinitionsC;
        if (systemMacroDefinitions == null) {
            AbstractCompiler compiler;
            systemMacroDefinitions = new HashMap<String, String>();
            CompilerSet compilerSet = this.getCompilerSet();
            if (compilerSet != null && (compiler = isCPP ? (AbstractCompiler)compilerSet.getTool((ToolKind)PredefinedToolKind.CCCompiler) : (AbstractCompiler)compilerSet.getTool((ToolKind)PredefinedToolKind.CCompiler)) != null) {
                for (Object o : compiler.getSystemPreprocessorSymbols()) {
                    String macro = (String)o;
                    int i = macro.indexOf(61);
                    if (i > 0) {
                        systemMacroDefinitions.put(macro.substring(0, i), macro.substring(i + 1).trim());
                        continue;
                    }
                    systemMacroDefinitions.put(macro, null);
                }
            }
            if (isCPP) {
                this.systemMacroDefinitionsCpp = systemMacroDefinitions;
            } else {
                this.systemMacroDefinitionsC = systemMacroDefinitions;
            }
        }
        return systemMacroDefinitions;
    }
}

