/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.cli.jgit.commands;

import java.util.LinkedHashMap;
import org.netbeans.modules.git.remote.cli.GitBranch;
import org.netbeans.modules.git.remote.cli.GitException;
import org.netbeans.modules.git.remote.cli.jgit.GitClassFactory;
import org.netbeans.modules.git.remote.cli.jgit.JGitRepository;
import org.netbeans.modules.git.remote.cli.jgit.commands.GitCommand;
import org.netbeans.modules.git.remote.cli.jgit.commands.ListBranchCommand;
import org.netbeans.modules.git.remote.cli.progress.ProgressMonitor;
import org.netbeans.modules.remotefs.versioning.api.ProcessUtils;
import org.openide.util.Cancellable;

public class SetUpstreamBranchCommand
extends GitCommand {
    private final String localBranchName;
    private final String trackedBranchName;
    private GitBranch branch;
    private final ProgressMonitor monitor;

    public SetUpstreamBranchCommand(JGitRepository repository, GitClassFactory gitFactory, String localBranchName, String trackedBranch, ProgressMonitor monitor) {
        super(repository, gitFactory, monitor);
        this.localBranchName = localBranchName;
        this.trackedBranchName = trackedBranch;
        this.monitor = monitor;
    }

    public GitBranch getTrackingBranch() {
        return this.branch;
    }

    @Override
    protected void prepare() throws GitException {
        this.setCommandsNumber(2);
        super.prepare();
        this.addArgument(0, "branch");
        this.addArgument(0, "--set-upstream");
        this.addArgument(0, this.localBranchName);
        this.addArgument(0, this.trackedBranchName);
        this.addArgument(1, "branch");
        this.addArgument(1, "-v");
        this.addArgument(1, "-v");
        this.addArgument(1, "-a");
    }

    @Override
    protected void run() throws GitException {
        block4: {
            ProcessUtils.Canceler canceled = new ProcessUtils.Canceler();
            if (this.monitor != null) {
                this.monitor.setCancelDelegate((Cancellable)canceled);
            }
            try {
                new GitCommand.Runner(canceled, 0){

                    @Override
                    public void outputParser(String output) throws GitException {
                    }
                }.runCLI();
                final LinkedHashMap branches = new LinkedHashMap();
                new GitCommand.Runner(canceled, 1){

                    @Override
                    public void outputParser(String output) throws GitException {
                        ListBranchCommand.parseBranches(output, SetUpstreamBranchCommand.this.getClassFactory(), branches);
                    }
                }.runCLI();
                this.branch = (GitBranch)branches.get(this.localBranchName);
            }
            catch (GitException t) {
                throw t;
            }
            catch (Throwable t) {
                if (canceled.canceled()) break block4;
                throw new GitException(t);
            }
        }
    }
}

