/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.completion.completors;

import java.io.IOException;
import java.util.Enumeration;
import java.util.List;
import org.netbeans.modules.spring.beans.completion.CompletionContext;
import org.netbeans.modules.spring.beans.completion.Completor;
import org.netbeans.modules.spring.beans.completion.CompletorUtils;
import org.netbeans.modules.spring.beans.completion.SpringXMLConfigCompletionItem;
import org.openide.filesystems.FileObject;

public class ResourceCompletor
extends Completor {
    public ResourceCompletor(int invocationOffset) {
        super(invocationOffset);
    }

    @Override
    protected int initAnchorOffset(CompletionContext context) {
        int idx = context.getCurrentToken().getOffset() + 1;
        String typedChars = context.getTypedPrefix();
        int lastSlashIndex = typedChars.lastIndexOf("/");
        return idx + lastSlashIndex + 1;
    }

    @Override
    protected void compute(CompletionContext context) throws IOException {
        FileObject fileObject = context.getFileObject().getParent();
        String typedChars = context.getTypedPrefix();
        int lastSlashIndex = typedChars.lastIndexOf("/");
        String prefix = typedChars;
        if (lastSlashIndex != -1) {
            String pathStr = typedChars.substring(0, lastSlashIndex);
            fileObject = fileObject.getFileObject(pathStr);
            prefix = lastSlashIndex != typedChars.length() - 1 ? typedChars.substring(Math.min(typedChars.lastIndexOf("/") + 1, typedChars.length() - 1)) : "";
        }
        if (fileObject == null) {
            return;
        }
        if (prefix == null) {
            prefix = "";
        }
        Enumeration folders = fileObject.getFolders(false);
        while (folders.hasMoreElements()) {
            FileObject fo = (FileObject)folders.nextElement();
            if (!fo.getNameExt().startsWith(prefix)) continue;
            this.addCacheItem(SpringXMLConfigCompletionItem.createFolderItem(context.getCaretOffset() - prefix.length(), fo));
        }
        Enumeration files = fileObject.getData(false);
        while (files.hasMoreElements()) {
            FileObject fo = (FileObject)files.nextElement();
            if (!fo.getNameExt().startsWith(prefix) || !"text/x-springconfig+xml".equals(fo.getMIMEType())) continue;
            this.addCacheItem(SpringXMLConfigCompletionItem.createSpringXMLFileItem(context.getCaretOffset() - prefix.length(), fo));
        }
    }

    @Override
    public boolean canFilter(CompletionContext context) {
        return CompletorUtils.canFilter(context.getDocument(), this.getInvocationOffset(), context.getCaretOffset(), this.getAnchorOffset(), CompletorUtils.RESOURCE_PATH_ELEMENT_ACCEPTOR);
    }

    @Override
    protected List<SpringXMLConfigCompletionItem> doFilter(CompletionContext context) {
        return CompletorUtils.filter(this.getCacheItems(), context.getDocument(), this.getInvocationOffset(), context.getCaretOffset(), this.getAnchorOffset());
    }
}

