/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.transport.tcp.server.glassfish;

import com.sun.enterprise.webservice.EjbRuntimeEndpointInfo;
import com.sun.enterprise.webservice.JAXWSAdapterRegistry;
import com.sun.enterprise.webservice.WebServiceEjbEndpointRegistry;
import com.sun.istack.NotNull;
import com.sun.xml.ws.api.server.Adapter;
import com.sun.xml.ws.transport.tcp.resources.MessagesMessages;
import com.sun.xml.ws.transport.tcp.server.TCPAdapter;
import com.sun.xml.ws.transport.tcp.server.WSTCPAdapterRegistry;
import com.sun.xml.ws.transport.tcp.server.glassfish.ServletFakeArtifactSet;
import com.sun.xml.ws.transport.tcp.server.glassfish.TCP109Adapter;
import com.sun.xml.ws.transport.tcp.server.glassfish.WSEndpointDescriptor;
import com.sun.xml.ws.transport.tcp.util.WSTCPURI;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class WSTCPAdapterRegistryImpl
implements WSTCPAdapterRegistry {
    private static final Logger logger = Logger.getLogger("com.sun.metro.transport.tcp.server");
    final Map<String, RegistryRecord> registry = new ConcurrentHashMap<String, RegistryRecord>();
    private static final WSTCPAdapterRegistryImpl instance = new WSTCPAdapterRegistryImpl();

    private WSTCPAdapterRegistryImpl() {
    }

    @NotNull
    public static WSTCPAdapterRegistryImpl getInstance() {
        return instance;
    }

    public TCPAdapter getTarget(@NotNull WSTCPURI requestURI) {
        RegistryRecord record = requestURI.path.length() > 0 && !requestURI.path.equals("/") ? this.registry.get(requestURI.path) : this.registry.get("/");
        if (record != null) {
            if (record.adapter == null) {
                try {
                    record.adapter = this.createWSAdapter(requestURI.path, record.wsEndpointDescriptor);
                    logger.log(Level.FINE, "WSTCPAdapterRegistryImpl. Register adapter. Path: {0}", requestURI.path);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "WSTCPAdapterRegistryImpl. " + MessagesMessages.WSTCP_0008_ERROR_TCP_ADAPTER_CREATE(record.wsEndpointDescriptor.getWSServiceName()), e);
                }
            }
            return record.adapter;
        }
        return null;
    }

    public void registerEndpoint(@NotNull String path, @NotNull WSEndpointDescriptor wsEndpointDescriptor) {
        this.registry.put(path, new RegistryRecord(wsEndpointDescriptor));
    }

    public void deregisterEndpoint(@NotNull String path) {
        logger.log(Level.FINE, "WSTCPAdapterRegistryImpl. DeRegister adapter for {0}", path);
        this.registry.remove(path);
    }

    public WSEndpointDescriptor lookupEndpoint(@NotNull String path) {
        RegistryRecord record = this.registry.get(path);
        return record != null ? record.wsEndpointDescriptor : null;
    }

    private TCPAdapter createWSAdapter(@NotNull String wsPath, @NotNull WSEndpointDescriptor wsEndpointDescriptor) throws Exception {
        Adapter adapter;
        if (wsEndpointDescriptor.isEJB()) {
            EjbRuntimeEndpointInfo ejbEndPtInfo = WebServiceEjbEndpointRegistry.getRegistry().getEjbWebServiceEndpoint(wsEndpointDescriptor.getURI(), "POST", null);
            adapter = (Adapter)ejbEndPtInfo.prepareInvocation(true);
        } else {
            String uri = wsEndpointDescriptor.getURI();
            adapter = JAXWSAdapterRegistry.getInstance().getAdapter(wsEndpointDescriptor.getContextRoot(), uri, uri);
        }
        TCP109Adapter tcpAdapter = new TCP109Adapter(wsEndpointDescriptor.getWSServiceName().toString(), wsPath, adapter.getEndpoint(), new ServletFakeArtifactSet(wsEndpointDescriptor.getRequestURL(), wsEndpointDescriptor.getUrlPattern()), wsEndpointDescriptor.isEJB());
        return tcpAdapter;
    }

    protected static class RegistryRecord {
        public TCPAdapter adapter;
        public WSEndpointDescriptor wsEndpointDescriptor;

        public RegistryRecord(WSEndpointDescriptor wsEndpointDescriptor) {
            this.wsEndpointDescriptor = wsEndpointDescriptor;
        }
    }
}

