/*
 * Decompiled with CFR 0.152.
 */
package org.iso_relax.jaxp;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import org.iso_relax.verifier.Verifier;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class ValidatingDocumentBuilder
extends DocumentBuilder {
    protected DocumentBuilder _WrappedBuilder;
    protected Verifier _Verifier;

    protected ValidatingDocumentBuilder(DocumentBuilder documentBuilder, Verifier verifier) {
        this._WrappedBuilder = documentBuilder;
        this._Verifier = verifier;
    }

    public Document parse(InputSource inputSource) throws SAXException, IOException {
        return this.verify(this._WrappedBuilder.parse(inputSource));
    }

    public Document parse(File file) throws SAXException, IOException {
        return this.verify(this._WrappedBuilder.parse(file));
    }

    public Document parse(InputStream inputStream) throws SAXException, IOException {
        return this.verify(this._WrappedBuilder.parse(inputStream));
    }

    public Document parse(InputStream inputStream, String string2) throws SAXException, IOException {
        return this.verify(this._WrappedBuilder.parse(inputStream, string2));
    }

    public Document parse(String string2) throws SAXException, IOException {
        return this.verify(this._WrappedBuilder.parse(string2));
    }

    public boolean isNamespaceAware() {
        return this._WrappedBuilder.isNamespaceAware();
    }

    public boolean isValidating() {
        return true;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this._WrappedBuilder.setEntityResolver(entityResolver);
        this._Verifier.setEntityResolver(entityResolver);
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this._WrappedBuilder.setErrorHandler(errorHandler);
        this._Verifier.setErrorHandler(errorHandler);
    }

    public Document newDocument() {
        return this._WrappedBuilder.newDocument();
    }

    public DOMImplementation getDOMImplementation() {
        return this._WrappedBuilder.getDOMImplementation();
    }

    private Document verify(Document document) throws SAXException, IOException {
        if (this._Verifier.verify(document)) {
            return document;
        }
        throw new SAXException("the document is invalid, but the ErrorHandler does not throw any Exception.");
    }
}

