/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernateweb.framework;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.hibernate.cfg.model.SessionFactory;
import org.netbeans.modules.hibernate.loaders.cfg.HibernateCfgDataObject;
import org.netbeans.modules.hibernate.service.api.HibernateEnvironment;
import org.netbeans.modules.hibernateweb.framework.HibernateConfigurationPanel;
import org.netbeans.modules.hibernateweb.framework.Util;
import org.netbeans.modules.web.api.webmodule.ExtenderController;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.spi.webmodule.WebModuleExtender;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;

public class HibernateWebModuleExtender
extends WebModuleExtender {
    private HibernateConfigurationPanel configPanel = null;
    private static final String DEFAULT_CONFIG_FILENAME = "hibernate.cfg";
    private final String dialect = "hibernate.dialect";
    private final String driver = "hibernate.connection.driver_class";
    private final String url = "hibernate.connection.url";
    private final String userName = "hibernate.connection.username";
    private final String password = "hibernate.connection.password";
    private Logger logger = Logger.getLogger(HibernateWebModuleExtender.class.getName());
    private final Set listeners = new HashSet(1);

    public HibernateWebModuleExtender(boolean forNewProjectWizard, WebModule webModule, ExtenderController controller) {
        this.configPanel = new HibernateConfigurationPanel(this, controller, forNewProjectWizard);
        if (!forNewProjectWizard) {
            this.showConfigPanelForCustomizer(webModule);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChangeListener(ChangeListener l) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChangeListener(ChangeListener l) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void fireChangeEvent() {
        Iterator it;
        Set set = this.listeners;
        synchronized (set) {
            it = new HashSet(this.listeners).iterator();
        }
        ChangeEvent ev = new ChangeEvent((Object)this);
        while (it.hasNext()) {
            ((ChangeListener)it.next()).stateChanged(ev);
        }
    }

    public JComponent getComponent() {
        return this.configPanel;
    }

    public HelpCtx getHelp() {
        return null;
    }

    public void update() {
    }

    public boolean isValid() {
        return this.configPanel.isPanelValid();
    }

    public Set<FileObject> extend(WebModule webModule) {
        Project enclosingProject = Util.getEnclosingProjectFromWebModule(webModule);
        if (enclosingProject != null) {
            Sources sources = ProjectUtils.getSources((Project)enclosingProject);
            try {
                SourceGroup[] javaSourceGroup = sources.getSourceGroups("resources");
                if (javaSourceGroup == null || javaSourceGroup.length == 0) {
                    javaSourceGroup = sources.getSourceGroups("java");
                }
                if (javaSourceGroup != null && javaSourceGroup.length != 0) {
                    FileObject targetFolder = javaSourceGroup[0].getRootFolder();
                    CreateHibernateConfiguration createHibernateConfiguration = new CreateHibernateConfiguration(targetFolder, enclosingProject);
                    targetFolder.getFileSystem().runAtomicAction((FileSystem.AtomicAction)createHibernateConfiguration);
                    return createHibernateConfiguration.getCreatedFiles();
                }
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return Collections.EMPTY_SET;
    }

    private void showConfigPanelForCustomizer(WebModule webModule) {
        Project enclosingProject = Util.getEnclosingProjectFromWebModule(webModule);
        HibernateEnvironment he = (HibernateEnvironment)enclosingProject.getLookup().lookup(HibernateEnvironment.class);
        List configFileObjects = he.getAllHibernateConfigFileObjects();
        for (FileObject configFile : configFileObjects) {
            if (configFile.getName().equals(DEFAULT_CONFIG_FILENAME)) {
                try {
                    HibernateCfgDataObject hibernateDO = (HibernateCfgDataObject)DataObject.find((FileObject)configFile);
                    SessionFactory sessionFactory = hibernateDO.getHibernateConfiguration().getSessionFactory();
                    int index = 0;
                    for (String propValue : sessionFactory.getProperty2()) {
                        String propName;
                        if ("hibernate.dialect".contains(propName = sessionFactory.getAttributeValue("Property2", index++, "name"))) {
                            this.configPanel.setDialect(propValue);
                        }
                        if (!"hibernate.connection.url".contains(propName)) continue;
                        this.configPanel.setDatabaseConnection(propValue);
                    }
                }
                catch (DataObjectNotFoundException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            this.configPanel.disable();
        }
    }

    private class CreateHibernateConfiguration
    implements FileSystem.AtomicAction {
        private FileObject targetFolder;
        private Project enclosingProject;
        private Set<FileObject> createdFilesSet = new LinkedHashSet<FileObject>();

        public CreateHibernateConfiguration(FileObject targetFolder, Project enclosingProject) {
            this.targetFolder = targetFolder;
            this.enclosingProject = enclosingProject;
        }

        public Set<FileObject> getCreatedFiles() {
            return this.createdFilesSet;
        }

        public void run() throws IOException {
            DataFolder targetDataFolder = DataFolder.findFolder((FileObject)this.targetFolder);
            FileObject templateFileObject = FileUtil.getConfigFile((String)"Templates/Hibernate/Hibernate.cfg.xml");
            DataObject templateDataObject = DataObject.find((FileObject)templateFileObject);
            DataObject newOne = templateDataObject.createFromTemplate(targetDataFolder, HibernateWebModuleExtender.DEFAULT_CONFIG_FILENAME);
            SessionFactory sFactory = new SessionFactory();
            int row = 0;
            if (HibernateWebModuleExtender.this.configPanel.getSelectedDialect() != null && !"".equals(HibernateWebModuleExtender.this.configPanel.getSelectedDialect())) {
                row = sFactory.addProperty2(HibernateWebModuleExtender.this.configPanel.getSelectedDialect());
                sFactory.setAttributeValue("Property2", row, "name", "hibernate.dialect");
            }
            if (HibernateWebModuleExtender.this.configPanel.getSelectedDriver() != null && !"".equals(HibernateWebModuleExtender.this.configPanel.getSelectedDriver())) {
                row = sFactory.addProperty2(HibernateWebModuleExtender.this.configPanel.getSelectedDriver());
                sFactory.setAttributeValue("Property2", row, "name", "hibernate.connection.driver_class");
            }
            if (HibernateWebModuleExtender.this.configPanel.getSelectedURL() != null && !"".equals(HibernateWebModuleExtender.this.configPanel.getSelectedURL())) {
                row = sFactory.addProperty2(HibernateWebModuleExtender.this.configPanel.getSelectedURL());
                sFactory.setAttributeValue("Property2", row, "name", "hibernate.connection.url");
            }
            if (HibernateWebModuleExtender.this.configPanel.getUserName() != null && !"".equals(HibernateWebModuleExtender.this.configPanel.getUserName())) {
                row = sFactory.addProperty2(HibernateWebModuleExtender.this.configPanel.getUserName());
                sFactory.setAttributeValue("Property2", row, "name", "hibernate.connection.username");
            }
            if (HibernateWebModuleExtender.this.configPanel.getPassword() != null && !"".equals(HibernateWebModuleExtender.this.configPanel.getPassword())) {
                row = sFactory.addProperty2(HibernateWebModuleExtender.this.configPanel.getPassword());
                sFactory.setAttributeValue("Property2", row, "name", "hibernate.connection.password");
            }
            HibernateCfgDataObject hdo = (HibernateCfgDataObject)newOne;
            hdo.addSessionFactory(sFactory);
            hdo.save();
            HibernateEnvironment hibernateEnvironment = (HibernateEnvironment)this.enclosingProject.getLookup().lookup(HibernateEnvironment.class);
            HibernateWebModuleExtender.this.logger.info("Library registered : " + hibernateEnvironment.addHibernateLibraryToProject(hdo.getPrimaryFile()));
            String selectedDriver = HibernateWebModuleExtender.this.configPanel.getSelectedDriver();
            if (!hibernateEnvironment.canLoadDBDriver(hdo.getHibernateConfiguration()) && selectedDriver != null) {
                HibernateWebModuleExtender.this.logger.info("DB Driver not registered with the project. Registering now..");
                HibernateWebModuleExtender.this.logger.info("DB Driver registered : " + hibernateEnvironment.registerDBDriver(selectedDriver, hdo.getPrimaryFile()));
            }
            this.createdFilesSet.add(hdo.getPrimaryFile());
        }
    }
}

