/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer.editor;

import com.intellij.codeInsight.intention.IntentionActionWithOptions;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ClickListener;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.util.ObjectUtils;
import com.intellij.util.messages.MessageBusConnection;
import com.jetbrains.php.composer.actions.ComposerInstallAction;
import com.jetbrains.php.composer.actions.ComposerUpdateAction;
import com.jetbrains.php.composer.actions.log.ComposerLogService;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComposerEditorNotificationPanel
extends EditorNotificationPanel {
    private static final Object LOCK = new Object();
    private static final String PLACE = "ComposerEditorNotificationPanel";
    private static final Key<ComposerEditorNotificationPanel> PANEL_KEY = Key.create((String)"ComposerEditorPanel");

    public ComposerEditorNotificationPanel(@NotNull Project project, @NotNull VirtualFile composerJson) {
        if (project == null) {
            ComposerEditorNotificationPanel.$$$reportNull$$$0(0);
        }
        if (composerJson == null) {
            ComposerEditorNotificationPanel.$$$reportNull$$$0(1);
        }
        this.setText("This configuration file contains list of Composer dependencies");
        this.createActionLabel("Install", () -> {
            if (project == null) {
                ComposerEditorNotificationPanel.$$$reportNull$$$0(10);
            }
            if (composerJson == null) {
                ComposerEditorNotificationPanel.$$$reportNull$$$0(11);
            }
            AnAction action = ActionManager.getInstance().getAction("ComposerInstallAction");
            ((ComposerInstallAction)action).act(project, composerJson, PLACE);
        }).setToolTipText("Installs packages from composer.json, taking account of composer.lock");
        this.createActionLabel("Update", () -> {
            if (project == null) {
                ComposerEditorNotificationPanel.$$$reportNull$$$0(8);
            }
            if (composerJson == null) {
                ComposerEditorNotificationPanel.$$$reportNull$$$0(9);
            }
            AnAction action = ActionManager.getInstance().getAction("ComposerUpdateAction");
            ((ComposerUpdateAction)action).act(project, composerJson, PLACE);
        }).setToolTipText("Installs latest appropriate versions of packages from composer.json");
        HyperlinkLabel logLabel = this.createActionLabel("Show Log", () -> {
            if (project == null) {
                ComposerEditorNotificationPanel.$$$reportNull$$$0(7);
            }
            ComposerLogService.getInstance(project).getConsoleView().show(null);
        });
        logLabel.setToolTipText("Show log of Composer-related actions");
        final JLabel moreActionsLabel = new JLabel();
        this.myLinksPanel.add(moreActionsLabel);
        moreActionsLabel.setIcon(AllIcons.General.GearPlain);
        moreActionsLabel.setToolTipText("More actions...");
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                ActionManager manager = ActionManager.getInstance();
                DefaultActionGroup actionGroup = new DefaultActionGroup(new AnAction[]{manager.getAction("ComposerAddDependencyAction"), manager.getAction("ComposerValidateAction"), manager.getAction("ComposerDumpAutoloadAction"), manager.getAction("ComposerStatusAction"), manager.getAction("ComposerClearCacheAction"), manager.getAction("ComposerLicensesAction"), manager.getAction("ComposerDiagnoseAction"), manager.getAction("ComposerSelfUpdateAction")});
                String actionPlace = "ComposerEditorNotificationPanel.ExtraActions";
                ActionPopupMenu popupMenu = manager.createActionPopupMenu(actionPlace, (ActionGroup)actionGroup);
                popupMenu.getComponent().show(moreActionsLabel, 0, ((JLabel)ObjectUtils.assertNotNull((Object)moreActionsLabel)).getHeight());
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/composer/editor/ComposerEditorNotificationPanel$1", "onClick"));
            }
        }.installOn((Component)moreActionsLabel);
    }

    public static void init(final @NotNull Project project) {
        if (project == null) {
            ComposerEditorNotificationPanel.$$$reportNull$$$0(2);
        }
        MessageBusConnection connection = project.getMessageBus().connect();
        connection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener(){

            public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
                if (source == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (file == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (!"composer.json".equals(file.getName()) || !file.isInLocalFileSystem()) {
                    return;
                }
                ComposerEditorNotificationPanel.setUpEditorPanels(file, project);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "source";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "file";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/php/composer/editor/ComposerEditorNotificationPanel$2";
                objectArray[2] = "fileOpened";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static void setUpEditorPanels(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            ComposerEditorNotificationPanel.$$$reportNull$$$0(3);
        }
        if (project == null) {
            ComposerEditorNotificationPanel.$$$reportNull$$$0(4);
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (project == null) {
                ComposerEditorNotificationPanel.$$$reportNull$$$0(5);
            }
            if (file == null) {
                ComposerEditorNotificationPanel.$$$reportNull$$$0(6);
            }
            FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
            Object object = LOCK;
            synchronized (object) {
                for (FileEditor editor : fileEditorManager.getAllEditors(file)) {
                    ComposerEditorNotificationPanel oldPanel = (ComposerEditorNotificationPanel)((Object)((Object)editor.getUserData(PANEL_KEY)));
                    if (oldPanel != null) continue;
                    ComposerEditorNotificationPanel panel = new ComposerEditorNotificationPanel(project, file);
                    fileEditorManager.addTopComponent(editor, (JComponent)((Object)panel));
                    editor.putUserData(PANEL_KEY, (Object)panel);
                }
            }
        });
    }

    public Color getBackground() {
        return EditorNotificationPanel.getToolbarBackground();
    }

    @Nullable
    public IntentionActionWithOptions getIntentionAction() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "composerJson";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/composer/editor/ComposerEditorNotificationPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "init";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "setUpEditorPanels";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$setUpEditorPanels$3";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$new$2";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$new$1";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$new$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

