/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.intentions;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.Else;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.If;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReturn;
import com.jetbrains.php.lang.psi.elements.SelfAssignmentExpression;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.TernaryExpression;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpReplaceIfWithTernaryIntention
extends PsiElementBaseIntentionAction {
    public static final String TEXT = PhpBundle.message("intention.replace.if.with.ternaryExpression", new Object[0]);
    public IfStatementProcessor[] branchProcessors = new IfStatementProcessor[]{new AssignmentStatementProcessor(), new ReturnStatementProcessor()};

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        Else elseBranch;
        If ifClause;
        if (project == null) {
            PhpReplaceIfWithTernaryIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            PhpReplaceIfWithTernaryIntention.$$$reportNull$$$0(1);
        }
        if ((ifClause = (If)PhpPsiUtil.getParentByCondition(element, (Condition<? super PsiElement>)If.INSTANCEOF)) != null && (elseBranch = ifClause.getElseBranch()) != null) {
            Statement ifStatement = PhpReplaceIfWithTernaryIntention.getTheFirstStatementFromBranch((PsiElement)ifClause);
            Statement elseStatement = PhpReplaceIfWithTernaryIntention.getTheFirstStatementFromBranch((PsiElement)elseBranch);
            PhpPsiElement condition = ifClause.getCondition();
            if (condition != null && ifStatement != null && elseStatement != null) {
                for (IfStatementProcessor it : this.branchProcessors) {
                    Statement toReplace = it.tryToBuildTernary((PsiElement)condition, ifStatement, elseStatement);
                    if (toReplace == null) continue;
                    ifClause.replace((PsiElement)toReplace);
                }
            }
        }
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        Else elseBranch;
        if (project == null) {
            PhpReplaceIfWithTernaryIntention.$$$reportNull$$$0(2);
        }
        if (element == null) {
            PhpReplaceIfWithTernaryIntention.$$$reportNull$$$0(3);
        }
        if (!PhpWorkaroundUtil.isIntentionAvailable(element)) {
            return false;
        }
        If ifClause = (If)PhpPsiUtil.getParentByCondition(element, (Condition<? super PsiElement>)If.INSTANCEOF);
        if (ifClause != null && ifClause.getElseIfBranches().length == 0 && (elseBranch = ifClause.getElseBranch()) != null) {
            Statement ifStatement = PhpReplaceIfWithTernaryIntention.getTheFirstStatementFromBranch((PsiElement)ifClause);
            Statement elseStatement = PhpReplaceIfWithTernaryIntention.getTheFirstStatementFromBranch((PsiElement)elseBranch);
            PhpPsiElement condition = ifClause.getCondition();
            if (condition != null && ifStatement != null && elseStatement != null) {
                for (IfStatementProcessor it : this.branchProcessors) {
                    if (!it.isAvailable(ifStatement, elseStatement)) continue;
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    @Nullable
    private static Statement getTheFirstStatementFromBranch(@NotNull PsiElement branch) {
        if (branch == null) {
            PhpReplaceIfWithTernaryIntention.$$$reportNull$$$0(4);
        }
        GroupStatement branchGroupStatement = (GroupStatement)PhpPsiUtil.getChildByCondition(branch, (Condition<? super PsiElement>)GroupStatement.INSTANCEOF);
        Statement singleStatement = null;
        List statements = PhpPsiUtil.getChildren((PsiElement)branchGroupStatement, (Condition<? super PsiElement>)((Condition)element -> !(element instanceof PsiWhiteSpace)));
        if (branchGroupStatement != null && statements.size() == 1) {
            PhpPsiElement temp = branchGroupStatement.getFirstPsiChild();
            if (temp instanceof Statement) {
                singleStatement = (Statement)temp;
            }
        } else {
            singleStatement = (Statement)PhpPsiUtil.getChildByCondition(branch, (Condition<? super PsiElement>)Statement.INSTANCEOF);
        }
        return singleStatement;
    }

    @NotNull
    public String getFamilyName() {
        if ("Replace if clause with ternary expression" == null) {
            PhpReplaceIfWithTernaryIntention.$$$reportNull$$$0(5);
        }
        return "Replace if clause with ternary expression";
    }

    @NotNull
    public String getText() {
        String string = TEXT;
        if (string == null) {
            PhpReplaceIfWithTernaryIntention.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static boolean assignmentsToTheSameVariable(@Nullable AssignmentExpression assignmentExpression1, @Nullable AssignmentExpression assignmentExpression2) {
        if (assignmentExpression1 != null && assignmentExpression2 != null) {
            PhpPsiElement thenVariable = assignmentExpression1.getVariable();
            PhpPsiElement elseVariable = assignmentExpression2.getVariable();
            if (thenVariable != null && elseVariable != null) {
                PsiReference thenReference = thenVariable.getReference();
                PsiReference elseReference = elseVariable.getReference();
                if (thenReference instanceof FieldReference && elseReference instanceof FieldReference) {
                    FieldReference thenFieldReference = (FieldReference)thenReference;
                    PhpExpression thenClassExpression = thenFieldReference.getClassReference();
                    FieldReference elseFieldReference = (FieldReference)elseReference;
                    PhpExpression elseClassExpression = elseFieldReference.getClassReference();
                    PsiElement resolvedThen = thenReference.resolve();
                    PsiElement resolvedElse = elseReference.resolve();
                    if (resolvedThen == null && resolvedElse == null && thenClassExpression != null && elseClassExpression != null) {
                        String thenClassExpressionName = thenClassExpression.getName();
                        CharSequence thenFieldReferenceNameCS = thenFieldReference.getNameCS();
                        return thenClassExpressionName != null && thenClassExpressionName.equals(elseClassExpression.getName()) && thenFieldReferenceNameCS != null && thenFieldReferenceNameCS.equals(elseFieldReference.getNameCS());
                    }
                    if (!PhpReplaceIfWithTernaryIntention.checkClassReference(thenClassExpression, elseClassExpression)) {
                        return false;
                    }
                }
                if (thenReference != null && elseReference != null) {
                    PsiElement resolvedThen = thenReference.resolve();
                    return resolvedThen != null && resolvedThen.equals(elseReference.resolve());
                }
            }
        }
        return false;
    }

    private static boolean checkClassReference(PhpExpression thenClassExpression, PhpExpression elseClassExpression) {
        if (thenClassExpression != null && elseClassExpression != null) {
            String thenName = thenClassExpression.getName();
            String elseClassExpressionName = elseClassExpression.getName();
            return thenName != null && thenName.equals(elseClassExpressionName);
        }
        return true;
    }

    private static String prepareExpressionText(@NotNull PsiElement element) {
        if (element == null) {
            PhpReplaceIfWithTernaryIntention.$$$reportNull$$$0(7);
        }
        String elementText = element.getText();
        if (element instanceof TernaryExpression) {
            return "(" + elementText + ")";
        }
        return elementText;
    }

    public static boolean isPassedByReference(PsiElement element) {
        ASTNode prevSiblingNode = element.getNode().getTreePrev();
        return prevSiblingNode != null && (prevSiblingNode.getElementType() == PhpTokenTypes.opBIT_AND || prevSiblingNode.getElementType() == PhpTokenTypes.opASGN && prevSiblingNode.getText().endsWith("&"));
    }

    private static String getPrefix(AssignmentExpression expression) {
        SelfAssignmentExpression selfAssignmentExpression;
        PsiElement operation;
        String operationText = "";
        if (expression instanceof SelfAssignmentExpression && (operation = (selfAssignmentExpression = (SelfAssignmentExpression)expression).getOperation()) != null) {
            operationText = operation.getText();
            if (!PhpPsiUtil.isOfType(operation, PhpTokenTypes.opASGN)) {
                operationText = operationText.replace("=", "");
                PhpPsiElement variable = expression.getVariable();
                if (variable != null) {
                    operationText = variable.getText() + operationText;
                }
            } else {
                operationText = "";
            }
        }
        return operationText;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branch";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/intentions/PhpReplaceIfWithTernaryIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/intentions/PhpReplaceIfWithTernaryIntention";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getTheFirstStatementFromBranch";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "prepareExpressionText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class AssignmentStatementProcessor
    implements IfStatementProcessor {
        AssignmentStatementProcessor() {
        }

        @Override
        public boolean isAvailable(Statement thenStatement, Statement elseStatement) {
            PhpPsiElement ifFirstPsiChild = thenStatement.getFirstPsiChild();
            PhpPsiElement elseFirstPsiChild = elseStatement.getFirstPsiChild();
            if (ifFirstPsiChild instanceof AssignmentExpression && elseFirstPsiChild instanceof AssignmentExpression) {
                AssignmentExpression assignmentExpressionIf = (AssignmentExpression)ifFirstPsiChild;
                AssignmentExpression assignmentExpressionElse = (AssignmentExpression)elseFirstPsiChild;
                return PhpReplaceIfWithTernaryIntention.assignmentsToTheSameVariable(assignmentExpressionIf, assignmentExpressionElse) && assignmentExpressionIf.getValue() != null && assignmentExpressionElse.getValue() != null && !PhpReplaceIfWithTernaryIntention.isPassedByReference((PsiElement)assignmentExpressionIf.getValue()) && !PhpReplaceIfWithTernaryIntention.isPassedByReference((PsiElement)assignmentExpressionElse.getValue());
            }
            return false;
        }

        @Override
        public Statement tryToBuildTernary(@NotNull PsiElement condition, @NotNull Statement ifStatement, @NotNull Statement elseStatement) {
            if (condition == null) {
                AssignmentStatementProcessor.$$$reportNull$$$0(0);
            }
            if (ifStatement == null) {
                AssignmentStatementProcessor.$$$reportNull$$$0(1);
            }
            if (elseStatement == null) {
                AssignmentStatementProcessor.$$$reportNull$$$0(2);
            }
            PhpPsiElement ifFirstPsiChild = ifStatement.getFirstPsiChild();
            PhpPsiElement elseFirstPsiChild = elseStatement.getFirstPsiChild();
            if (ifFirstPsiChild instanceof AssignmentExpression && elseFirstPsiChild instanceof AssignmentExpression) {
                AssignmentExpression assignmentExpressionThen = (AssignmentExpression)ifFirstPsiChild;
                AssignmentExpression assignmentExpressionElse = (AssignmentExpression)elseFirstPsiChild;
                PhpPsiElement thenVariable = assignmentExpressionThen.getVariable();
                PhpPsiElement thenValue = assignmentExpressionThen.getValue();
                PhpPsiElement elseValue = assignmentExpressionElse.getValue();
                String prefixThen = PhpReplaceIfWithTernaryIntention.getPrefix(assignmentExpressionThen);
                String prefixElse = PhpReplaceIfWithTernaryIntention.getPrefix(assignmentExpressionElse);
                if (PhpReplaceIfWithTernaryIntention.assignmentsToTheSameVariable(assignmentExpressionThen, assignmentExpressionElse)) {
                    assert (thenVariable != null);
                    assert (thenValue != null);
                    assert (elseValue != null);
                    String builtStatement = thenVariable.getText() + "=" + PhpReplaceIfWithTernaryIntention.prepareExpressionText(condition) + "?" + prefixThen + PhpReplaceIfWithTernaryIntention.prepareExpressionText((PsiElement)thenValue) + ":" + prefixElse + PhpReplaceIfWithTernaryIntention.prepareExpressionText((PsiElement)elseValue) + ";";
                    return PhpPsiElementFactory.createFromText(condition.getProject(), Statement.class, builtStatement);
                }
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "condition";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "ifStatement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "elseStatement";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/lang/intentions/PhpReplaceIfWithTernaryIntention$AssignmentStatementProcessor";
            objectArray[2] = "tryToBuildTernary";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class ReturnStatementProcessor
    implements IfStatementProcessor {
        ReturnStatementProcessor() {
        }

        @Override
        public boolean isAvailable(@NotNull Statement thenStatement, @NotNull Statement elseStatement) {
            if (thenStatement == null) {
                ReturnStatementProcessor.$$$reportNull$$$0(0);
            }
            if (elseStatement == null) {
                ReturnStatementProcessor.$$$reportNull$$$0(1);
            }
            if (thenStatement instanceof PhpReturn && elseStatement instanceof PhpReturn) {
                PsiElement thenElement = ((PhpReturn)thenStatement).getArgument();
                PsiElement elseElement = ((PhpReturn)elseStatement).getArgument();
                return elseElement != null && thenElement != null && !PhpReplaceIfWithTernaryIntention.isPassedByReference(thenElement) && !PhpReplaceIfWithTernaryIntention.isPassedByReference(elseElement);
            }
            return false;
        }

        @Override
        public Statement tryToBuildTernary(@NotNull PsiElement condition, @NotNull Statement thenStatement, @NotNull Statement elseStatement) {
            if (condition == null) {
                ReturnStatementProcessor.$$$reportNull$$$0(2);
            }
            if (thenStatement == null) {
                ReturnStatementProcessor.$$$reportNull$$$0(3);
            }
            if (elseStatement == null) {
                ReturnStatementProcessor.$$$reportNull$$$0(4);
            }
            if (thenStatement instanceof PhpReturn && elseStatement instanceof PhpReturn) {
                PsiElement thenElement = ((PhpReturn)thenStatement).getArgument();
                PsiElement elseElement = ((PhpReturn)elseStatement).getArgument();
                if (elseElement != null && thenElement != null) {
                    Project project = condition.getProject();
                    return (Statement)PhpPsiElementFactory.createFirstFromText(project, PhpReturn.class, "return " + PhpReplaceIfWithTernaryIntention.prepareExpressionText(condition) + "?" + PhpReplaceIfWithTernaryIntention.prepareExpressionText(thenElement) + ":" + PhpReplaceIfWithTernaryIntention.prepareExpressionText(elseElement) + ";");
                }
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "thenStatement";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elseStatement";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "condition";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/lang/intentions/PhpReplaceIfWithTernaryIntention$ReturnStatementProcessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isAvailable";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "tryToBuildTernary";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static interface IfStatementProcessor {
        public boolean isAvailable(Statement var1, Statement var2);

        public Statement tryToBuildTernary(@NotNull PsiElement var1, @NotNull Statement var2, @NotNull Statement var3);
    }
}

