/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.tools.quality;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.jetbrains.php.tools.quality.QualityToolMessage;
import com.jetbrains.php.tools.quality.QualityToolMessageProcessor;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;

public class QualityToolAnnotationAppender {
    private static final int INITIAL_MESSAGE_COUNTERS_CAPACITY = 100;
    private static final int MAX_MESSAGES_PER_LINE = 6;
    private final PsiFile myFile;
    private final AnnotationTarget myTarget;
    private final HashMap<TextRange, Integer> myMessageCounts;
    private static final Logger LOG = Logger.getInstance(QualityToolAnnotationAppender.class);

    public QualityToolAnnotationAppender(PsiFile file, @NotNull AnnotationTarget target) {
        if (target == null) {
            QualityToolAnnotationAppender.$$$reportNull$$$0(0);
        }
        this.myMessageCounts = new HashMap(100);
        this.myFile = file;
        this.myTarget = target;
    }

    public void apply(QualityToolMessageProcessor annotationResult) {
        if (annotationResult == null) {
            return;
        }
        annotationResult.getMessages().forEach(this::addAnnotation);
    }

    public void addAnnotation(QualityToolMessage message) {
        Integer messageCount;
        Document doc = PsiDocumentManager.getInstance((Project)this.myFile.getProject()).getDocument(this.myFile);
        if (doc == null) {
            return;
        }
        TextRange textRange = message.getTextRange();
        Integer n = messageCount = this.myMessageCounts.getOrDefault(textRange, 0);
        Integer n2 = messageCount = Integer.valueOf(messageCount + 1);
        this.myMessageCounts.put(textRange, messageCount);
        if (message.isInternalError()) {
            this.myTarget.creteInternalErrorAnnotation(this.myFile, message.getMessageText(), message.getQuickFix());
            return;
        }
        if (textRange.getEndOffset() <= doc.getTextLength()) {
            if (messageCount > 6) {
                return;
            }
            String messageText = messageCount < 6 ? message.getMessageText() : "Too many messages per line...";
            this.myTarget.createAnnotation(message.getDisplayLevel(), textRange, messageText, message.getQuickFix());
        } else {
            LOG.warn("Text range " + textRange + " exceeds document length" + doc.getTextLength() + ", file: " + this.myFile.getVirtualFile().getPath());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/jetbrains/php/tools/quality/QualityToolAnnotationAppender", "<init>"));
    }

    static interface AnnotationTarget {
        public void createAnnotation(HighlightDisplayLevel var1, TextRange var2, String var3, IntentionAction ... var4);

        public void creteInternalErrorAnnotation(@NotNull PsiFile var1, @NotNull String var2, IntentionAction ... var3);
    }
}

