/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerConfigurableNew;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.newui.CellPluginComponent;
import com.intellij.ide.plugins.newui.EventHandler;
import com.intellij.ide.plugins.newui.HorizontalLayout;
import com.intellij.ide.plugins.newui.InstallButton;
import com.intellij.ide.plugins.newui.LineFunction;
import com.intellij.ide.plugins.newui.MyPluginModel;
import com.intellij.ide.plugins.newui.RestartButton;
import com.intellij.ide.plugins.newui.SearchQueryParser;
import com.intellij.ide.plugins.newui.TagBuilder;
import com.intellij.ide.plugins.newui.TagComponent;
import com.intellij.ide.plugins.newui.TwoLineProgressIndicator;
import com.intellij.ide.plugins.newui.VerticalLayout;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.ui.AbstractLayoutManager;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class GridCellPluginComponent
extends CellPluginComponent {
    private final MyPluginModel myPluginModel;
    private JLabel myLastUpdated;
    private JLabel myDownloads;
    private JLabel myRating;
    private final JButton myInstallButton;
    private JComponent myLastComponent;
    private List<TagComponent> myTagComponents;
    private ProgressIndicatorEx myIndicator;

    public GridCellPluginComponent(@NotNull MyPluginModel pluginsModel, @NotNull IdeaPluginDescriptor plugin, @NotNull TagBuilder tagBuilder) {
        if (pluginsModel == null) {
            GridCellPluginComponent.$$$reportNull$$$0(0);
        }
        if (plugin == null) {
            GridCellPluginComponent.$$$reportNull$$$0(1);
        }
        if (tagBuilder == null) {
            GridCellPluginComponent.$$$reportNull$$$0(2);
        }
        super(plugin);
        this.myInstallButton = new InstallButton(false);
        this.myPluginModel = pluginsModel;
        pluginsModel.addComponent(this);
        NonOpaquePanel container = new NonOpaquePanel((LayoutManager)new BorderLayout(JBUI.scale((int)10), 0));
        this.add((Component)container);
        this.addIconComponent((JPanel)container, "West");
        NonOpaquePanel centerPanel = new NonOpaquePanel((LayoutManager)((Object)new VerticalLayout(PluginManagerConfigurableNew.offset5(), JBUI.scale((int)181))));
        container.add((Component)centerPanel);
        this.addNameComponent((JPanel)centerPanel);
        this.addTags((JPanel)centerPanel, tagBuilder);
        this.addDescriptionComponent((JPanel)centerPanel, PluginManagerConfigurableNew.getShortDescription(this.myPlugin, false), new LineFunction(3, true));
        this.createMetricsPanel((JPanel)centerPanel);
        this.addInstallButton();
        this.setOpaque(true);
        this.setBorder(JBUI.Borders.empty((int)10));
        this.setLayout((LayoutManager)new AbstractLayoutManager((JPanel)container, (JPanel)centerPanel){
            final /* synthetic */ JPanel val$container;
            final /* synthetic */ JPanel val$centerPanel;
            {
                this.val$container = jPanel;
                this.val$centerPanel = jPanel2;
            }

            public Dimension preferredLayoutSize(Container parent) {
                Dimension size = this.val$container.getPreferredSize();
                size.height += PluginManagerConfigurableNew.offset5();
                size.height += ((GridCellPluginComponent)GridCellPluginComponent.this).myLastComponent.getPreferredSize().height;
                JBInsets.addTo((Dimension)size, (Insets)parent.getInsets());
                return size;
            }

            public void layoutContainer(Container parent) {
                Insets insets = parent.getInsets();
                Dimension size = this.val$container.getPreferredSize();
                Rectangle bounds2 = new Rectangle(insets.left, insets.top, size.width, size.height);
                this.val$container.setBounds(bounds2);
                this.val$container.doLayout();
                Point location = this.val$centerPanel.getLocation();
                Dimension buttonSize = GridCellPluginComponent.this.myLastComponent.getPreferredSize();
                Border border = GridCellPluginComponent.this.myLastComponent.getBorder();
                int borderOffset = border == null ? 0 : border.getBorderInsets((Component)((GridCellPluginComponent)GridCellPluginComponent.this).myLastComponent).left;
                GridCellPluginComponent.this.myLastComponent.setBounds(bounds2.x + location.x - borderOffset, bounds2.y + PluginManagerConfigurableNew.offset5() + bounds2.height, Math.min(buttonSize.width, size.width), buttonSize.height);
            }
        });
        this.updateIcon(false, false);
        this.updateColors(EventHandler.SelectionType.NONE);
    }

    private void createMetricsPanel(@NotNull JPanel centerPanel) {
        if (centerPanel == null) {
            GridCellPluginComponent.$$$reportNull$$$0(3);
        }
        if (!(this.myPlugin instanceof PluginNode)) {
            return;
        }
        String downloads = PluginManagerConfigurableNew.getDownloads(this.myPlugin);
        String date = PluginManagerConfigurableNew.getLastUpdatedDate(this.myPlugin);
        String rating = PluginManagerConfigurableNew.getRating(this.myPlugin);
        if (downloads != null || date != null || rating != null) {
            NonOpaquePanel panel2 = new NonOpaquePanel((LayoutManager)((Object)new HorizontalLayout(JBUI.scale((int)7))));
            centerPanel.add((Component)panel2);
            if (date != null) {
                this.myLastUpdated = GridCellPluginComponent.createRatingLabel((JPanel)panel2, date, AllIcons.Plugins.Updated);
            }
            if (downloads != null) {
                this.myDownloads = GridCellPluginComponent.createRatingLabel((JPanel)panel2, downloads, AllIcons.Plugins.Downloads);
            }
            if (rating != null) {
                this.myRating = GridCellPluginComponent.createRatingLabel((JPanel)panel2, rating, AllIcons.Plugins.Rating);
            }
        }
    }

    @NotNull
    private static JLabel createRatingLabel(@NotNull JPanel panel2, @NotNull String text, @NotNull Icon icon) {
        if (panel2 == null) {
            GridCellPluginComponent.$$$reportNull$$$0(4);
        }
        if (text == null) {
            GridCellPluginComponent.$$$reportNull$$$0(5);
        }
        if (icon == null) {
            GridCellPluginComponent.$$$reportNull$$$0(6);
        }
        JLabel label2 = new JLabel(text, icon, 0);
        label2.setOpaque(false);
        label2.setIconTextGap(2);
        panel2.add(PluginManagerConfigurableNew.installTiny(label2));
        JLabel jLabel = label2;
        if (jLabel == null) {
            GridCellPluginComponent.$$$reportNull$$$0(7);
        }
        return jLabel;
    }

    private void addInstallButton() {
        if (InstalledPluginsState.getInstance().wasInstalled(this.myPlugin.getPluginId())) {
            RestartButton restartButton = new RestartButton(this.myPluginModel);
            restartButton.setFocusable(false);
            this.myLastComponent = restartButton;
            this.add(this.myLastComponent);
            return;
        }
        this.myInstallButton.setFocusable(false);
        this.myInstallButton.addActionListener(e -> this.myPluginModel.installOrUpdatePlugin(this.myPlugin, true));
        this.myInstallButton.setEnabled(PluginManager.getPlugin(this.myPlugin.getPluginId()) == null);
        this.myLastComponent = this.myInstallButton;
        this.add(this.myLastComponent);
        if (MyPluginModel.isInstallingOrUpdate(this.myPlugin)) {
            this.showProgress(false);
        }
    }

    public void showProgress() {
        this.showProgress(true);
    }

    private void showProgress(boolean repaint) {
        TwoLineProgressIndicator indicator = new TwoLineProgressIndicator();
        indicator.setCancelRunnable(() -> this.myPluginModel.finishInstall(this.myPlugin, false, false));
        this.myIndicator = indicator;
        this.myInstallButton.setVisible(false);
        this.myLastComponent = indicator.getComponent();
        this.add(this.myLastComponent);
        this.doLayout();
        this.myPluginModel.addProgress(this.myPlugin, indicator);
        if (repaint) {
            this.fullRepaint();
        }
    }

    public void hideProgress(boolean success2) {
        this.myIndicator = null;
        JComponent lastComponent = this.myLastComponent;
        if (success2) {
            RestartButton restartButton = new RestartButton(this.myPluginModel);
            restartButton.setFocusable(false);
            this.myLastComponent = restartButton;
            this.add(this.myLastComponent);
        } else {
            this.myLastComponent = this.myInstallButton;
            this.myInstallButton.setVisible(true);
        }
        this.remove(lastComponent);
        this.doLayout();
        this.fullRepaint();
    }

    private void addTags(@NotNull JPanel parent, @NotNull TagBuilder tagBuilder) {
        List<String> tags;
        if (parent == null) {
            GridCellPluginComponent.$$$reportNull$$$0(8);
        }
        if (tagBuilder == null) {
            GridCellPluginComponent.$$$reportNull$$$0(9);
        }
        if ((tags = PluginManagerConfigurableNew.getTags(this.myPlugin)).isEmpty()) {
            return;
        }
        NonOpaquePanel panel2 = new NonOpaquePanel((LayoutManager)((Object)new HorizontalLayout(JBUI.scale((int)6))));
        parent.add((Component)panel2);
        this.myTagComponents = new ArrayList<TagComponent>();
        for (String tag : tags) {
            TagComponent component = tagBuilder.createTagComponent(tag);
            panel2.add((Component)((Object)component));
            this.myTagComponents.add(component);
        }
    }

    @Override
    public void setListeners(final @NotNull LinkListener<IdeaPluginDescriptor> listener2, @NotNull LinkListener<String> searchListener, @NotNull EventHandler eventHandler) {
        if (listener2 == null) {
            GridCellPluginComponent.$$$reportNull$$$0(10);
        }
        if (searchListener == null) {
            GridCellPluginComponent.$$$reportNull$$$0(11);
        }
        if (eventHandler == null) {
            GridCellPluginComponent.$$$reportNull$$$0(12);
        }
        super.setListeners(listener2, searchListener, eventHandler);
        if (this.myDescription != null) {
            UIUtil.setCursor((Component)this.myDescription, (Cursor)Cursor.getPredefinedCursor(12));
            this.myDescription.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent event) {
                    if (SwingUtilities.isLeftMouseButton(event)) {
                        listener2.linkSelected(GridCellPluginComponent.this.myName, (Object)GridCellPluginComponent.this.myPlugin);
                    }
                }
            });
            this.myDescription.addMouseListener(this.myHoverNameListener);
        }
        if (this.myTagComponents != null) {
            for (TagComponent component : this.myTagComponents) {
                component.setListener(searchListener, SearchQueryParser.getTagQuery(component.getText()));
            }
            this.myTagComponents = null;
        }
    }

    @Override
    protected void updateColors(@NotNull Color grayedFg, @NotNull Color background) {
        if (grayedFg == null) {
            GridCellPluginComponent.$$$reportNull$$$0(13);
        }
        if (background == null) {
            GridCellPluginComponent.$$$reportNull$$$0(14);
        }
        super.updateColors(grayedFg, background);
        if (this.myLastUpdated != null) {
            this.myLastUpdated.setForeground(grayedFg);
        }
        if (this.myDownloads != null) {
            this.myDownloads.setForeground(grayedFg);
        }
        if (this.myRating != null) {
            this.myRating.setForeground(grayedFg);
        }
    }

    @Override
    public void close() {
        if (this.myIndicator != null) {
            this.myPluginModel.removeProgress(this.myPlugin, this.myIndicator);
            this.myIndicator = null;
        }
        this.myPluginModel.removeComponent(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginsModel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugin";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagBuilder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "centerPanel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/newui/GridCellPluginComponent";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchListener";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventHandler";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grayedFg";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "background";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/newui/GridCellPluginComponent";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createRatingLabel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createMetricsPanel";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createRatingLabel";
                break;
            }
            case 7: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addTags";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setListeners";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "updateColors";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

