/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.ex;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableGroup;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.options.ex.ConfigurableWrapper;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class ConfigurableVisitor {
    public static final ConfigurableVisitor ALL = new ConfigurableVisitor(){

        @Override
        protected boolean accept(Configurable configurable) {
            return true;
        }
    };

    protected abstract boolean accept(Configurable var1);

    public final Configurable find(ConfigurableGroup ... groups) {
        if (groups == null) {
            ConfigurableVisitor.$$$reportNull$$$0(0);
        }
        for (ConfigurableGroup group : groups) {
            Configurable result2 = this.find(group.getConfigurables());
            if (result2 == null) continue;
            return result2;
        }
        return null;
    }

    public final Configurable find(Configurable ... configurables) {
        if (configurables == null) {
            ConfigurableVisitor.$$$reportNull$$$0(1);
        }
        for (Configurable configurable : configurables) {
            if (!this.accept(configurable)) continue;
            return configurable;
        }
        for (Configurable configurable : configurables) {
            Configurable.Composite composite;
            Configurable result2;
            if (!(configurable instanceof Configurable.Composite) || (result2 = this.find((composite = (Configurable.Composite)configurable).getConfigurables())) == null) continue;
            return result2;
        }
        return null;
    }

    public final List<Configurable> findAll(ConfigurableGroup ... groups) {
        if (groups == null) {
            ConfigurableVisitor.$$$reportNull$$$0(2);
        }
        ArrayList<Configurable> list2 = new ArrayList<Configurable>();
        for (ConfigurableGroup group : groups) {
            this.add(list2, group.getConfigurables());
        }
        return list2;
    }

    public final List<Configurable> findAll(Configurable ... configurables) {
        if (configurables == null) {
            ConfigurableVisitor.$$$reportNull$$$0(3);
        }
        ArrayList<Configurable> list2 = new ArrayList<Configurable>();
        this.add(list2, configurables);
        return list2;
    }

    private void add(List<Configurable> list2, Configurable ... configurables) {
        for (Configurable configurable : configurables) {
            if (this.accept(configurable)) {
                list2.add(configurable);
            }
            if (!(configurable instanceof Configurable.Composite)) continue;
            Configurable.Composite composite = (Configurable.Composite)configurable;
            this.add(list2, composite.getConfigurables());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groups";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurables";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/options/ex/ConfigurableVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "find";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findAll";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class ByType
    extends ConfigurableVisitor {
        private final Class<? extends Configurable> myType;

        public ByType(@NotNull Class<? extends Configurable> type) {
            if (type == null) {
                ByType.$$$reportNull$$$0(0);
            }
            this.myType = type;
        }

        @Override
        protected boolean accept(Configurable configurable) {
            return ConfigurableWrapper.cast(this.myType, (UnnamedConfigurable)configurable) != null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/options/ex/ConfigurableVisitor$ByType", "<init>"));
        }
    }

    public static final class ByName
    extends ConfigurableVisitor {
        private final String myName;

        public ByName(@NotNull String name) {
            if (name == null) {
                ByName.$$$reportNull$$$0(0);
            }
            this.myName = name;
        }

        @Override
        protected boolean accept(Configurable configurable) {
            return this.myName.equals(configurable.getDisplayName());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/options/ex/ConfigurableVisitor$ByName", "<init>"));
        }
    }

    public static final class ByID
    extends ConfigurableVisitor {
        private final String myID;

        public ByID(@NotNull String id) {
            if (id == null) {
                ByID.$$$reportNull$$$0(0);
            }
            this.myID = id;
        }

        @Override
        protected boolean accept(Configurable configurable) {
            return this.myID.equals(ByID.getID(configurable));
        }

        public static String getID(Configurable configurable) {
            return configurable instanceof SearchableConfigurable ? ((SearchableConfigurable)configurable).getId() : configurable.getClass().getName();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/options/ex/ConfigurableVisitor$ByID", "<init>"));
        }
    }
}

