/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.library;

import com.intellij.lang.javascript.library.JSLibraryManager;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLibReferenceResolver {
    private JSLibReferenceResolver() {
    }

    @Nullable
    public static PsiReference getLibReference(XmlAttributeValue attributeValue) {
        PsiReference[] refs;
        for (PsiReference ref : refs = attributeValue.getReferences()) {
            if (!(ref instanceof JSLibReference)) continue;
            return ref;
        }
        return null;
    }

    public static JSLibReference createReference(XmlAttributeValue attributeValue) {
        return new JSLibReference(attributeValue);
    }

    public static class JSLibReference
    implements PsiReference {
        private final XmlAttributeValue myAttributeValue;
        private final Project myProject;

        public JSLibReference(XmlAttributeValue attributeValue) {
            this.myProject = attributeValue.getProject();
            this.myAttributeValue = attributeValue;
        }

        @NotNull
        public PsiElement getElement() {
            XmlAttributeValue xmlAttributeValue = this.myAttributeValue;
            if (xmlAttributeValue == null) {
                JSLibReference.$$$reportNull$$$0(0);
            }
            return xmlAttributeValue;
        }

        @NotNull
        public TextRange getRangeInElement() {
            TextRange absValueRange = this.myAttributeValue.getValueTextRange();
            int offset = this.myAttributeValue.getTextRange().getStartOffset();
            TextRange textRange = new TextRange(absValueRange.getStartOffset() - offset, absValueRange.getEndOffset() - offset);
            if (textRange == null) {
                JSLibReference.$$$reportNull$$$0(1);
            }
            return textRange;
        }

        public PsiElement resolve() {
            return JSLibReference.resolveToLibrary(this.myAttributeValue.getValue(), this.myProject);
        }

        @Nullable
        public static PsiElement resolveToLibrary(String libName, Project project) {
            JSLibraryManager libraryManager = (JSLibraryManager)((Object)ServiceManager.getService((Project)project, JSLibraryManager.class));
            VirtualFile vf = libraryManager.getMatchingFile(JSLibraryUtil.makeUniqueFileName(libName, true));
            if (vf == null) {
                vf = libraryManager.getMatchingFile(JSLibraryUtil.makeUniqueFileName(libName, false));
            }
            if (vf != null && !vf.isValid()) {
                vf = JSLibReference.findNewVirtualFile(vf);
            }
            if (vf != null) {
                PsiManager psiManager = PsiManager.getInstance((Project)project);
                return psiManager.findFile(vf);
            }
            return null;
        }

        @Nullable
        private static VirtualFile findNewVirtualFile(@NotNull VirtualFile vf) {
            if (vf == null) {
                JSLibReference.$$$reportNull$$$0(2);
            }
            return (VirtualFile)ReadAction.compute(() -> {
                VirtualFileSystem fileSystem;
                VirtualFile newVf;
                if (vf == null) {
                    JSLibReference.$$$reportNull$$$0(7);
                }
                if ((newVf = (fileSystem = vf.getFileSystem()).findFileByPath(vf.getPath())) != null && newVf.isValid()) {
                    return newVf;
                }
                return null;
            });
        }

        @NotNull
        public String getCanonicalText() {
            String string = this.myAttributeValue.getValue();
            if (string == null) {
                JSLibReference.$$$reportNull$$$0(3);
            }
            return string;
        }

        public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
            if (newElementName == null) {
                JSLibReference.$$$reportNull$$$0(4);
            }
            throw new IncorrectOperationException();
        }

        public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
            if (element == null) {
                JSLibReference.$$$reportNull$$$0(5);
            }
            throw new IncorrectOperationException();
        }

        public boolean isReferenceTo(@NotNull PsiElement element) {
            if (element == null) {
                JSLibReference.$$$reportNull$$$0(6);
            }
            return false;
        }

        public boolean isSoft() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/library/JSLibReferenceResolver$JSLibReference";
                    break;
                }
                case 2: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "vf";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newElementName";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRangeInElement";
                    break;
                }
                case 2: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/library/JSLibReferenceResolver$JSLibReference";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCanonicalText";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "findNewVirtualFile";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "handleElementRename";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "bindToElement";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "isReferenceTo";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$findNewVirtualFile$0";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

