/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.ast;

import org.jrubyparser.NodeVisitor;
import org.jrubyparser.SourcePosition;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;

public class FlipNode
extends Node {
    private Node beginNode;
    private Node endNode;
    private boolean exclusive;
    private int location;

    public FlipNode(SourcePosition position, Node beginNode, Node endNode, boolean exclusive, int location) {
        super(position);
        assert (beginNode != null) : "beginNode is not null";
        assert (endNode != null) : "endNode is not null";
        this.beginNode = this.adopt(beginNode);
        this.endNode = this.adopt(endNode);
        this.exclusive = exclusive;
        this.location = location;
    }

    public boolean isSame(Node node) {
        if (!super.isSame(node)) {
            return false;
        }
        FlipNode other = (FlipNode)node;
        return this.getBegin().isSame(other.getBegin()) && this.getEnd().isSame(other.getEnd());
    }

    public NodeType getNodeType() {
        return NodeType.FLIPNODE;
    }

    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitFlipNode(this);
    }

    public Node getBegin() {
        return this.beginNode;
    }

    @Deprecated
    public Node getBeginNode() {
        return this.getBegin();
    }

    public Node getEnd() {
        return this.endNode;
    }

    @Deprecated
    public Node getEndNode() {
        return this.getEnd();
    }

    public boolean isExclusive() {
        return this.exclusive;
    }

    public int getDepth() {
        return this.location >> 16;
    }

    public int getIndex() {
        return this.location & 0xFFFF;
    }
}

