/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phing.ui.explorer;

import com.intellij.execution.RunManagerEx;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.CellAppearanceEx;
import com.intellij.openapi.roots.ui.util.CompositeAppearance;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.HtmlListCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredComponent;
import com.jetbrains.php.phing.PhingBuildTarget;
import com.jetbrains.php.phing.PhingBundle;
import com.jetbrains.php.phing.ui.explorer.PhingBeforeRunTask;
import com.jetbrains.php.phing.ui.explorer.PhingBeforeRunTaskProvider;
import com.jetbrains.php.phing.ui.explorer.PhingBuildFileNodeDescriptor;
import com.jetbrains.php.phing.ui.explorer.PhingNodeDescriptor;
import icons.PhingIcons;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhingTargetNodeDescriptor
extends PhingNodeDescriptor {
    private static final TextAttributes ourPostfixAttributes = new TextAttributes((Color)JBColor.blue, null, null, EffectType.BOXED, 0);
    private static final TextAttributes ourDescriptionAttributes = new TextAttributes((Color)JBColor.gray, null, null, EffectType.BOXED, 0);
    private final PhingBuildTarget myTarget;
    private CompositeAppearance myHighlightedText;

    public PhingTargetNodeDescriptor(Project project, NodeDescriptor parentDescriptor, PhingBuildTarget target) {
        super(project, parentDescriptor);
        this.myTarget = target;
        this.myHighlightedText = new CompositeAppearance();
    }

    public Object getElement() {
        return this.myTarget;
    }

    public PhingBuildTarget getTarget() {
        return this.myTarget;
    }

    @Nullable
    private String getFileName() {
        VirtualFile targetFile;
        VirtualFile parentFile = ((PhingBuildFileNodeDescriptor)this.getParentDescriptor()).getBuildFile().getFile();
        if (!parentFile.equals(targetFile = this.myTarget.getFile())) {
            return targetFile.getPresentableName();
        }
        return null;
    }

    public boolean update() {
        String description;
        CompositeAppearance oldText = this.myHighlightedText;
        this.setIcon(PhingIcons.Target);
        this.myHighlightedText = new CompositeAppearance();
        String filename = this.getFileName();
        if (filename != null) {
            TextAttributes fileNameAttributes = new TextAttributes((Color)JBColor.gray, null, null, EffectType.BOXED, 0);
            this.myHighlightedText.getEnding().addText(filename + " ", fileNameAttributes);
        }
        JBColor nameColor = JBColor.black;
        if (this.myTarget.isHiddenByAttribute() || this.myTarget.getContextBuildFile().getTargetsToHide().contains(this.myTarget.getName())) {
            nameColor = JBColor.gray;
        }
        TextAttributes nameAttributes = new TextAttributes((Color)nameColor, null, null, EffectType.BOXED, this.myTarget.isDefault() ? 1 : 0);
        this.myHighlightedText.getEnding().addText(this.myTarget.getName(), nameAttributes);
        VirtualFile vFile = this.myTarget.getContextFile();
        if (vFile != null) {
            for (PhingBeforeRunTask task : RunManagerEx.getInstanceEx((Project)this.myProject).getBeforeRunTasks(PhingBeforeRunTaskProvider.ID)) {
                if (!task.isRunningTarget(this.myTarget)) continue;
                this.myHighlightedText.getEnding().addText(PhingBundle.message("phing.target.node.before.run.debug", ""), ourPostfixAttributes);
                break;
            }
        }
        if (!StringUtil.isEmpty((String)(description = this.myTarget.getDescription()))) {
            this.myHighlightedText.getEnding().addText(" [" + description + "]", ourDescriptionAttributes);
        }
        return !Comparing.equal((Object)this.myHighlightedText, (Object)oldText);
    }

    protected CellAppearanceEx getHighlightedText() {
        return this.myHighlightedText;
    }

    @Override
    public boolean isAutoExpand() {
        return false;
    }

    @Override
    public void customize(@NotNull SimpleColoredComponent component) {
        if (component == null) {
            PhingTargetNodeDescriptor.$$$reportNull$$$0(0);
        }
        this.getHighlightedText().customize(component);
        component.setIcon(this.getIcon());
    }

    @Override
    public void customize(@NotNull HtmlListCellRenderer renderer) {
        if (renderer == null) {
            PhingTargetNodeDescriptor.$$$reportNull$$$0(1);
        }
        this.getHighlightedText().customize(renderer);
        renderer.setIcon(this.getIcon());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "component";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "renderer";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/php/phing/ui/explorer/PhingTargetNodeDescriptor";
        objectArray[2] = "customize";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

