/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console.evaluation;

import com.intellij.database.DataBus;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.evaluation.DasObjectRequestor;
import com.intellij.database.console.evaluation.DatabaseExpressionEvaluator;
import com.intellij.database.console.evaluation.EvaluationRequest;
import com.intellij.database.console.evaluation.EvaluationRequestor;
import com.intellij.database.console.evaluation.EvaluationRequestorFactory;
import com.intellij.database.console.evaluation.PsiRequestor;
import com.intellij.database.console.evaluation.TextRequestor;
import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.model.DasObject;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.util.SearchPath;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.sql.psi.SqlElement;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OwnerBasedExpressionEvaluator<T>
implements DatabaseExpressionEvaluator<T> {
    protected final DataRequest.OwnerEx myOwner;
    protected final DbDataSource myDataSource;
    protected final SearchPath mySearchPath;
    protected final Project myProject;
    private final Disposable myParent;

    public OwnerBasedExpressionEvaluator(@NotNull DataRequest.OwnerEx owner, @NotNull DbDataSource dataSource, @Nullable SearchPath searchPath, @NotNull Project project, @Nullable Disposable parent2) {
        if (owner == null) {
            OwnerBasedExpressionEvaluator.$$$reportNull$$$0(0);
        }
        if (dataSource == null) {
            OwnerBasedExpressionEvaluator.$$$reportNull$$$0(1);
        }
        if (project == null) {
            OwnerBasedExpressionEvaluator.$$$reportNull$$$0(2);
        }
        this.myOwner = owner;
        this.myDataSource = dataSource;
        this.mySearchPath = searchPath;
        this.myProject = project;
        this.myParent = parent2;
    }

    @NotNull
    public CompletableFuture<DatabaseExpressionEvaluator.Result> evaluate(@NotNull T value) {
        if (value == null) {
            OwnerBasedExpressionEvaluator.$$$reportNull$$$0(3);
        }
        CompletableFuture<DatabaseExpressionEvaluator.Result> future = new CompletableFuture<DatabaseExpressionEvaluator.Result>();
        EvaluationRequestor<DataRequest.OwnerEx> requestor = this.createRequestor(value);
        EvaluationRequest request = requestor.createRequest(this.myOwner, future);
        if (request == null) {
            future.completeExceptionally(new RuntimeException("Can't evaluate: " + requestor.getQuery()));
            CompletableFuture<DatabaseExpressionEvaluator.Result> completableFuture = future;
            if (completableFuture == null) {
                OwnerBasedExpressionEvaluator.$$$reportNull$$$0(4);
            }
            return completableFuture;
        }
        if (this.myParent != null) {
            Disposer.register((Disposable)this.myParent, (Disposable)request);
        }
        DataBus.Consuming bus = this.myOwner.getMessageBus();
        MyAuditor auditor = new MyAuditor(future, request);
        bus.addAuditor(auditor);
        bus.getDataProducer().processRequest(request);
        CompletableFuture<DatabaseExpressionEvaluator.Result> completableFuture = future;
        if (completableFuture == null) {
            OwnerBasedExpressionEvaluator.$$$reportNull$$$0(5);
        }
        return completableFuture;
    }

    @NotNull
    protected abstract EvaluationRequestor<DataRequest.OwnerEx> createRequestor(@NotNull T var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/console/evaluation/OwnerBasedExpressionEvaluator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/console/evaluation/OwnerBasedExpressionEvaluator";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "evaluate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "evaluate";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class PsiExpressionEvaluator
    extends OwnerBasedExpressionEvaluator<SqlElement> {
        private final JdbcConsole myConsole;

        public PsiExpressionEvaluator(@NotNull JdbcConsole console, @NotNull DbDataSource dataSource, @Nullable SearchPath searchPath, @NotNull Project project, @Nullable Disposable parent2) {
            if (console == null) {
                PsiExpressionEvaluator.$$$reportNull$$$0(0);
            }
            if (dataSource == null) {
                PsiExpressionEvaluator.$$$reportNull$$$0(1);
            }
            if (project == null) {
                PsiExpressionEvaluator.$$$reportNull$$$0(2);
            }
            super(console, dataSource, searchPath, project, parent2);
            this.myConsole = console;
        }

        @Override
        @NotNull
        protected EvaluationRequestor<DataRequest.OwnerEx> createRequestor(@NotNull SqlElement value) {
            if (value == null) {
                PsiExpressionEvaluator.$$$reportNull$$$0(3);
            }
            PsiRequestor psiRequestor = new PsiRequestor(this.myConsole, value, this.myProject, this.myDataSource);
            if (psiRequestor == null) {
                PsiExpressionEvaluator.$$$reportNull$$$0(4);
            }
            return psiRequestor;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "console";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSource";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/console/evaluation/OwnerBasedExpressionEvaluator$PsiExpressionEvaluator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/console/evaluation/OwnerBasedExpressionEvaluator$PsiExpressionEvaluator";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createRequestor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createRequestor";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class ImmutableTextExpressionEvaluator
    extends OwnerBasedExpressionEvaluator<String> {
        public ImmutableTextExpressionEvaluator(@NotNull DataRequest.OwnerEx owner, @NotNull DbDataSource dataSource, @Nullable SearchPath searchPath, @NotNull Project project, @Nullable Disposable parent2) {
            if (owner == null) {
                ImmutableTextExpressionEvaluator.$$$reportNull$$$0(0);
            }
            if (dataSource == null) {
                ImmutableTextExpressionEvaluator.$$$reportNull$$$0(1);
            }
            if (project == null) {
                ImmutableTextExpressionEvaluator.$$$reportNull$$$0(2);
            }
            super(owner, dataSource, searchPath, project, parent2);
        }

        @Override
        @NotNull
        protected EvaluationRequestor<DataRequest.OwnerEx> createRequestor(@NotNull String value) {
            if (value == null) {
                ImmutableTextExpressionEvaluator.$$$reportNull$$$0(3);
            }
            TextRequestor textRequestor = new TextRequestor(this.myProject, value, this.myDataSource);
            if (textRequestor == null) {
                ImmutableTextExpressionEvaluator.$$$reportNull$$$0(4);
            }
            return textRequestor;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSource";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/console/evaluation/OwnerBasedExpressionEvaluator$ImmutableTextExpressionEvaluator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/console/evaluation/OwnerBasedExpressionEvaluator$ImmutableTextExpressionEvaluator";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createRequestor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createRequestor";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class TextExpressionEvaluator
    extends OwnerBasedExpressionEvaluator<String> {
        public TextExpressionEvaluator(@NotNull DataRequest.OwnerEx owner, @NotNull DbDataSource dataSource, @Nullable SearchPath searchPath, @NotNull Project project, @Nullable Disposable parent2) {
            if (owner == null) {
                TextExpressionEvaluator.$$$reportNull$$$0(0);
            }
            if (dataSource == null) {
                TextExpressionEvaluator.$$$reportNull$$$0(1);
            }
            if (project == null) {
                TextExpressionEvaluator.$$$reportNull$$$0(2);
            }
            super(owner, dataSource, searchPath, project, parent2);
        }

        @Override
        @NotNull
        protected EvaluationRequestor<DataRequest.OwnerEx> createRequestor(@NotNull String value) {
            if (value == null) {
                TextExpressionEvaluator.$$$reportNull$$$0(3);
            }
            EvaluationRequestor<DataRequest.OwnerEx> evaluationRequestor = EvaluationRequestorFactory.create(this.myProject, value, this.myDataSource, this.mySearchPath);
            if (evaluationRequestor == null) {
                TextExpressionEvaluator.$$$reportNull$$$0(4);
            }
            return evaluationRequestor;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSource";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/console/evaluation/OwnerBasedExpressionEvaluator$TextExpressionEvaluator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/console/evaluation/OwnerBasedExpressionEvaluator$TextExpressionEvaluator";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createRequestor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createRequestor";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class DasObjectEvaluator
    extends OwnerBasedExpressionEvaluator<DasObject> {
        public DasObjectEvaluator(@NotNull DataRequest.OwnerEx owner, @NotNull DbDataSource dataSource, @Nullable SearchPath searchPath, @NotNull Project project, @Nullable Disposable parent2) {
            if (owner == null) {
                DasObjectEvaluator.$$$reportNull$$$0(0);
            }
            if (dataSource == null) {
                DasObjectEvaluator.$$$reportNull$$$0(1);
            }
            if (project == null) {
                DasObjectEvaluator.$$$reportNull$$$0(2);
            }
            super(owner, dataSource, searchPath, project, parent2);
        }

        @Override
        @NotNull
        protected EvaluationRequestor<DataRequest.OwnerEx> createRequestor(@NotNull DasObject value) {
            if (value == null) {
                DasObjectEvaluator.$$$reportNull$$$0(3);
            }
            DasObjectRequestor dasObjectRequestor = new DasObjectRequestor(this.myProject, this.myDataSource, value);
            if (dasObjectRequestor == null) {
                DasObjectEvaluator.$$$reportNull$$$0(4);
            }
            return dasObjectRequestor;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSource";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/console/evaluation/OwnerBasedExpressionEvaluator$DasObjectEvaluator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/console/evaluation/OwnerBasedExpressionEvaluator$DasObjectEvaluator";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createRequestor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createRequestor";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MyAuditor
    extends DataAuditor.Adapter
    implements Disposable {
        private final CompletableFuture<DatabaseExpressionEvaluator.Result> myFuture;
        private final EvaluationRequest myRequest;

        private MyAuditor(@NotNull CompletableFuture<DatabaseExpressionEvaluator.Result> future, @NotNull EvaluationRequest request) {
            if (future == null) {
                MyAuditor.$$$reportNull$$$0(0);
            }
            if (request == null) {
                MyAuditor.$$$reportNull$$$0(1);
            }
            this.myFuture = future;
            this.myRequest = request;
            Disposer.register((Disposable)request, (Disposable)this);
        }

        @Override
        public void error(@NotNull DataRequest.Context context, @Nullable String message2, @Nullable Throwable th) {
            if (context == null) {
                MyAuditor.$$$reportNull$$$0(2);
            }
            if (this.myRequest.isDisposed() || context.request != this.myRequest) {
                return;
            }
            if (!this.myFuture.isDone()) {
                this.myFuture.completeExceptionally(th == null ? new RuntimeException(message2) : th);
            }
            Disposer.dispose((Disposable)this.myRequest);
        }

        public void dispose() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "future";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/console/evaluation/OwnerBasedExpressionEvaluator$MyAuditor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "error";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class EmptyResult
    implements DatabaseExpressionEvaluator.Result {
        @Override
        @NotNull
        public String representation() {
            if ("empty" == null) {
                EmptyResult.$$$reportNull$$$0(0);
            }
            return "empty";
        }

        @Override
        public void computeChildren(@NotNull XCompositeNode node) {
            if (node == null) {
                EmptyResult.$$$reportNull$$$0(1);
            }
        }

        @Override
        public void computePresentation(@NotNull XValueNode node, @NotNull XValuePlace place) {
            if (node == null) {
                EmptyResult.$$$reportNull$$$0(2);
            }
            if (place == null) {
                EmptyResult.$$$reportNull$$$0(3);
            }
            node.setPresentation(null, null, "\"\"", false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/console/evaluation/OwnerBasedExpressionEvaluator$EmptyResult";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "place";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "representation";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/console/evaluation/OwnerBasedExpressionEvaluator$EmptyResult";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "computeChildren";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "computePresentation";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

