/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport;

import com.intellij.database.actions.ImportAction;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dbimport.AbstractDataInputType;
import com.intellij.database.dbimport.DatabaseTableInput;
import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.ReaderTask;
import com.intellij.database.dbimport.ui.ImportSettingsComponent;
import com.intellij.database.dbimport.ui.component.DdlPreviewComponent;
import com.intellij.database.dbimport.ui.component.ImportComponent;
import com.intellij.database.dbimport.ui.database.DatabaseDataPreviewComponent;
import com.intellij.database.dbimport.ui.database.DatabaseTableEditorComponent;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.SearchPath;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseInputType
extends AbstractDataInputType {
    private final String myQueryText;
    private final SearchPath myPath;
    private final Project myProject;

    public DatabaseInputType(@NotNull LocalDataSource producerLocalDataSource, @NotNull DbDataSource producerDataSource, @NotNull DasTable table, @NotNull Project project) {
        if (producerLocalDataSource == null) {
            DatabaseInputType.$$$reportNull$$$0(0);
        }
        if (producerDataSource == null) {
            DatabaseInputType.$$$reportNull$$$0(1);
        }
        if (table == null) {
            DatabaseInputType.$$$reportNull$$$0(2);
        }
        if (project == null) {
            DatabaseInputType.$$$reportNull$$$0(3);
        }
        this(producerLocalDataSource, producerDataSource, table.getName(), DatabaseInputType.getQueryText(table, producerLocalDataSource), project, DatabaseInputType.getSearchPath(producerDataSource, table), table);
    }

    public DatabaseInputType(@NotNull LocalDataSource producerLocalDataSource, @NotNull DbDataSource source, @NotNull String producerName, @NotNull String queryText, @NotNull Project project, @Nullable SearchPath path, @Nullable DasTable table) {
        if (producerLocalDataSource == null) {
            DatabaseInputType.$$$reportNull$$$0(4);
        }
        if (source == null) {
            DatabaseInputType.$$$reportNull$$$0(5);
        }
        if (producerName == null) {
            DatabaseInputType.$$$reportNull$$$0(6);
        }
        if (queryText == null) {
            DatabaseInputType.$$$reportNull$$$0(7);
        }
        if (project == null) {
            DatabaseInputType.$$$reportNull$$$0(8);
        }
        super(source, producerLocalDataSource, producerName, table);
        this.myQueryText = queryText;
        this.myProject = project;
        this.myPath = path == null && table != null ? DatabaseInputType.getSearchPath(source, table) : path;
    }

    @Override
    @NotNull
    public ReaderTask.Input createInput(@NotNull ImportInfo info) {
        if (info == null) {
            DatabaseInputType.$$$reportNull$$$0(9);
        }
        DatabaseTableInput databaseTableInput = new DatabaseTableInput(this.myProducerSource, this.myProducerLocalDataSource, this.myPath, this.myQueryText, this.myProject);
        if (databaseTableInput == null) {
            DatabaseInputType.$$$reportNull$$$0(10);
        }
        return databaseTableInput;
    }

    @Override
    @NotNull
    public List<ImportComponent<?, ?>> getComponents(@NotNull ImportAction.ImportEditorContext context) {
        if (context == null) {
            DatabaseInputType.$$$reportNull$$$0(11);
        }
        List list = ContainerUtil.list((Object[])new ImportComponent[]{new DatabaseDataPreviewComponent(context, this.myProducerLocalDataSource, this.myPath, this.myQueryText), new ImportSettingsComponent(context), new DdlPreviewComponent(context), new DatabaseTableEditorComponent(context)});
        if (list == null) {
            DatabaseInputType.$$$reportNull$$$0(12);
        }
        return list;
    }

    @NotNull
    private static String getQueryText(@NotNull DasTable table, @NotNull LocalDataSource localDataSource) {
        if (table == null) {
            DatabaseInputType.$$$reportNull$$$0(13);
        }
        if (localDataSource == null) {
            DatabaseInputType.$$$reportNull$$$0(14);
        }
        String string = DbImplUtil.createSelectAllQuery(table, localDataSource.getDbms(), localDataSource).getStatement();
        if (string == null) {
            DatabaseInputType.$$$reportNull$$$0(15);
        }
        return string;
    }

    @Nullable
    private static SearchPath getSearchPath(@NotNull DbDataSource producerDataSource, @NotNull DasTable table) {
        if (producerDataSource == null) {
            DatabaseInputType.$$$reportNull$$$0(16);
        }
        if (table == null) {
            DatabaseInputType.$$$reportNull$$$0(17);
        }
        return ObjectPaths.searchPathOf((DasObject)DbImplUtil.getSearchPathObjectForSwitch(producerDataSource, (DasObject)table));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 12: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 12: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "producerLocalDataSource";
                break;
            }
            case 1: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "producerDataSource";
                break;
            }
            case 2: 
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "producerName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryText";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 10: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dbimport/DatabaseInputType";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localDataSource";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dbimport/DatabaseInputType";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createInput";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponents";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getQueryText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createInput";
                break;
            }
            case 10: 
            case 12: 
            case 15: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getComponents";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getQueryText";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getSearchPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 12: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

