/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle;

import com.intellij.database.Dbms;
import com.intellij.database.console.JdbcEngine;
import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.ImportManager;
import com.intellij.database.dbimport.TypeMerger;
import com.intellij.database.dialects.DialectUtils;
import com.intellij.database.schemaEditor.model.DeIndex;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OracleImportManager
extends ImportManager {
    public OracleImportManager() {
        super(Dbms.ORACLE, "CLOB", 1, true, true, false, true, new TypeMerger.IntegerMerger("INTEGER"), new TypeMerger.DoubleMerger("NUMBER"));
    }

    @Override
    @NotNull
    public List<String> getFastModeOnQueries(@NotNull ImportInfo info) {
        if (info == null) {
            OracleImportManager.$$$reportNull$$$0(0);
        }
        List<String> queries = this.getQueries(info.getContext(), info.getTable(), true, "UNUSABLE");
        queries.add(this.getLockQuery(info));
        List<String> list = queries;
        if (list == null) {
            OracleImportManager.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    @NotNull
    public List<String> getFastModeOffQueries(@NotNull ImportInfo info) {
        if (info == null) {
            OracleImportManager.$$$reportNull$$$0(2);
        }
        List<String> list = this.getQueries(info.getContext(), info.getTable(), false, "REBUILD");
        if (list == null) {
            OracleImportManager.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    private List<String> getQueries(@NotNull DatabaseEditorContext context, @NotNull DeTable table, boolean isBeforeImport, @NotNull String whatToDoWithIndices) {
        if (context == null) {
            OracleImportManager.$$$reportNull$$$0(4);
        }
        if (table == null) {
            OracleImportManager.$$$reportNull$$$0(5);
        }
        if (whatToDoWithIndices == null) {
            OracleImportManager.$$$reportNull$$$0(6);
        }
        ArrayList result2 = ContainerUtil.newArrayList();
        result2.add(this.triggers(this.alter(this.createBuilder(context), "TABLE", table).space(), !isBeforeImport).getStatement());
        result2.add(this.skipUnusable(context, isBeforeImport));
        this.alterIndices(context, table, result2, whatToDoWithIndices);
        ArrayList arrayList = result2;
        if (arrayList == null) {
            OracleImportManager.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @Override
    @NotNull
    protected DdlBuilder triggers(@NotNull DdlBuilder builder, boolean enable) {
        if (builder == null) {
            OracleImportManager.$$$reportNull$$$0(8);
        }
        DdlBuilder ddlBuilder = builder.keyword(enable ? "ENABLE" : "DISABLE").space().keyword("ALL").space().keyword("TRIGGERS");
        if (ddlBuilder == null) {
            OracleImportManager.$$$reportNull$$$0(9);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public String getInsertStatement(@NotNull ImportInfo info, int linesCount) {
        if (info == null) {
            OracleImportManager.$$$reportNull$$$0(10);
        }
        if (linesCount > 1) {
            throw new IllegalArgumentException("Lines count bigger than 1 not supported by oracle");
        }
        List<List<Consumer<DdlBuilder>>> params = OracleImportManager.getPlaceholders(Dbms.ORACLE, info.getConsumersForInsert(), linesCount);
        DdlBuilder builder = this.createBuilder(info.getContext()).keyword("INSERT").space().literal("/*+append*/").space().keyword("INTO").space().qualifiedRef(info.getTable()).space().literal("(");
        DialectUtils.appendStringList(builder, JdbcEngine.getColumnNamesForInsert(info.getConsumersForInsert(), Dbms.ORACLE));
        builder.literal(")").space().keyword("VALUES").literal("(");
        DialectUtils.appendCommaSeparated(builder, (Iterable)ContainerUtil.getFirstItem(params));
        builder.literal(")");
        String string = builder.getStatement();
        if (string == null) {
            OracleImportManager.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Override
    @Nullable
    public String getLockQuery(@NotNull ImportInfo info) {
        if (info == null) {
            OracleImportManager.$$$reportNull$$$0(12);
        }
        return this.createBuilder(info.getContext()).space().keyword("LOCK").space().keyword("TABLE").space().qualifiedRef(info.getTable()).space().keyword("IN").space().keyword("EXCLUSIVE").space().keyword("MODE").getStatement();
    }

    private String skipUnusable(@NotNull DatabaseEditorContext context, boolean value) {
        if (context == null) {
            OracleImportManager.$$$reportNull$$$0(13);
        }
        return this.createBuilder(context).keyword("ALTER").space().keyword("SESSION").space().keyword("SET").space().literal("skip_unusable_indexes=").space().literal(String.valueOf(value).toLowerCase(Locale.US)).getStatement();
    }

    private void alterIndices(@NotNull DatabaseEditorContext context, @NotNull DeTable table, @NotNull List<String> result2, @NotNull String whatToDo) {
        if (context == null) {
            OracleImportManager.$$$reportNull$$$0(14);
        }
        if (table == null) {
            OracleImportManager.$$$reportNull$$$0(15);
        }
        if (result2 == null) {
            OracleImportManager.$$$reportNull$$$0(16);
        }
        if (whatToDo == null) {
            OracleImportManager.$$$reportNull$$$0(17);
        }
        if (table.indices.isEmpty()) {
            return;
        }
        for (int i2 = 1; i2 < table.indices.size(); ++i2) {
            result2.add(this.alterIndex(context, table.indices.get(i2), whatToDo));
        }
    }

    private String alterIndex(@NotNull DatabaseEditorContext context, @NotNull DeIndex index2, @NotNull String whatToDo) {
        if (context == null) {
            OracleImportManager.$$$reportNull$$$0(18);
        }
        if (index2 == null) {
            OracleImportManager.$$$reportNull$$$0(19);
        }
        if (whatToDo == null) {
            OracleImportManager.$$$reportNull$$$0(20);
        }
        return this.alter(this.createBuilder(context), "INDEX", index2).space().keyword(whatToDo).getStatement();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 9: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 9: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/oracle/OracleImportManager";
                break;
            }
            case 4: 
            case 13: 
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "whatToDoWithIndices";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "whatToDo";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/oracle/OracleImportManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFastModeOnQueries";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFastModeOffQueries";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getQueries";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "triggers";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getInsertStatement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFastModeOnQueries";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 9: 
            case 11: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFastModeOffQueries";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getQueries";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "triggers";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getInsertStatement";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getLockQuery";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "skipUnusable";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "alterIndices";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "alterIndex";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 9: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

