=begin

= HTML Tag Library

tag.rb

Version 1.0.4

Copyright (C) 2000 MoonWolf Development

MoonWolf <moonwolf-ruby@moonwolf.com>

== Ȥ

=== ŪHTMLν

  require "tag"
  doc = []                          #HTMLɥ(Array)
  html = Tag('html')                #<html>
  doc << html                       #doc<html>ɲ
  html << head = Tag('head')        #html<head>ɲ
  head << (Tag('title') << "TITLE") #head<title>ɲ
  html << body = Tag('body',{'bgcolor'=>'#FFFFFF'})
                                    #<body bgcolor="#FFFFFF">
  print doc.to_s                    #HTML

==== 
  <html><head><title>TITLE</title></head><body bgcolor="#FFFFFF"></body></html>

=== °

  img = Tag('img/')
  img['src']='xxx.png'  #<img src="xxx.png">
  
  o = Tag('option')
  o['selected']=true    #<option selected>

=end

require "cgi"

class Tag
=begin
== 饹᥽å:
--- new(tagname[,attr[,item]])
     ֥Ȥ롣
     ((|tagname|))ϥ̾Ǥξ'/'ɲä̾ꤹ롣
       Tag.new('html') # <html></html>
       Tag.new('hr/')  # <hr>
=end
	def initialize(tagname,attr = {},item=[])
		@tagname = tagname
		@attr    = attr
		@item    = item
	end
=begin
== ᥽å:
--- tagname
     ֤̾
--- attr
     °Υϥå֤
--- item
     Ǥ֤
=end
	attr_accessor('tagname')
	attr_accessor('attr')
	attr_accessor('item')
	def [](name)
		@attr[name]
	end
	def []=(name,value)
		if value
			@attr[name] = value
		else
			@attr.delete(name)
		end
	end
=begin
--- self<<(obj)
    ((|obj|))ɲä롣

=end
	def <<(obj)
		if obj.type==Array
			@item.concat obj
		else
			@item.concat [obj]
		end
		self
	end
=begin
--- cr
     \nɲä롣
=end
	def cr
		@item << "\n"
		self
	end
=begin
--- br
     <br>ɲä롣
=end
	def br
		@item << "<br>"
		self
	end
=begin
--- insertafter(target,*obj)
     ((|target|))ľ((|obj|))롣
=end
	def insertafter(target,*obj)
		@item[@item.index(target)+1,0] = obj
		self
	end
=begin
--- insertbefore(target,*obj)
     ((|target|))ľ((|obj|))롣
=end
	def insertbefore(target,*obj)
		@item[@item.index(target),0] = obj
		self
	end
=begin
--- to_s
     HTMLѴ롣
=end
	def to_s
		if @tagname =~ /\/$/
			"<" << @tagname.chop + @attr.collect{|name, value|
				if value==true
					' ' << name
				else
					' ' << name << '="' << CGI::escapeHTML(value) << '"' if value
				end
			}.to_s << '>' << @item.to_s
		else
			"<" << @tagname << @attr.collect{|name, value|
				if value==true
					' ' << name
				else
					' ' << name << '="' << CGI::escapeHTML(value) << '"' if value
				end
			}.to_s << '>' << @item.to_s << '</' << @tagname << '>'
		end
	end
end

=begin
== ȥåץ٥᥽å
--- Tag(tagname [, attr [, item]])
--- Tag(tagname [, attr [, item]]) {...}
     ֥Ȥ롣
     ֥åꤷƸƤӽФ줿硢֥åɾͤɲä롣
=end
def Tag(tagname,attr = {},item=[])
	obj = Tag.new(tagname,attr,item)
	if iterator?
		obj << yield
	end
	obj
end

=begin

== ѹ

* 2000/10/13 - MoonWolf
  * version 1.0.3
  * <<᥽åԶ罤
  * Hashλѹб

* 2000/09/26 - MoonWolf
  * version 1.0.2
  * Array#concat᥽åɤλѹб

* 2000/08/16 - MoonWolf
  * version 1.0.1
  * <<᥽åɤΰ*objobjѹ

* 2000/08/13 - MoonWolf
  * version 1.0.0
  * ǽΥ꡼

=end
