/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.popup.util;

import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseStep;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaseListPopupStep<T>
extends BaseStep<T>
implements ListPopupStep<T> {
    private String myTitle;
    private List<T> myValues;
    private List<? extends Icon> myIcons;
    private int myDefaultOptionIndex;

    @SafeVarargs
    public BaseListPopupStep(@Nullable String title, T ... values) {
        if (values == null) {
            BaseListPopupStep.$$$reportNull$$$0(0);
        }
        this(title, values, new Icon[0]);
    }

    public BaseListPopupStep(@Nullable String title, List<? extends T> values) {
        this(title, values, new ArrayList());
    }

    public BaseListPopupStep(@Nullable String title, T[] values, Icon[] icons) {
        this(title, Arrays.asList(values), Arrays.asList(icons));
    }

    public BaseListPopupStep(@Nullable String aTitle, @NotNull List<? extends T> aValues, Icon aSameIcon) {
        if (aValues == null) {
            BaseListPopupStep.$$$reportNull$$$0(1);
        }
        this.myDefaultOptionIndex = -1;
        ArrayList<Icon> icons = new ArrayList<Icon>();
        for (int i = 0; i < aValues.size(); ++i) {
            icons.add(aSameIcon);
        }
        this.init(aTitle, aValues, icons);
    }

    public BaseListPopupStep(@Nullable String title, @NotNull List<? extends T> values, List<? extends Icon> icons) {
        if (values == null) {
            BaseListPopupStep.$$$reportNull$$$0(2);
        }
        this.myDefaultOptionIndex = -1;
        this.init(title, values, icons);
    }

    protected BaseListPopupStep() {
        this.myDefaultOptionIndex = -1;
    }

    protected final void init(@Nullable String title, @NotNull List<? extends T> values, @Nullable List<? extends Icon> icons) {
        if (values == null) {
            BaseListPopupStep.$$$reportNull$$$0(3);
        }
        this.myTitle = title;
        this.myValues = new ArrayList<T>(values);
        this.myIcons = icons;
    }

    @Override
    @Nullable
    public final String getTitle() {
        return this.myTitle;
    }

    @Override
    @NotNull
    public final List<T> getValues() {
        List<T> list = this.myValues;
        if (list == null) {
            BaseListPopupStep.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Override
    public PopupStep onChosen(T selectedValue, boolean finalChoice) {
        return FINAL_CHOICE;
    }

    @Override
    public Icon getIconFor(T value) {
        int index2 = this.myValues.indexOf(value);
        if (index2 != -1 && this.myIcons != null && index2 < this.myIcons.size()) {
            return this.myIcons.get(index2);
        }
        return null;
    }

    @Nullable
    public Color getBackgroundFor(T value) {
        return null;
    }

    @Nullable
    public Color getForegroundFor(T value) {
        return null;
    }

    @Override
    @NotNull
    public String getTextFor(T value) {
        String string = value.toString();
        if (string == null) {
            BaseListPopupStep.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    @Nullable
    public ListSeparator getSeparatorAbove(T value) {
        return null;
    }

    @Override
    public boolean isSelectable(T value) {
        return true;
    }

    @Override
    public boolean hasSubstep(T selectedValue) {
        return false;
    }

    @Override
    public void canceled() {
    }

    public void setDefaultOptionIndex(int aDefaultOptionIndex) {
        this.myDefaultOptionIndex = aDefaultOptionIndex;
    }

    @Override
    public int getDefaultOptionIndex() {
        return this.myDefaultOptionIndex;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aValues";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/ui/popup/util/BaseListPopupStep";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/ui/popup/util/BaseListPopupStep";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getValues";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextFor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

