/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.TimedVcsCommit;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLogDiffHandler;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogProperties;
import com.intellij.vcs.log.VcsLogRefManager;
import com.intellij.vcs.log.VcsLogRefresher;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface VcsLogProvider {
    public static final ExtensionPointName<VcsLogProvider> LOG_PROVIDER_EP = ExtensionPointName.create((String)"com.intellij.logProvider");

    @NotNull
    public DetailedLogData readFirstBlock(@NotNull VirtualFile var1, @NotNull Requirements var2) throws VcsException;

    @NotNull
    public LogData readAllHashes(@NotNull VirtualFile var1, @NotNull Consumer<TimedVcsCommit> var2) throws VcsException;

    public void readAllFullDetails(@NotNull VirtualFile var1, @NotNull Consumer<VcsFullCommitDetails> var2) throws VcsException;

    default public void readFullDetails(@NotNull VirtualFile root, @NotNull List<String> hashes, @NotNull Consumer<VcsFullCommitDetails> commitConsumer) throws VcsException {
        if (root == null) {
            VcsLogProvider.$$$reportNull$$$0(0);
        }
        if (hashes == null) {
            VcsLogProvider.$$$reportNull$$$0(1);
        }
        if (commitConsumer == null) {
            VcsLogProvider.$$$reportNull$$$0(2);
        }
        this.readFullDetails(root, hashes, commitConsumer, false);
    }

    public void readFullDetails(@NotNull VirtualFile var1, @NotNull List<String> var2, @NotNull Consumer<VcsFullCommitDetails> var3, boolean var4) throws VcsException;

    @Deprecated
    @NotNull
    default public List<? extends VcsShortCommitDetails> readShortDetails(@NotNull VirtualFile root, @NotNull List<String> hashes) throws VcsException {
        if (root == null) {
            VcsLogProvider.$$$reportNull$$$0(3);
        }
        if (hashes == null) {
            VcsLogProvider.$$$reportNull$$$0(4);
        }
        List<? extends VcsCommitMetadata> list = this.readMetadata(root, hashes);
        if (list == null) {
            VcsLogProvider.$$$reportNull$$$0(5);
        }
        return list;
    }

    public List<? extends VcsCommitMetadata> readMetadata(@NotNull VirtualFile var1, @NotNull List<String> var2) throws VcsException;

    @Deprecated
    @NotNull
    default public List<? extends VcsFullCommitDetails> readFullDetails(@NotNull VirtualFile root, @NotNull List<String> hashes) throws VcsException {
        if (root == null) {
            VcsLogProvider.$$$reportNull$$$0(6);
        }
        if (hashes == null) {
            VcsLogProvider.$$$reportNull$$$0(7);
        }
        ArrayList result2 = ContainerUtil.newArrayList();
        this.readFullDetails(root, hashes, (Consumer<VcsFullCommitDetails>)((Consumer)result2::add));
        ArrayList arrayList = result2;
        if (arrayList == null) {
            VcsLogProvider.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @NotNull
    public VcsKey getSupportedVcs();

    @NotNull
    public VcsLogRefManager getReferenceManager();

    @NotNull
    public Disposable subscribeToRootRefreshEvents(@NotNull Collection<VirtualFile> var1, @NotNull VcsLogRefresher var2);

    @NotNull
    public List<TimedVcsCommit> getCommitsMatchingFilter(@NotNull VirtualFile var1, @NotNull VcsLogFilterCollection var2, int var3) throws VcsException;

    @Nullable
    public VcsUser getCurrentUser(@NotNull VirtualFile var1) throws VcsException;

    @NotNull
    public Collection<String> getContainingBranches(@NotNull VirtualFile var1, @NotNull Hash var2) throws VcsException;

    @Nullable
    public <T> T getPropertyValue(VcsLogProperties.VcsLogProperty<T> var1);

    @Nullable
    public String getCurrentBranch(@NotNull VirtualFile var1);

    @Nullable
    public VcsLogDiffHandler getDiffHandler();

    @Nullable
    default public VirtualFile getVcsRoot(@NotNull Project project, @NotNull FilePath filePath2) {
        if (project == null) {
            VcsLogProvider.$$$reportNull$$$0(9);
        }
        if (filePath2 == null) {
            VcsLogProvider.$$$reportNull$$$0(10);
        }
        return VcsUtil.getVcsRootFor(project, filePath2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashes";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitConsumer";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/VcsLogProvider";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/VcsLogProvider";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "readShortDetails";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "readFullDetails";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "readFullDetails";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "readShortDetails";
                break;
            }
            case 5: 
            case 8: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getVcsRoot";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface DetailedLogData {
        @NotNull
        public List<VcsCommitMetadata> getCommits();

        @NotNull
        public Set<VcsRef> getRefs();
    }

    public static interface LogData {
        @NotNull
        public Set<VcsRef> getRefs();

        @NotNull
        public Set<VcsUser> getUsers();
    }

    public static interface Requirements {
        public int getCommitCount();
    }
}

