/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.settings.coreModules;

import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.library.core.NodeCoreLibraryConfigurator;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.util.text.SemVer;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.SwingHelper;
import com.intellij.webcore.libraries.ui.ModuleScopeSelectionView;
import java.awt.Component;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NewSetupNodeCoreSourcesDialog
extends DialogWrapper {
    private final Project myProject;
    private final NodeJsInterpreter myInterpreter;
    private final SemVer myNodeVersion;
    private final JComponent myCenterPanel;
    private final ModuleScopeSelectionView myModuleScopeSelectionView;
    private final Runnable myDone;

    public NewSetupNodeCoreSourcesDialog(@NotNull Project project, @NotNull NodeJsInterpreter interpreter, @NotNull SemVer nodeVersion, @Nullable VirtualFile requestor, @Nullable Runnable onDone) {
        if (project == null) {
            NewSetupNodeCoreSourcesDialog.$$$reportNull$$$0(0);
        }
        if (interpreter == null) {
            NewSetupNodeCoreSourcesDialog.$$$reportNull$$$0(1);
        }
        if (nodeVersion == null) {
            NewSetupNodeCoreSourcesDialog.$$$reportNull$$$0(2);
        }
        super(project);
        this.myProject = project;
        this.myInterpreter = interpreter;
        this.myNodeVersion = nodeVersion;
        this.myDone = onDone;
        this.setTitle("Configure Node.js v" + nodeVersion.getRawVersion() + " Core Library");
        this.myModuleScopeSelectionView = new ModuleScopeSelectionView(project, requestor, true, true);
        JPanel usageScopePanel = SwingHelper.newLeftAlignedVerticalPanel((Component[])new Component[]{this.myModuleScopeSelectionView.getComponent()});
        usageScopePanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)JSBundle.message((String)"settings.nodejs.core_library.title", (Object[])new Object[0]), (boolean)true));
        this.myCenterPanel = usageScopePanel;
        SwingHelper.setPreferredWidth((Component)this.myCenterPanel, (int)JBUI.scale((int)350));
        this.setOKButtonText("Configure");
        this.init();
    }

    protected ValidationInfo doValidate() {
        return null;
    }

    protected JComponent createCenterPanel() {
        return this.myCenterPanel;
    }

    protected void doOKAction() {
        super.doOKAction();
        this.configureLibrary();
    }

    public void configureLibrary() {
        NodeCoreLibraryConfigurator configurator = NodeCoreLibraryConfigurator.getInstance(this.myProject);
        List roots = this.myModuleScopeSelectionView.getLibraryScope();
        configurator.configureAndAssociateWith(this.myInterpreter, this.myNodeVersion, roots, this.myDone);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "interpreter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "nodeVersion";
                break;
            }
        }
        objectArray[1] = "com/intellij/javascript/nodejs/settings/coreModules/NewSetupNodeCoreSourcesDialog";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

