/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types.guard;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSFreshObjectLiteralType;
import com.intellij.lang.javascript.psi.types.JSLiteralType;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.guard.JSControlFlowTypeGuard;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaScriptTypeGuard
extends JSControlFlowTypeGuard {
    public JavaScriptTypeGuard(@NotNull JSReferenceExpression reference, @Nullable JSType startType, @Nullable PsiElement resolveResult) {
        if (reference == null) {
            JavaScriptTypeGuard.$$$reportNull$$$0(0);
        }
        super(reference, startType, resolveResult, !(resolveResult instanceof JSParameter) && JavaScriptTypeGuard.useAutoVariableType(reference, startType));
    }

    public static boolean useAutoVariableType(@NotNull JSReferenceExpression reference, @Nullable JSType startType) {
        if (reference == null) {
            JavaScriptTypeGuard.$$$reportNull$$$0(1);
        }
        return reference.getQualifier() == null && (startType == null || !startType.getSource().isExplicitlyDeclared());
    }

    @Override
    @NotNull
    protected JSType narrowTypeByDiscriminantTruthiness(@NotNull JSType type, @NotNull JSExpression expression, boolean assumeTrue) {
        if (type == null) {
            JavaScriptTypeGuard.$$$reportNull$$$0(2);
        }
        if (expression == null) {
            JavaScriptTypeGuard.$$$reportNull$$$0(3);
        }
        if (!(expression instanceof JSReferenceExpression) || !assumeTrue) {
            JSType jSType = type;
            if (jSType == null) {
                JavaScriptTypeGuard.$$$reportNull$$$0(4);
            }
            return jSType;
        }
        JSType jSType = this.appendReferencedPropertyToType(type, (JSReferenceExpression)expression);
        if (jSType == null) {
            JavaScriptTypeGuard.$$$reportNull$$$0(5);
        }
        return jSType;
    }

    @NotNull
    private JSType appendReferencedPropertyToType(@NotNull JSType type, @NotNull JSReferenceExpression expression) {
        String name;
        if (type == null) {
            JavaScriptTypeGuard.$$$reportNull$$$0(6);
        }
        if (expression == null) {
            JavaScriptTypeGuard.$$$reportNull$$$0(7);
        }
        if (StringUtil.isEmpty((String)(name = expression.getReferenceName()))) {
            JSType jSType = type;
            if (jSType == null) {
                JavaScriptTypeGuard.$$$reportNull$$$0(8);
            }
            return jSType;
        }
        JSType jSType = this.appendProperty(type, name, (PsiElement)expression);
        if (jSType == null) {
            JavaScriptTypeGuard.$$$reportNull$$$0(9);
        }
        return jSType;
    }

    @NotNull
    private JSType appendProperty(@NotNull JSType type, @NotNull String name, @NotNull PsiElement resolveContext) {
        if (type == null) {
            JavaScriptTypeGuard.$$$reportNull$$$0(10);
        }
        if (name == null) {
            JavaScriptTypeGuard.$$$reportNull$$$0(11);
        }
        if (resolveContext == null) {
            JavaScriptTypeGuard.$$$reportNull$$$0(12);
        }
        if (!JavaScriptTypeGuard.isTypeCanBeExtended(type, name)) {
            JSType jSType = type;
            if (jSType == null) {
                JavaScriptTypeGuard.$$$reportNull$$$0(13);
            }
            return jSType;
        }
        JSRecordTypeImpl.PropertySignatureImpl signature = new JSRecordTypeImpl.PropertySignatureImpl(name, null, false, resolveContext);
        JSTypeSource source = JSTypeSourceFactory.createTypeSource((PsiElement)this.myReference, false);
        ImmutableList types = ContainerUtil.immutableList((Object[])new JSType[]{new JSRecordTypeImpl(source, Collections.singletonList(signature)), type});
        JSType jSType = JavaScriptTypeGuard.getUnionTypeWithProcessingDecorators((Collection<? extends JSType>)types, source);
        if (jSType == null) {
            JavaScriptTypeGuard.$$$reportNull$$$0(14);
        }
        return jSType;
    }

    private static boolean isTypeCanBeExtended(@NotNull JSType type, @NotNull String name) {
        if (type == null) {
            JavaScriptTypeGuard.$$$reportNull$$$0(15);
        }
        if (name == null) {
            JavaScriptTypeGuard.$$$reportNull$$$0(16);
        }
        if (type instanceof JSRecordType) {
            JSRecordType recordType = type.asRecordType();
            return recordType.findPropertySignature(name) == null;
        }
        return true;
    }

    @Override
    protected boolean isMatchingReferenceDiscriminantByTruthiness(@NotNull JSType type, @NotNull JSType topOwnerType, @Nullable PsiElement expression, boolean assumeTrue) {
        if (type == null) {
            JavaScriptTypeGuard.$$$reportNull$$$0(17);
        }
        if (topOwnerType == null) {
            JavaScriptTypeGuard.$$$reportNull$$$0(18);
        }
        if (!(expression instanceof JSReferenceExpression) || !assumeTrue) {
            return false;
        }
        JSReferenceExpression referenceExpression = (JSReferenceExpression)expression;
        String name = referenceExpression.getReferenceName();
        if (name == null) {
            return false;
        }
        JSExpression qualifier = referenceExpression.getQualifier();
        if (qualifier == null) {
            return false;
        }
        if (!this.isMatchingReference((PsiElement)this.myReference, (PsiElement)qualifier)) {
            return false;
        }
        ResolveResult[] results = ((JSReferenceExpression)expression).multiResolve(false);
        if (results.length == 0) {
            return true;
        }
        return !JSResolveUtil.isResolveStrict((JSReferenceExpression)expression, results);
    }

    @Override
    protected boolean isMatchingReferenceDiscriminantByEquality(@NotNull JSType type, @NotNull JSType topOwnerType, @Nullable PsiElement expression, boolean assumeTrue, @NotNull IElementType sign) {
        if (type == null) {
            JavaScriptTypeGuard.$$$reportNull$$$0(19);
        }
        if (topOwnerType == null) {
            JavaScriptTypeGuard.$$$reportNull$$$0(20);
        }
        if (sign == null) {
            JavaScriptTypeGuard.$$$reportNull$$$0(21);
        }
        return this.isMatchingReferenceDiscriminantByTruthiness(type, topOwnerType, expression, true);
    }

    @Override
    @NotNull
    protected JSType narrowTypeByDiscriminantEquality(@NotNull JSType type, boolean assumeTrue, @NotNull IElementType sign, @Nullable JSExpression toCheck, @Nullable JSExpression expression) {
        boolean isNonStrictEquality;
        if (type == null) {
            JavaScriptTypeGuard.$$$reportNull$$$0(22);
        }
        if (sign == null) {
            JavaScriptTypeGuard.$$$reportNull$$$0(23);
        }
        assumeTrue = assumeTrue != JavaScriptTypeGuard.isNegativeSign(sign);
        boolean bl = isNonStrictEquality = sign == JSTokenTypes.EQEQ || sign == JSTokenTypes.NE;
        if (!assumeTrue && isNonStrictEquality && JavaScriptTypeGuard.isUndefinedOrNullExpression(toCheck) && expression instanceof JSReferenceExpression) {
            JSType jSType = this.appendReferencedPropertyToType(type, (JSReferenceExpression)expression);
            if (jSType == null) {
                JavaScriptTypeGuard.$$$reportNull$$$0(24);
            }
            return jSType;
        }
        JSType jSType = type;
        if (jSType == null) {
            JavaScriptTypeGuard.$$$reportNull$$$0(25);
        }
        return jSType;
    }

    @Override
    @NotNull
    protected JSType narrowByCallExpression(@NotNull JSType rawType, @NotNull JSCallExpression expr, boolean assumeTrue) {
        if (rawType == null) {
            JavaScriptTypeGuard.$$$reportNull$$$0(26);
        }
        if (expr == null) {
            JavaScriptTypeGuard.$$$reportNull$$$0(27);
        }
        JSType jSType = this.narrowByHasOwnPropertyCall(rawType, expr, assumeTrue);
        if (jSType == null) {
            JavaScriptTypeGuard.$$$reportNull$$$0(28);
        }
        return jSType;
    }

    @NotNull
    private JSType narrowByHasOwnPropertyCall(@NotNull JSType rawType, @NotNull JSCallExpression expr, boolean assumeTrue) {
        JSExpression[] arguments;
        if (rawType == null) {
            JavaScriptTypeGuard.$$$reportNull$$$0(29);
        }
        if (expr == null) {
            JavaScriptTypeGuard.$$$reportNull$$$0(30);
        }
        if ((arguments = expr.getArguments()).length != 1) {
            JSType jSType = rawType;
            if (jSType == null) {
                JavaScriptTypeGuard.$$$reportNull$$$0(31);
            }
            return jSType;
        }
        JSExpression argument = arguments[0];
        if (!(argument instanceof JSLiteralExpression) || !((JSLiteralExpression)argument).isStringLiteral()) {
            JSType jSType = rawType;
            if (jSType == null) {
                JavaScriptTypeGuard.$$$reportNull$$$0(32);
            }
            return jSType;
        }
        JSExpression methodExpression = expr.getMethodExpression();
        if (!(methodExpression instanceof JSReferenceExpression)) {
            JSType jSType = rawType;
            if (jSType == null) {
                JavaScriptTypeGuard.$$$reportNull$$$0(33);
            }
            return jSType;
        }
        String name = ((JSReferenceExpression)methodExpression).getReferenceName();
        if (!"hasOwnProperty".equals(name)) {
            JSType jSType = rawType;
            if (jSType == null) {
                JavaScriptTypeGuard.$$$reportNull$$$0(34);
            }
            return jSType;
        }
        JSExpression qualifier = ((JSReferenceExpression)methodExpression).getQualifier();
        if (!this.isMatchingReference((PsiElement)this.myReference, (PsiElement)qualifier)) {
            JSType jSType = rawType;
            if (jSType == null) {
                JavaScriptTypeGuard.$$$reportNull$$$0(35);
            }
            return jSType;
        }
        String value = ((JSLiteralExpression)argument).getStringValue();
        if (StringUtil.isEmptyOrSpaces((String)value)) {
            JSType jSType = rawType;
            if (jSType == null) {
                JavaScriptTypeGuard.$$$reportNull$$$0(36);
            }
            return jSType;
        }
        JSType jSType = this.narrowTypeForPropertyWithName(rawType, (PsiElement)argument, value, assumeTrue);
        if (jSType == null) {
            JavaScriptTypeGuard.$$$reportNull$$$0(37);
        }
        return jSType;
    }

    @Override
    @NotNull
    protected JSType narrowTypeForPropertyWithName(@NotNull JSType type, @NotNull PsiElement propertySource, @NotNull String property, boolean assumeTrue) {
        if (type == null) {
            JavaScriptTypeGuard.$$$reportNull$$$0(38);
        }
        if (propertySource == null) {
            JavaScriptTypeGuard.$$$reportNull$$$0(39);
        }
        if (property == null) {
            JavaScriptTypeGuard.$$$reportNull$$$0(40);
        }
        if (!assumeTrue) {
            JSType jSType = type;
            if (jSType == null) {
                JavaScriptTypeGuard.$$$reportNull$$$0(41);
            }
            return jSType;
        }
        JSType jSType = this.appendProperty(type, property, propertySource);
        if (jSType == null) {
            JavaScriptTypeGuard.$$$reportNull$$$0(42);
        }
        return jSType;
    }

    @Override
    @Nullable
    protected JSType evaluateInitializerType(@Nullable PsiElement element) {
        JSExpression expression = JavaScriptTypeGuard.getInitializerExpression(element);
        if (expression == null) {
            return null;
        }
        JSType typeFromExpression = this.getExpressionTypeForTypeGuard(expression);
        if (typeFromExpression == null || typeFromExpression instanceof JSAnyType) {
            return this.getUnionTypeWithProcessingDecorators(JSAnyType.get(this.mySource.getSourceElement(), false), this.myDeclaredType.copyWithStrict(false)).copyWithStrict(false);
        }
        return typeFromExpression instanceof JSFreshObjectLiteralType || typeFromExpression instanceof JSLiteralType ? JSTypeUtils.getApparentType(typeFromExpression) : typeFromExpression;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 24: 
            case 25: 
            case 28: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 41: 
            case 42: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 24: 
            case 25: 
            case 28: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 41: 
            case 42: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 2: 
            case 6: 
            case 10: 
            case 15: 
            case 17: 
            case 19: 
            case 22: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 24: 
            case 25: 
            case 28: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 41: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/guard/JavaScriptTypeGuard";
                break;
            }
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveContext";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topOwnerType";
                break;
            }
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sign";
                break;
            }
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawType";
                break;
            }
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertySource";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/guard/JavaScriptTypeGuard";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "narrowTypeByDiscriminantTruthiness";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "appendReferencedPropertyToType";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "appendProperty";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "narrowTypeByDiscriminantEquality";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "narrowByCallExpression";
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "narrowByHasOwnPropertyCall";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "narrowTypeForPropertyWithName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "useAutoVariableType";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "narrowTypeByDiscriminantTruthiness";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 24: 
            case 25: 
            case 28: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 41: 
            case 42: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "appendReferencedPropertyToType";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "appendProperty";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isTypeCanBeExtended";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isMatchingReferenceDiscriminantByTruthiness";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isMatchingReferenceDiscriminantByEquality";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "narrowTypeByDiscriminantEquality";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "narrowByCallExpression";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "narrowByHasOwnPropertyCall";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "narrowTypeForPropertyWithName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 24: 
            case 25: 
            case 28: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 41: 
            case 42: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

