/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.flex.ImportUtils;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.validation.fixes.BaseCreateFix;
import com.intellij.lang.javascript.validation.fixes.FixAndIntentionAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import org.jetbrains.annotations.NotNull;

public class JSInsertCastFix
extends FixAndIntentionAction {
    private final String type;
    @NotNull
    private final DialectOptionHolder myDialectHolder;

    public JSInsertCastFix(String type, @NotNull DialectOptionHolder holder) {
        if (holder == null) {
            JSInsertCastFix.$$$reportNull$$$0(0);
        }
        this.type = type;
        this.myDialectHolder = holder;
    }

    @NotNull
    public String getName() {
        String key = this.myDialectHolder.isTypeScript ? "typescript.insert.cast.fix" : "javascript.insert.cast.fix";
        String string = JSBundle.message((String)key, (Object[])new Object[0]);
        if (string == null) {
            JSInsertCastFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    protected boolean isAvailable(Project project, PsiElement element, Editor editor, PsiFile file2) {
        String shortestTypeName;
        if (element instanceof JSLiteralExpression) {
            String literalType;
            JSLiteralExpression literalExpression = (JSLiteralExpression)element;
            JSType typ = JSResolveUtil.getExpressionJSType((JSExpression)literalExpression);
            String string = literalType = typ == null ? null : typ.getTypeText(JSType.TypeTextFormat.CODE);
            if (JSInsertCastFix.isNumericType(this.type) && "String".equals(literalType)) {
                return JSInsertCastFix.isValidNumber(StringUtil.unquoteString((String)literalExpression.getText()));
            }
        }
        return !this.myDialectHolder.isTypeScript || !TypeScriptUtil.hasAmbientExternalModuleInQName(this.type) || !TypeScriptUtil.hasAmbientExternalModuleInQName(shortestTypeName = this.getShortestType(element));
    }

    private static boolean isValidNumber(String text) {
        try {
            if (text.startsWith("0x") || text.startsWith("0X")) {
                Integer.parseInt(text.substring(2), 16);
            } else if (text.startsWith("0")) {
                Integer.parseInt(text, 8);
            } else {
                Double.parseDouble(text);
            }
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Override
    protected void applyFix(Project project, PsiElement element, PsiFile file2, Editor editor) {
        if (!FileModificationService.getInstance().preparePsiElementForWrite(element)) {
            return;
        }
        if (editor == null) {
            editor = BaseCreateFix.getEditor(project, element.getContainingFile());
        }
        if (editor == null) {
            return;
        }
        SmartPsiElementPointer p = SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer(element);
        String shortenedType = this.getShortestType(element);
        element = p.getElement();
        if (element == null) {
            return;
        }
        if (element instanceof JSLiteralExpression) {
            JSLiteralExpression literalExpression = (JSLiteralExpression)element;
            JSType type = JSResolveUtil.getExpressionJSType((JSExpression)literalExpression);
            String literalType = type == null ? null : type.getTypeText(JSType.TypeTextFormat.CODE);
            String text = literalExpression.getText();
            if ("String".equals(shortenedType) && JSInsertCastFix.isNumericType(literalType)) {
                JSInsertCastFix.replaceElementWithText(project, element, "\"" + text + "\"");
                return;
            }
            if (JSInsertCastFix.isNumericType(shortenedType) && "String".equals(literalType)) {
                if (JSInsertCastFix.isValidNumber(text = StringUtil.unquoteString((String)text))) {
                    JSInsertCastFix.replaceElementWithText(project, element, text);
                }
                return;
            }
        }
        TemplateManager templateManager = TemplateManager.getInstance((Project)project);
        Template template = templateManager.createTemplate("", "", JSInsertCastFix.getCast(shortenedType, "$SELECTION$", this.myDialectHolder, file2));
        template.setToReformat(true);
        template.setToShortenLongNames(false);
        int offset = element.getTextRange().getStartOffset();
        editor.getSelectionModel().setSelection(offset, offset + element.getTextLength());
        editor.getCaretModel().moveToOffset(offset);
        templateManager.startTemplate(editor, element.getText(), template);
    }

    private static boolean isNumericType(String literalType) {
        return "Number".equals(literalType) || "int".equals(literalType) || "uint".equals(literalType);
    }

    private static void replaceElementWithText(Project project, PsiElement element, String replacement) {
        WriteAction.run(() -> element.replace(JSChangeUtil.createExpressionFromText(project, replacement).getPsi()));
    }

    @NotNull
    public static String getCast(@NotNull String type, @NotNull String expr, @NotNull DialectOptionHolder holder, PsiFile file2) {
        if (type == null) {
            JSInsertCastFix.$$$reportNull$$$0(2);
        }
        if (expr == null) {
            JSInsertCastFix.$$$reportNull$$$0(3);
        }
        if (holder == null) {
            JSInsertCastFix.$$$reportNull$$$0(4);
        }
        if (holder.isTypeScript) {
            if (holder.isJSX || JSCodeStyleSettings.getSettings((PsiFile)file2).PREFER_AS_TYPE_CAST) {
                String string = expr + " as " + type;
                if (string == null) {
                    JSInsertCastFix.$$$reportNull$$$0(5);
                }
                return string;
            }
            String string = "<" + type + ">" + expr;
            if (string == null) {
                JSInsertCastFix.$$$reportNull$$$0(6);
            }
            return string;
        }
        String string = type + "(" + expr + ")";
        if (string == null) {
            JSInsertCastFix.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    public boolean startInWriteAction() {
        return true;
    }

    private String getShortestType(@NotNull PsiElement context) {
        if (context == null) {
            JSInsertCastFix.$$$reportNull$$$0(8);
        }
        if (this.myDialectHolder.isTypeScript && this.type != null) {
            return TypeScriptUtil.getShortestTypeNameInContext(this.type, context);
        }
        return (String)ImportUtils.importAndShortenReference((String)this.type, (PsiElement)context, (boolean)true, (boolean)true).first;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/validation/fixes/JSInsertCastFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/validation/fixes/JSInsertCastFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCast";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getCast";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getShortestType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

