/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.ui.AddServerForm;
import java.awt.Component;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nullable;

public class AddServerDialog
extends DialogWrapper {
    private AddServerForm myForm;
    private final boolean myRemoteServersOnly;
    private final boolean myGlobalServersOnly;

    public AddServerDialog(Component parent, boolean remoteServersOnly, @Nullable Project project) {
        super(parent, false);
        this.myRemoteServersOnly = remoteServersOnly;
        this.myGlobalServersOnly = project == null || project.isDefault();
        this.setTitle(WDBundle.message("add.server.dialog.title", new Object[0]));
        this.setSize(330, 180);
        this.init();
        this.getOKAction().setEnabled(false);
    }

    protected String getDimensionServiceKey() {
        return "WebDeployment.AddServerDialog.v.1";
    }

    protected JComponent createCenterPanel() {
        this.myForm = new AddServerForm(this.myRemoteServersOnly, this.myGlobalServersOnly);
        this.myForm.addListener(new AddServerForm.Listener(){

            @Override
            public void nameChanged() {
                AddServerDialog.this.getOKAction().setEnabled(StringUtil.isNotEmpty((String)AddServerDialog.this.myForm.getName()));
            }
        });
        return this.myForm.getContentPane();
    }

    public WebServerConfig getResult() {
        return this.myForm.getResult();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myForm.getPreferredFocusedComponent();
    }
}

