/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.slim;

import com.intellij.lang.Language;
import com.intellij.lexer.EmbeddedTokenTypesProvider;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.util.LayerDescriptor;
import com.intellij.openapi.editor.ex.util.LayeredLexerEditorHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.tree.IElementType;
import java.util.List;
import org.jetbrains.plugins.slim.SlimLanguage;

public final class SlimEditorHighlighter
extends LayeredLexerEditorHighlighter {
    private static final List<EmbeddedTokenTypesProvider> ourEmbeddedTokenTypesProviders = EmbeddedTokenTypesProvider.EXTENSION_POINT_NAME.getExtensionList();

    public SlimEditorHighlighter(EditorColorsScheme scheme, Project project, VirtualFile file) {
        super(SyntaxHighlighterFactory.getSyntaxHighlighter((Language)SlimLanguage.INSTANCE, (Project)project, (VirtualFile)file), scheme);
        this.registerEmbeddedTokenTypeProviderLayers(project, file);
    }

    private void registerEmbeddedTokenTypeProviderLayers(Project project, VirtualFile virtualFile) {
        for (EmbeddedTokenTypesProvider provider : ourEmbeddedTokenTypesProviders) {
            IElementType embeddedTokenType = provider.getElementType();
            Language language = embeddedTokenType.getLanguage();
            this.registerLayer(project, virtualFile, language, embeddedTokenType);
        }
    }

    private void registerLayer(Project project, VirtualFile virtualFile, Language language, IElementType tokenType) {
        SyntaxHighlighter embeddedHighlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)language, (Project)project, (VirtualFile)virtualFile);
        LayerDescriptor embeddedLayer = new LayerDescriptor(embeddedHighlighter, "\n");
        this.registerLayer(tokenType, embeddedLayer);
    }
}

