/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.slim.formatter;

import com.intellij.embedding.TemplateMasqueradingLexer;
import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.slim.SlimLanguage;
import org.jetbrains.plugins.slim.SlimUtil;
import org.jetbrains.plugins.slim.formatter.SlimFormattingModelBuilder;
import org.jetbrains.plugins.slim.psi.SlimTokenTypes;

public class SlimOuterBlock
implements ASTBlock {
    private final Block myDelegate;
    private final CodeStyleSettings mySettings;
    private List<Block> mySubBlocks = null;

    public SlimOuterBlock(Block delegate, CodeStyleSettings settings) {
        this.myDelegate = delegate;
        this.mySettings = settings;
    }

    @NotNull
    public TextRange getTextRange() {
        TextRange textRange = this.myDelegate.getTextRange();
        if (textRange == null) {
            SlimOuterBlock.$$$reportNull$$$0(0);
        }
        return textRange;
    }

    @NotNull
    public List<Block> getSubBlocks() {
        if (this.mySubBlocks == null) {
            this.mySubBlocks = this.generateSubBlocks();
        }
        List<Block> list = this.mySubBlocks;
        if (list == null) {
            SlimOuterBlock.$$$reportNull$$$0(1);
        }
        return list;
    }

    private List<Block> generateSubBlocks() {
        List subBlocks = this.myDelegate.getSubBlocks();
        ArrayList<Block> result = new ArrayList<Block>();
        for (Block original : subBlocks) {
            PsiElement psi = ASTBlock.getPsiElement((Block)original);
            if (psi != null && psi.getLanguage() == SlimLanguage.INSTANCE) {
                Block block = new SlimFormattingModelBuilder().createModel(psi, this.mySettings).getRootBlock();
                result.add(block);
                continue;
            }
            result.add((Block)new SlimOuterBlock(original, this.mySettings));
        }
        return result;
    }

    @Nullable
    public Wrap getWrap() {
        ASTNode prev;
        ASTNode grandpa;
        ASTNode node = ASTBlock.getNode((Block)this.myDelegate);
        if (node == null) {
            return this.myDelegate.getWrap();
        }
        ASTNode parent = node.getTreeParent();
        if (parent != null && parent.getFirstChildNode() == node && (grandpa = parent.getTreeParent()) != null && grandpa.getElementType() == SlimUtil.getOuterLanguageTokenType()) {
            return null;
        }
        for (prev = node.getTreePrev(); prev != null && prev.getElementType() == SlimTokenTypes.WHITESPACE; prev = prev.getTreePrev()) {
        }
        if (prev != null && prev.getElementType() == TemplateMasqueradingLexer.MINUS_TYPE) {
            return null;
        }
        return this.myDelegate.getWrap();
    }

    @Nullable
    public Indent getIndent() {
        PsiElement childPsi;
        ASTNode node = ASTBlock.getNode((Block)this.myDelegate);
        if (node == null) {
            return this.myDelegate.getIndent();
        }
        ASTNode firstChild = node.getFirstChildNode();
        if (firstChild != null && (childPsi = firstChild.getPsi()) != null && childPsi.getLanguage() == SlimLanguage.INSTANCE) {
            return Indent.getNormalIndent();
        }
        if (node.getElementType() == SlimUtil.getOuterLanguageTokenType()) {
            return Indent.getNoneIndent();
        }
        return this.myDelegate.getIndent();
    }

    @Nullable
    public Alignment getAlignment() {
        return null;
    }

    @Nullable
    public Spacing getSpacing(@Nullable Block child1, @NotNull Block child2) {
        if (child2 == null) {
            SlimOuterBlock.$$$reportNull$$$0(2);
        }
        return this.myDelegate.getSpacing(child1, child2);
    }

    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        ChildAttributes result = this.myDelegate.getChildAttributes(newChildIndex);
        Indent indent = result.getChildIndent();
        if (indent != null && indent.getType() == Indent.Type.NORMAL || indent.getType() == Indent.Type.SPACES) {
            result = new ChildAttributes(Indent.getNormalIndent(), result.getAlignment());
        }
        ChildAttributes childAttributes = result;
        if (childAttributes == null) {
            SlimOuterBlock.$$$reportNull$$$0(3);
        }
        return childAttributes;
    }

    public boolean isIncomplete() {
        return this.myDelegate.isIncomplete();
    }

    public boolean isLeaf() {
        return this.myDelegate.isLeaf();
    }

    public ASTNode getNode() {
        return ASTBlock.getNode((Block)this.myDelegate);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/slim/formatter/SlimOuterBlock";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextRange";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubBlocks";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/slim/formatter/SlimOuterBlock";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSpacing";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

