/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.ant;

import java.util.HashMap;
import java.util.Map;
import org.apache.ivy.core.settings.IvyVariableContainer;
import org.apache.ivy.core.settings.IvyVariableContainerImpl;
import org.apache.ivy.util.Message;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Property;

class IvyAntVariableContainer
extends IvyVariableContainerImpl
implements IvyVariableContainer {
    private Map overwrittenProperties = new HashMap();
    private Project project;

    public IvyAntVariableContainer(Project project) {
        this.project = project;
    }

    @Override
    public String getVariable(String string) {
        String string2 = (String)this.overwrittenProperties.get(string);
        if (string2 == null) {
            string2 = this.project.getProperty(string);
        }
        if (string2 == null) {
            string2 = super.getVariable(string);
        }
        return string2;
    }

    @Override
    public void setVariable(String string, String string2, boolean bl) {
        if (bl) {
            Message.debug("setting '" + string + "' to '" + string2 + "'");
            this.overwrittenProperties.put(string, this.substitute(string2));
        } else {
            super.setVariable(string, string2, bl);
        }
    }

    public void updateProject(String string) {
        HashMap hashMap = new HashMap(super.getVariables());
        hashMap.putAll(this.overwrittenProperties);
        for (Map.Entry entry : hashMap.entrySet()) {
            this.setPropertyIfNotSet((String)entry.getKey(), (String)entry.getValue());
            if (string == null) continue;
            this.setPropertyIfNotSet((String)entry.getKey() + "." + string, (String)entry.getValue());
        }
        if (this.getEnvironmentPrefix() != null) {
            Property property = new Property();
            property.setProject(this.project);
            property.setEnvironment(this.getEnvironmentPrefix());
            property.init();
            property.execute();
        }
    }

    private void setPropertyIfNotSet(String string, String string2) {
        if (this.project.getProperty(string) == null) {
            this.project.setProperty(string, string2);
        }
    }

    @Override
    public Object clone() {
        IvyAntVariableContainer ivyAntVariableContainer = (IvyAntVariableContainer)super.clone();
        ivyAntVariableContainer.overwrittenProperties = (HashMap)((HashMap)this.overwrittenProperties).clone();
        return ivyAntVariableContainer;
    }
}

