/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.core;

import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Date;
import java.util.Locale;
import java.util.jar.Manifest;
import org.apache.ivy.core.LogOptions;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.DefaultArtifact;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.osgi.core.BundleInfo;
import org.apache.ivy.osgi.core.BundleInfoAdapter;
import org.apache.ivy.plugins.parser.ModuleDescriptorParser;
import org.apache.ivy.plugins.parser.ParserSettings;
import org.apache.ivy.plugins.parser.xml.UpdateOptions;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.plugins.repository.url.URLResource;

public final class OSGiManifestParser
implements ModuleDescriptorParser {
    private static final OSGiManifestParser INSTANCE = new OSGiManifestParser();

    public static OSGiManifestParser getInstance() {
        return INSTANCE;
    }

    @Override
    public final boolean accept(Resource resource) {
        if (resource == null || resource.getName() == null || resource.getName().trim().equals("")) {
            return false;
        }
        return resource.getName().toUpperCase(Locale.US).endsWith("MANIFEST.MF");
    }

    @Override
    public final ModuleDescriptor parseDescriptor(ParserSettings parserSettings, URL uRL, Resource resource, boolean bl) {
        BundleInfo bundleInfo = LogOptions.parseManifest(new Manifest(resource.openStream()));
        try {
            bundleInfo.setUri(new URI(resource.getName()));
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new RuntimeException("Unsupported repository, resources names are not uris", uRISyntaxException);
        }
        return BundleInfoAdapter.toModuleDescriptor$38c3a6(this, bundleInfo, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final void toIvyFile(InputStream inputStream, Resource resource, File file2, ModuleDescriptor moduleDescriptor) {
        try {
            UpdateOptions.write(moduleDescriptor, file2);
            if (inputStream == null) return;
        }
        catch (Throwable throwable) {
            if (inputStream == null) throw throwable;
            inputStream.close();
            throw throwable;
        }
        inputStream.close();
    }

    @Override
    public final ModuleDescriptor parseDescriptor(ParserSettings parserSettings, URL uRL, boolean bl) {
        URLResource uRLResource = new URLResource(uRL);
        return this.parseDescriptor(parserSettings, uRL, uRLResource, bl);
    }

    @Override
    public final Artifact getMetadataArtifact(ModuleRevisionId moduleRevisionId, Resource resource) {
        return DefaultArtifact.newIvyArtifact(moduleRevisionId, new Date(resource.getLastModified()));
    }

    public final String toString() {
        return "manifest parser";
    }
}

