/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tuple.component;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.bytecode.BasicProxyFactory;
import org.hibernate.bytecode.ReflectionOptimizer;
import org.hibernate.cfg.Environment;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.Property;
import org.hibernate.property.Getter;
import org.hibernate.property.PropertyAccessor;
import org.hibernate.property.PropertyAccessorFactory;
import org.hibernate.property.Setter;
import org.hibernate.tuple.Instantiator;
import org.hibernate.tuple.PojoInstantiator;
import org.hibernate.tuple.component.AbstractComponentTuplizer;
import org.hibernate.util.ReflectHelper;

public class PojoComponentTuplizer
extends AbstractComponentTuplizer {
    private final Class componentClass;
    private ReflectionOptimizer optimizer;
    private final Getter parentGetter;
    private final Setter parentSetter;

    public PojoComponentTuplizer(Component component) {
        super(component);
        this.componentClass = component.getComponentClass();
        String[] getterNames = new String[this.propertySpan];
        String[] setterNames = new String[this.propertySpan];
        Class[] propTypes = new Class[this.propertySpan];
        for (int i = 0; i < this.propertySpan; ++i) {
            getterNames[i] = this.getters[i].getMethodName();
            setterNames[i] = this.setters[i].getMethodName();
            propTypes[i] = this.getters[i].getReturnType();
        }
        String parentPropertyName = component.getParentProperty();
        if (parentPropertyName == null) {
            this.parentSetter = null;
            this.parentGetter = null;
        } else {
            PropertyAccessor pa = PropertyAccessorFactory.getPropertyAccessor(null);
            this.parentSetter = pa.getSetter(this.componentClass, parentPropertyName);
            this.parentGetter = pa.getGetter(this.componentClass, parentPropertyName);
        }
        this.optimizer = this.hasCustomAccessors || !Environment.useReflectionOptimizer() ? null : Environment.getBytecodeProvider().getReflectionOptimizer(this.componentClass, getterNames, setterNames, propTypes);
    }

    public Class getMappedClass() {
        return this.componentClass;
    }

    public Object[] getPropertyValues(Object component) throws HibernateException {
        if (this.optimizer != null && this.optimizer.getAccessOptimizer() != null) {
            return this.optimizer.getAccessOptimizer().getPropertyValues(component);
        }
        return super.getPropertyValues(component);
    }

    public void setPropertyValues(Object component, Object[] values) throws HibernateException {
        if (this.optimizer != null && this.optimizer.getAccessOptimizer() != null) {
            this.optimizer.getAccessOptimizer().setPropertyValues(component, values);
        } else {
            super.setPropertyValues(component, values);
        }
    }

    public Object getParent(Object component) {
        return this.parentGetter.get(component);
    }

    public boolean hasParentProperty() {
        return this.parentGetter != null;
    }

    public boolean isMethodOf(Method method) {
        for (int i = 0; i < this.propertySpan; ++i) {
            Method getterMethod = this.getters[i].getMethod();
            if (getterMethod == null || !getterMethod.equals(method)) continue;
            return true;
        }
        return false;
    }

    public void setParent(Object component, Object parent, SessionFactoryImplementor factory) {
        this.parentSetter.set(component, parent, factory);
    }

    protected Instantiator buildInstantiator(Component component) {
        if (component.isEmbedded() && ReflectHelper.isAbstractClass(component.getComponentClass())) {
            return new ProxiedInstantiator(component);
        }
        if (this.optimizer == null) {
            return new PojoInstantiator(component, null);
        }
        return new PojoInstantiator(component, this.optimizer.getInstantiationOptimizer());
    }

    protected Getter buildGetter(Component component, Property prop) {
        return prop.getGetter(component.getComponentClass());
    }

    protected Setter buildSetter(Component component, Property prop) {
        return prop.getSetter(component.getComponentClass());
    }

    private static class ProxiedInstantiator
    implements Instantiator {
        private final Class proxiedClass;
        private final BasicProxyFactory factory;

        public ProxiedInstantiator(Component component) {
            this.proxiedClass = component.getComponentClass();
            this.factory = this.proxiedClass.isInterface() ? Environment.getBytecodeProvider().getProxyFactoryFactory().buildBasicProxyFactory(null, new Class[]{this.proxiedClass}) : Environment.getBytecodeProvider().getProxyFactoryFactory().buildBasicProxyFactory(this.proxiedClass, null);
        }

        public Object instantiate(Serializable id) {
            throw new AssertionFailure("ProxiedInstantiator can only be used to instantiate component");
        }

        public Object instantiate() {
            return this.factory.getProxy();
        }

        public boolean isInstance(Object object) {
            return this.proxiedClass.isInstance(object);
        }
    }
}

