/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.plugin.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import net.sourceforge.squirrel_sql.client.plugin.PluginQueryTokenizerPreferencesManager;
import net.sourceforge.squirrel_sql.fw.preferences.IQueryTokenizerPreferenceBean;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class PluginQueryTokenizerPreferencesPanel
extends JPanel {
    protected static final int LEFT_INDENT_INSET_SIZE = 35;
    private static final long serialVersionUID = 1L;
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(PluginQueryTokenizerPreferencesPanel.class);
    protected PluginQueryTokenizerPreferencesManager _prefsManager = null;
    protected JCheckBox useCustomQTCheckBox = null;
    protected JLabel useCustomQTLabel = null;
    protected JCheckBox removeMultiLineCommentCheckBox = null;
    protected JTextField lineCommentTextField = null;
    protected JLabel lineCommentLabel = null;
    protected JLabel procedureSeparatorLabel = null;
    protected JTextField procedureSeparatorTextField = null;
    protected JLabel statementSeparatorLabel = null;
    protected JTextField statementSeparatorTextField = null;
    protected String _databaseName = null;
    protected boolean _showProcSep = true;
    protected int lastY = 0;

    public PluginQueryTokenizerPreferencesPanel(PluginQueryTokenizerPreferencesManager prefsMgr, String databaseName) {
        this(prefsMgr, databaseName, true);
    }

    public PluginQueryTokenizerPreferencesPanel(PluginQueryTokenizerPreferencesManager prefsMgr, String databaseName, boolean showProcedureSeparator) {
        this._prefsManager = prefsMgr;
        this._databaseName = databaseName;
        this._showProcSep = showProcedureSeparator;
        this.createGUI();
        this.loadData();
    }

    private void createGUI() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 0.4;
        this.add((Component)this.createTopPanel(), c);
    }

    protected JPanel createTopPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        String borderLabel = s_stringMgr.getString("PreferencesPanel.borderLabel", this._databaseName);
        result.setBorder(this.getTitledBorder(borderLabel));
        this.addUseCustomQTCheckBox(result, 0, this.lastY++);
        this.addLineCommentLabel(result, 0, this.lastY);
        this.addLineCommentTextField(result, 1, this.lastY++);
        this.addStatementSeparatorLabel(result, 0, this.lastY);
        this.addStatementSeparatorTextField(result, 1, this.lastY++);
        if (this._showProcSep) {
            this.addProcedureSeparatorLabel(result, 0, this.lastY);
            this.addProcedureSeparatorTextField(result, 1, this.lastY++);
        }
        this.addRemoveMultiLineCommentCheckBox(result, 0, this.lastY++);
        return result;
    }

    private void addUseCustomQTCheckBox(JPanel panel, int col, int row) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = col;
        c.gridy = row;
        c.insets = new Insets(5, 5, 0, 0);
        c.anchor = 17;
        c.gridwidth = 2;
        this.useCustomQTCheckBox = new JCheckBox(i18n.USE_CUSTOM_QT_LABEL);
        this.useCustomQTCheckBox.setName("useCustomQTCheckBox");
        String USE_CUSTOM_QT_TOOLTIP = s_stringMgr.getString("PreferencesPanel.useCustomQTToolTip", this._databaseName);
        this.useCustomQTCheckBox.setToolTipText(USE_CUSTOM_QT_TOOLTIP);
        this.useCustomQTCheckBox.addActionListener(new UseQTHandler());
        panel.add((Component)this.useCustomQTCheckBox, c);
    }

    private void addRemoveMultiLineCommentCheckBox(JPanel panel, int col, int row) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = col;
        c.gridy = row;
        c.gridwidth = 2;
        c.insets = new Insets(5, 30, 0, 0);
        String cbLabel = i18n.REMOVE_ML_COMMENT_LABEL;
        this.removeMultiLineCommentCheckBox = new JCheckBox(cbLabel);
        this.removeMultiLineCommentCheckBox.setName("removeMultiLineCommentCheckBox");
        this.removeMultiLineCommentCheckBox.setToolTipText(i18n.REMOVE_ML_COMMENT_LABEL_TT);
        panel.add((Component)this.removeMultiLineCommentCheckBox, c);
    }

    private void addStatementSeparatorLabel(JPanel panel, int col, int row) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = col;
        c.gridy = row;
        c.insets = new Insets(5, 35, 0, 0);
        c.anchor = 17;
        this.statementSeparatorLabel = new JLabel(i18n.STMT_SEP_LABEL);
        this.statementSeparatorLabel.setHorizontalAlignment(2);
        this.statementSeparatorLabel.setToolTipText(i18n.STMT_SEP_LABEL_TT);
        panel.add((Component)this.statementSeparatorLabel, c);
    }

    private void addStatementSeparatorTextField(JPanel panel, int col, int row) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = col;
        c.gridy = row;
        c.ipadx = 40;
        c.insets = new Insets(5, 5, 0, 0);
        c.anchor = 17;
        this.statementSeparatorTextField = new JTextField(10);
        this.statementSeparatorTextField.setName("statementSeparatorTextField");
        this.statementSeparatorTextField.setHorizontalAlignment(4);
        this.statementSeparatorTextField.setToolTipText(i18n.STMT_SEP_LABEL_TT);
        panel.add((Component)this.statementSeparatorTextField, c);
    }

    private void addLineCommentLabel(JPanel panel, int col, int row) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = col;
        c.gridy = row;
        c.insets = new Insets(5, 35, 0, 0);
        c.anchor = 17;
        this.lineCommentLabel = new JLabel(i18n.LINE_COMMENT_LABEL);
        this.lineCommentLabel.setHorizontalAlignment(2);
        this.lineCommentLabel.setToolTipText(i18n.LINE_COMMENT_LABEL_TT);
        panel.add((Component)this.lineCommentLabel, c);
    }

    private void addLineCommentTextField(JPanel panel, int col, int row) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = col;
        c.gridy = row;
        c.ipadx = 40;
        c.insets = new Insets(5, 5, 0, 0);
        c.anchor = 17;
        this.lineCommentTextField = new JTextField(10);
        this.lineCommentTextField.setName("lineCommentTextField");
        this.lineCommentTextField.setHorizontalAlignment(4);
        this.lineCommentTextField.setToolTipText(i18n.LINE_COMMENT_LABEL_TT);
        panel.add((Component)this.lineCommentTextField, c);
    }

    private void addProcedureSeparatorLabel(JPanel panel, int col, int row) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = col;
        c.gridy = row;
        c.insets = new Insets(5, 35, 0, 0);
        this.procedureSeparatorLabel = new JLabel(i18n.PROC_SEP_LABEL);
        this.procedureSeparatorLabel.setHorizontalAlignment(4);
        this.procedureSeparatorLabel.setToolTipText(i18n.PROC_SEP_LABEL_TT);
        panel.add((Component)this.procedureSeparatorLabel, c);
    }

    private void addProcedureSeparatorTextField(JPanel panel, int col, int row) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = col;
        c.gridy = row;
        c.ipadx = 40;
        c.insets = new Insets(5, 5, 0, 0);
        c.anchor = 17;
        this.procedureSeparatorTextField = new JTextField(10);
        this.procedureSeparatorTextField.setHorizontalAlignment(4);
        this.procedureSeparatorTextField.setToolTipText(i18n.PROC_SEP_LABEL_TT);
        panel.add((Component)this.procedureSeparatorTextField, c);
    }

    private Border getTitledBorder(String title) {
        CompoundBorder border = new CompoundBorder(new EmptyBorder(10, 10, 10, 10), new TitledBorder(title));
        return border;
    }

    protected void loadData() {
        IQueryTokenizerPreferenceBean _prefs = this._prefsManager.getPreferences();
        this.removeMultiLineCommentCheckBox.setSelected(_prefs.isRemoveMultiLineComments());
        this.lineCommentTextField.setText(_prefs.getLineComment());
        this.statementSeparatorTextField.setText(_prefs.getStatementSeparator());
        if (this._showProcSep) {
            this.procedureSeparatorTextField.setText(_prefs.getProcedureSeparator());
        }
        this.useCustomQTCheckBox.setSelected(_prefs.isInstallCustomQueryTokenizer());
        this.updatePreferenceState();
    }

    protected void save() {
        IQueryTokenizerPreferenceBean _prefs = this._prefsManager.getPreferences();
        _prefs.setRemoveMultiLineComments(this.removeMultiLineCommentCheckBox.isSelected());
        _prefs.setLineComment(this.lineCommentTextField.getText());
        _prefs.setStatementSeparator(this.statementSeparatorTextField.getText());
        if (this._showProcSep) {
            _prefs.setProcedureSeparator(this.procedureSeparatorTextField.getText());
        }
        _prefs.setInstallCustomQueryTokenizer(this.useCustomQTCheckBox.isSelected());
        this._prefsManager.savePrefs();
    }

    public void applyChanges() {
        this.save();
    }

    public Component getPanelComponent() {
        return this;
    }

    private void updatePreferenceState() {
        if (this.useCustomQTCheckBox.isSelected()) {
            this.removeMultiLineCommentCheckBox.setEnabled(true);
            this.lineCommentTextField.setEnabled(true);
            this.lineCommentLabel.setEnabled(true);
            this.statementSeparatorTextField.setEnabled(true);
            this.statementSeparatorLabel.setEnabled(true);
            if (this._showProcSep) {
                this.procedureSeparatorLabel.setEnabled(true);
                this.procedureSeparatorTextField.setEnabled(true);
            }
        } else {
            this.removeMultiLineCommentCheckBox.setEnabled(false);
            this.lineCommentTextField.setEnabled(false);
            this.lineCommentLabel.setEnabled(false);
            this.statementSeparatorTextField.setEnabled(false);
            this.statementSeparatorLabel.setEnabled(false);
            if (this._showProcSep) {
                this.procedureSeparatorLabel.setEnabled(false);
                this.procedureSeparatorTextField.setEnabled(false);
            }
        }
    }

    static /* synthetic */ StringManager access$000() {
        return s_stringMgr;
    }

    private class UseQTHandler
    implements ActionListener {
        private UseQTHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            PluginQueryTokenizerPreferencesPanel.this.updatePreferenceState();
        }
    }

    static interface i18n {
        public static final String USE_CUSTOM_QT_LABEL = PluginQueryTokenizerPreferencesPanel.access$000().getString("PreferencesPanel.useCustomQTLabel");
        public static final String REMOVE_ML_COMMENT_LABEL = PluginQueryTokenizerPreferencesPanel.access$000().getString("PreferencesPanel.removeMultiLineCommentLabel");
        public static final String REMOVE_ML_COMMENT_LABEL_TT = PluginQueryTokenizerPreferencesPanel.access$000().getString("PreferencesPanel.removeMultiLineCommentLabelTipText");
        public static final String STMT_SEP_LABEL = PluginQueryTokenizerPreferencesPanel.access$000().getString("PreferencesPanel.statementSeparatorLabel");
        public static final String STMT_SEP_LABEL_TT = PluginQueryTokenizerPreferencesPanel.access$000().getString("PreferencesPanel.statementSeparatorToolTip");
        public static final String LINE_COMMENT_LABEL = PluginQueryTokenizerPreferencesPanel.access$000().getString("PreferencesPanel.lineCommentLabel");
        public static final String LINE_COMMENT_LABEL_TT = PluginQueryTokenizerPreferencesPanel.access$000().getString("PreferencesPanel.lineCommentToolTip");
        public static final String PROC_SEP_LABEL = PluginQueryTokenizerPreferencesPanel.access$000().getString("PreferencesPanel.procedureSeparatorLabel");
        public static final String PROC_SEP_LABEL_TT = PluginQueryTokenizerPreferencesPanel.access$000().getString("PreferencesPanel.procedureSeparatorToolTip");
    }
}

