/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui;

import java.awt.Color;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.fife.ui.FontDialog;

public class FontSelector
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    public static final int LABELED = 0;
    public static final int NOT_LABELED = 1;
    public static final int CHECK_BOX = 2;
    private JComponent labelComp;
    private FontTextField field;
    private boolean underline;
    private JButton browseButton;
    private boolean underlineSelectable;
    private boolean colorSelectable;
    private Color fontColor;
    public static final String ENABLED_PROPERTY = "enabled";
    public static final String FONT_PROPERTY = "font";
    public static final String FONT_COLOR_PROPERTY = "fontColor";
    private static final String MSG = "org.fife.ui.FontSelector";
    private static final ResourceBundle msg = ResourceBundle.getBundle("org.fife.ui.FontSelector");

    public FontSelector() {
        this(0);
    }

    public FontSelector(int type) {
        this.setLayout(new BoxLayout(this, 2));
        this.setAlignmentX(0.0f);
        this.field = new FontTextField();
        switch (type) {
            default: {
                JLabel label = new JLabel(msg.getString("FontTitle"));
                label.setLabelFor(this.field);
                this.labelComp = label;
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                JCheckBox cb = new JCheckBox(msg.getString("FontTitle"), true);
                cb.addActionListener(this);
                this.labelComp = cb;
            }
        }
        this.browseButton = new JButton(msg.getString("Browse"));
        this.browseButton.addActionListener(this);
        if (this.labelComp != null) {
            this.add(this.labelComp);
            this.add(Box.createHorizontalStrut(5));
        }
        this.add(this.field);
        this.add(Box.createHorizontalStrut(5));
        this.add(this.browseButton);
        this.add(Box.createHorizontalGlue());
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.browseButton) {
            Window parent = SwingUtilities.getWindowAncestor(this);
            FontDialog fd = null;
            fd = parent instanceof Frame ? new FontDialog((Frame)parent, msg.getString("Font"), this.field.getDisplayedFont(), this.fontColor, this.underlineSelectable, this.colorSelectable) : new FontDialog((Dialog)parent, msg.getString("Font"), this.field.getDisplayedFont(), this.fontColor, this.underlineSelectable, this.colorSelectable);
            fd.setUnderlineSelected(this.underline);
            fd.setLocationRelativeTo(parent);
            fd.setVisible(true);
            Font f = fd.getSelectedFont();
            if (f != null) {
                this.underline = fd.getUnderlineSelected();
                this.field.setDisplayedFont(f, this.underline);
                this.firePropertyChange(FONT_PROPERTY, null, f);
            }
            this.fontColor = fd.getSelectedColor();
            if (this.fontColor != null) {
                this.firePropertyChange(FONT_COLOR_PROPERTY, null, this.fontColor);
            }
        } else if (e.getSource() == this.labelComp) {
            JCheckBox cb = (JCheckBox)this.labelComp;
            boolean selected = cb.isSelected();
            this.field.setEnabled(selected);
            this.browseButton.setEnabled(selected);
            this.firePropertyChange(ENABLED_PROPERTY, !selected, selected);
        }
    }

    public Font getDisplayedFont() {
        return this.field.getDisplayedFont();
    }

    public Color getFontColor() {
        return this.isColorSelectable() ? this.fontColor : null;
    }

    public boolean getUnderline() {
        return this.underline;
    }

    public boolean isColorSelectable() {
        return this.colorSelectable;
    }

    public boolean isToggledOn() {
        return this.labelComp == null || this.labelComp instanceof JLabel || ((JCheckBox)this.labelComp).isSelected();
    }

    public boolean isUnderlineSelectable() {
        return this.underlineSelectable;
    }

    public void setColorSelectable(boolean selectable) {
        this.colorSelectable = selectable;
    }

    public void setDisplayedFont(Font font, boolean underline) {
        this.field.setDisplayedFont(font, underline);
        this.underline = underline;
    }

    public void setFontColor(Color color) {
        if (this.isColorSelectable()) {
            this.fontColor = color;
        }
    }

    public void setToggledOn(boolean toggled) {
        if (this.labelComp instanceof JCheckBox) {
            JCheckBox cb = (JCheckBox)this.labelComp;
            cb.setSelected(toggled);
            this.field.setEnabled(toggled);
            this.browseButton.setEnabled(toggled);
        }
    }

    public void setUnderlineSelectable(boolean selectable) {
        this.underlineSelectable = selectable;
    }

    private static class FontTextField
    extends JTextField {
        private static final long serialVersionUID = 1L;
        private Font displayedFont;

        public FontTextField() {
            this.setEditable(false);
        }

        public Font getDisplayedFont() {
            return this.displayedFont;
        }

        public void setDisplayedFont(Font font, boolean underline) {
            this.displayedFont = font;
            Font ourFont = font.deriveFont(this.getFont().getSize2D());
            this.setFont(ourFont);
            this.setText(ourFont.getFamily() + " " + this.displayedFont.getSize() + (font.isBold() ? " Bold" : "") + (font.isItalic() ? " Italic" : "") + (underline ? " Underline" : ""));
        }
    }
}

