package ONVIF::Device::Types::CellLayout;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS = 'ONVIF::Device::Types::CellLayout::_CellLayout::XmlAttr';

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %Transformation_of :ATTR(:get<Transformation>);

__PACKAGE__->_factory(
    [ qw(        Transformation

    ) ],
    {
        'Transformation' => \%Transformation_of,
    },
    {
        'Transformation' => 'ONVIF::Device::Types::Transformation',
    },
    {

        'Transformation' => 'Transformation',
    }
);

} # end BLOCK




package ONVIF::Device::Types::CellLayout::_CellLayout::XmlAttr;
use base qw(SOAP::WSDL::XSD::Typelib::AttributeSet);

{ # BLOCK to scope variables

my %Columns_of :ATTR(:get<Columns>);
my %Rows_of :ATTR(:get<Rows>);

__PACKAGE__->_factory(
    [ qw(
        Columns
        Rows
    ) ],
    {

        Columns => \%Columns_of,

        Rows => \%Rows_of,
    },
    {
        Columns => 'SOAP::WSDL::XSD::Typelib::Builtin::integer',
        Rows => 'SOAP::WSDL::XSD::Typelib::Builtin::integer',
    }
);

} # end BLOCK




1;


=pod

=head1 NAME

ONVIF::Device::Types::CellLayout

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
CellLayout from the namespace http://www.onvif.org/ver10/schema.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * Transformation




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::Device::Types::CellLayout
   Transformation =>  { # ONVIF::Device::Types::Transformation
     Translate => ,
     Scale => ,
     Extension =>  { # ONVIF::Device::Types::TransformationExtension
     },
   },
 },



=head2 attr

NOTE: Attribute documentation is experimental, and may be inaccurate.
See the correspondent WSDL/XML Schema if in question.

This class has additional attributes, accessibly via the C<attr()> method.

attr() returns an object of the class ONVIF::Device::Types::CellLayout::_CellLayout::XmlAttr.

The following attributes can be accessed on this object via the corresponding
get_/set_ methods:

=over

=item * Columns

 Number of columns of the cell grid (x dimension)



This attribute is of type L<SOAP::WSDL::XSD::Typelib::Builtin::integer|SOAP::WSDL::XSD::Typelib::Builtin::integer>.

=item * Rows

 Number of rows of the cell grid (y dimension)



This attribute is of type L<SOAP::WSDL::XSD::Typelib::Builtin::integer|SOAP::WSDL::XSD::Typelib::Builtin::integer>.


=back




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

